/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.workflows;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.workflows.model.WorkflowStep;
import com.crowdin.client.workflows.model.WorkflowStepResponseList;
import com.crowdin.client.workflows.model.WorkflowStepResponseObject;
import com.crowdin.client.workflows.model.WorkflowTemplate;
import com.crowdin.client.workflows.model.WorkflowTemplateResponseList;
import com.crowdin.client.workflows.model.WorkflowTemplateResponseObject;
import java.util.Map;
import java.util.Optional;

public class WorkflowsApi
extends CrowdinApi {
    public WorkflowsApi(Credentials credentials) {
        super(credentials);
    }

    public WorkflowsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<WorkflowStep> listWorkflowSteps(Long projectId) throws HttpException, HttpBadRequestException {
        WorkflowStepResponseList workflowStepResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/workflow-steps", new HttpRequestConfig(), WorkflowStepResponseList.class);
        return WorkflowStepResponseList.to(workflowStepResponseList);
    }

    public ResponseObject<WorkflowStep> getWorkflowStep(Long projectId, Long stepId) throws HttpException, HttpBadRequestException {
        WorkflowStepResponseObject workflowStepResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/workflow-steps/" + stepId, new HttpRequestConfig(), WorkflowStepResponseObject.class);
        return ResponseObject.of(workflowStepResponseObject.getData());
    }

    public ResponseList<WorkflowTemplate> listWorkflowTemplates(Long groupId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("groupId", Optional.ofNullable(groupId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        WorkflowTemplateResponseList workflowTemplateResponseList = this.httpClient.get(this.url + "/workflow-templates", new HttpRequestConfig(queryParams), WorkflowTemplateResponseList.class);
        return WorkflowTemplateResponseList.to(workflowTemplateResponseList);
    }

    public ResponseObject<WorkflowTemplate> getWorkflowTemplate(Long templateId) throws HttpException, HttpBadRequestException {
        WorkflowTemplateResponseObject workflowTemplateResponseObject = this.httpClient.get(this.url + "/workflow-templates/" + templateId, new HttpRequestConfig(), WorkflowTemplateResponseObject.class);
        return ResponseObject.of(workflowTemplateResponseObject.getData());
    }
}

