/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class JarRunner {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("JarRunner expects first argument to be path to jar file to run.  Received no args");
            System.exit(1);
        }
        try {
            String[] stringArray2 = new String[stringArray.length - 1];
            if (stringArray2.length > 0) {
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            }
            JarRunner.run(new File(stringArray[0]), stringArray2);
        }
        catch (Exception exception) {
            System.err.println("Exception thrown while running jar " + stringArray[0]);
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void run(File file, String[] stringArray) throws Exception {
        System.out.println("Running " + file + " with args " + Arrays.toString(stringArray));
        JarFile jarFile = new JarFile(file);
        String string = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String string2 = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(file.toURL());
        for (String string3 : string2.split(" ")) {
            if (string3.startsWith("http:") || string3.startsWith("file:") || string3.startsWith("https:")) {
                arrayList.add(new URL(string3));
                continue;
            }
            File file2 = new File(file.getParentFile(), string3);
            if (!file2.exists()) continue;
            arrayList.add(file2.toURL());
        }
        System.out.println("ClassPath=" + arrayList);
        Class<?> clazz = JarRunner.class.getClassLoader().loadClass(string);
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{stringArray});
    }
}

