/*
 * Decompiled with CFR 0.152.
 */
package com.theweflex.react;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXFileObject;
import com.tencent.mm.opensdk.modelmsg.WXImageObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMiniProgramObject;
import com.tencent.mm.opensdk.modelmsg.WXMusicObject;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelmsg.WXVideoObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.modelpay.PayResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;

public class WeChatModule
extends ReactContextBaseJavaModule
implements IWXAPIEventHandler {
    private String appId;
    private IWXAPI api = null;
    private static final String NOT_REGISTERED = "registerApp required.";
    private static final String INVOKE_FAILED = "WeChat API invoke returns false.";
    private static final String INVALID_ARGUMENT = "invalid argument.";
    private static ArrayList<WeChatModule> modules = new ArrayList();

    public WeChatModule(ReactApplicationContext context) {
        super(context);
    }

    public String getName() {
        return "RCTWeChat";
    }

    public boolean canOverrideExistingModule() {
        return true;
    }

    public void initialize() {
        super.initialize();
        modules.add(this);
    }

    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        if (this.api != null) {
            this.api = null;
        }
        modules.remove((Object)this);
    }

    public static void handleIntent(Intent intent) {
        for (WeChatModule mod : modules) {
            mod.api.handleIntent(intent, (IWXAPIEventHandler)mod);
        }
    }

    @ReactMethod
    public void registerApp(String appid, Callback callback) {
        this.appId = appid;
        this.api = WXAPIFactory.createWXAPI((Context)this.getReactApplicationContext().getBaseContext(), (String)appid, (boolean)true);
        callback.invoke(new Object[]{null, this.api.registerApp(appid)});
    }

    @ReactMethod
    public void isWXAppInstalled(Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.api.isWXAppInstalled()});
    }

    @ReactMethod
    public void isWXAppSupportApi(String supportApi, Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        int supportSDKINT = 0x22000001;
        switch (supportApi) {
            case "SDK_INT": {
                supportSDKINT = 621086720;
                break;
            }
            case "MIN_SDK_INT": {
                supportSDKINT = 0x21010001;
                break;
            }
            case "CHECK_TOKEN_SDK_INT": {
                supportSDKINT = 620824064;
                break;
            }
            case "TIMELINE_SUPPORTED_SDK_INT": {
                supportSDKINT = 0x21020001;
                break;
            }
            case "EMOJI_SUPPORTED_SDK_INT": {
                supportSDKINT = 553844737;
                break;
            }
            case "MUSIC_DATA_URL_SUPPORTED_SDK_INT": {
                supportSDKINT = 553910273;
                break;
            }
            case "PAY_SUPPORTED_SDK_INT": {
                supportSDKINT = 0x22000001;
                break;
            }
            case "OPENID_SUPPORTED_SDK_INT": {
                supportSDKINT = 0x22000001;
                break;
            }
            case "FAVORITE_SUPPPORTED_SDK_INT": {
                supportSDKINT = 0x22000001;
                break;
            }
            case "MESSAGE_ACTION_SUPPPORTED_SDK_INT": {
                supportSDKINT = 570490883;
                break;
            }
            case "SCAN_QRCODE_AUTH_SUPPORTED_SDK_INT": {
                supportSDKINT = 587268097;
                break;
            }
            case "MINIPROGRAM_SUPPORTED_SDK_INT": {
                supportSDKINT = 620756993;
                break;
            }
            case "VIDEO_FILE_SUPPORTED_SDK_INT": {
                supportSDKINT = 620756996;
                break;
            }
            case "SUBSCRIBE_MESSAGE_SUPPORTED_SDK_INT": {
                supportSDKINT = 620756998;
                break;
            }
            case "LAUNCH_MINIPROGRAM_SUPPORTED_SDK_INT": {
                supportSDKINT = 620757000;
                break;
            }
            case "CHOOSE_INVOICE_TILE_SUPPORT_SDK_INT": {
                supportSDKINT = 620822528;
                break;
            }
            case "INVOICE_AUTH_INSERT_SDK_INT": {
                supportSDKINT = 620823552;
                break;
            }
            case "NON_TAX_PAY_SDK_INT": {
                supportSDKINT = 620823552;
                break;
            }
            case "PAY_INSURANCE_SDK_INT": {
                supportSDKINT = 620823552;
                break;
            }
            case "SUBSCRIBE_MINI_PROGRAM_MSG_SUPPORTED_SDK_INT": {
                supportSDKINT = 620823808;
                break;
            }
            case "OFFLINE_PAY_SDK_INT": {
                supportSDKINT = 620823808;
                break;
            }
            case "SEND_TO_SPECIFIED_CONTACT_SDK_INT": {
                supportSDKINT = 620824064;
                break;
            }
            case "OPEN_BUSINESS_WEBVIEW_SDK_INT": {
                supportSDKINT = 620824064;
            }
        }
        boolean isWXAppSupportAPI = this.api.getWXAppSupportAPI() >= supportSDKINT;
        callback.invoke(new Object[]{null, isWXAppSupportAPI});
    }

    @ReactMethod
    public void getApiVersion(Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.api.getWXAppSupportAPI()});
    }

    @ReactMethod
    public void openWXApp(Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.api.openWXApp()});
    }

    @ReactMethod
    public void sendAuthRequest(String scope, String state, Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        SendAuth.Req req = new SendAuth.Req();
        req.scope = scope;
        req.state = state;
        callback.invoke(new Object[]{null, this.api.sendReq((BaseReq)req)});
    }

    @ReactMethod
    public void shareToTimeline(ReadableMap data, Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(1, data, callback);
    }

    @ReactMethod
    public void shareToSession(ReadableMap data, Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(0, data, callback);
    }

    @ReactMethod
    public void shareToFavorite(ReadableMap data, Callback callback) {
        if (this.api == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(2, data, callback);
    }

    @ReactMethod
    public void pay(ReadableMap data, Callback callback) {
        PayReq payReq = new PayReq();
        if (data.hasKey("partnerId")) {
            payReq.partnerId = data.getString("partnerId");
        }
        if (data.hasKey("prepayId")) {
            payReq.prepayId = data.getString("prepayId");
        }
        if (data.hasKey("nonceStr")) {
            payReq.nonceStr = data.getString("nonceStr");
        }
        if (data.hasKey("timeStamp")) {
            payReq.timeStamp = data.getString("timeStamp");
        }
        if (data.hasKey("sign")) {
            payReq.sign = data.getString("sign");
        }
        if (data.hasKey("package")) {
            payReq.packageValue = data.getString("package");
        }
        if (data.hasKey("extData")) {
            payReq.extData = data.getString("extData");
        }
        payReq.appId = this.appId;
        callback.invoke(new Object[]{this.api.sendReq((BaseReq)payReq) ? null : INVOKE_FAILED});
    }

    private void _share(final int scene, final ReadableMap data, final Callback callback) {
        Uri uri = null;
        if (data.hasKey("thumbImage")) {
            String imageUrl = data.getString("thumbImage");
            try {
                uri = Uri.parse((String)imageUrl);
                if (uri.getScheme() == null) {
                    uri = WeChatModule.getResourceDrawableUri((Context)this.getReactApplicationContext(), imageUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uri != null) {
            this._getImage(uri, new ResizeOptions(100, 100), new ImageCallback(){

                @Override
                public void invoke(@Nullable Bitmap bitmap) {
                    WeChatModule.this._share(scene, data, bitmap, callback);
                }
            });
        } else {
            this._share(scene, data, null, callback);
        }
    }

    private void _getImage(Uri uri, ResizeOptions resizeOptions, final ImageCallback imageCallback) {
        BaseBitmapDataSubscriber dataSubscriber = new BaseBitmapDataSubscriber(){

            protected void onNewResultImpl(Bitmap bitmap) {
                bitmap = bitmap.copy(bitmap.getConfig(), true);
                imageCallback.invoke(bitmap);
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                imageCallback.invoke(null);
            }
        };
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)uri);
        if (resizeOptions != null) {
            builder = builder.setResizeOptions(resizeOptions);
        }
        ImageRequest imageRequest = builder.build();
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, null);
        dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    private static Uri getResourceDrawableUri(Context context, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase().replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        if (resId == 0) {
            return null;
        }
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    private void _share(final int scene, final ReadableMap data, final Bitmap thumbImage, final Callback callback) {
        if (!data.hasKey("type")) {
            callback.invoke(new Object[]{INVALID_ARGUMENT});
            return;
        }
        String type = data.getString("type");
        WXWebpageObject mediaObject = null;
        if (type.equals("news")) {
            mediaObject = this._jsonToWebpageMedia(data);
        } else if (type.equals("text")) {
            mediaObject = this._jsonToTextMedia(data);
        } else {
            if (type.equals("imageUrl") || type.equals("imageResource")) {
                this.__jsonToImageUrlMedia(data, new MediaObjectCallback(){

                    @Override
                    public void invoke(@Nullable WXMediaMessage.IMediaObject mediaObject) {
                        if (mediaObject == null) {
                            callback.invoke(new Object[]{WeChatModule.INVALID_ARGUMENT});
                        } else {
                            WeChatModule.this._share(scene, data, thumbImage, mediaObject, callback);
                        }
                    }
                });
                return;
            }
            if (type.equals("imageFile")) {
                this.__jsonToImageFileMedia(data, new MediaObjectCallback(){

                    @Override
                    public void invoke(@Nullable WXMediaMessage.IMediaObject mediaObject) {
                        if (mediaObject == null) {
                            callback.invoke(new Object[]{WeChatModule.INVALID_ARGUMENT});
                        } else {
                            WeChatModule.this._share(scene, data, thumbImage, mediaObject, callback);
                        }
                    }
                });
                return;
            }
            if (type.equals("video")) {
                mediaObject = this.__jsonToVideoMedia(data);
            } else if (type.equals("audio")) {
                mediaObject = this.__jsonToMusicMedia(data);
            } else if (type.equals("file")) {
                mediaObject = this.__jsonToFileMedia(data);
            } else if (type.equals("miniProgram")) {
                mediaObject = this.__jsonToMiniProgramMedia(data);
            }
        }
        if (mediaObject == null) {
            callback.invoke(new Object[]{INVALID_ARGUMENT});
        } else {
            this._share(scene, data, thumbImage, (WXMediaMessage.IMediaObject)mediaObject, callback);
        }
    }

    private WXMiniProgramObject __jsonToMiniProgramMedia(ReadableMap data) {
        if (!data.hasKey("userName")) {
            return null;
        }
        WXMiniProgramObject miniProgramObj = new WXMiniProgramObject();
        miniProgramObj.webpageUrl = data.getString("webpageUrl");
        miniProgramObj.userName = data.getString("userName");
        miniProgramObj.path = data.getString("path");
        miniProgramObj.miniprogramType = data.getInt("miniProgramType");
        return miniProgramObj;
    }

    private void _share(int scene, ReadableMap data, Bitmap thumbImage, WXMediaMessage.IMediaObject mediaObject, Callback callback) {
        WXMediaMessage message = new WXMediaMessage();
        message.mediaObject = mediaObject;
        if (thumbImage != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            thumbImage.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            message.thumbData = baos.toByteArray();
            thumbImage.recycle();
        }
        if (data.hasKey("title")) {
            message.title = data.getString("title");
        }
        if (data.hasKey("description")) {
            message.description = data.getString("description");
        }
        if (data.hasKey("mediaTagName")) {
            message.mediaTagName = data.getString("mediaTagName");
        }
        if (data.hasKey("messageAction")) {
            message.messageAction = data.getString("messageAction");
        }
        if (data.hasKey("messageExt")) {
            message.messageExt = data.getString("messageExt");
        }
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.message = message;
        req.scene = scene;
        req.transaction = UUID.randomUUID().toString();
        callback.invoke(new Object[]{null, this.api.sendReq((BaseReq)req)});
    }

    private WXTextObject _jsonToTextMedia(ReadableMap data) {
        if (!data.hasKey("description")) {
            return null;
        }
        WXTextObject ret = new WXTextObject();
        ret.text = data.getString("description");
        return ret;
    }

    private WXWebpageObject _jsonToWebpageMedia(ReadableMap data) {
        if (!data.hasKey("webpageUrl")) {
            return null;
        }
        WXWebpageObject ret = new WXWebpageObject();
        ret.webpageUrl = data.getString("webpageUrl");
        if (data.hasKey("extInfo")) {
            ret.extInfo = data.getString("extInfo");
        }
        return ret;
    }

    private void __jsonToImageMedia(String imageUrl, final MediaObjectCallback callback) {
        Uri imageUri;
        try {
            imageUri = Uri.parse((String)imageUrl);
            if (imageUri.getScheme() == null) {
                imageUri = WeChatModule.getResourceDrawableUri((Context)this.getReactApplicationContext(), imageUrl);
            }
        }
        catch (Exception e) {
            imageUri = null;
        }
        if (imageUri == null) {
            callback.invoke(null);
            return;
        }
        this._getImage(imageUri, null, new ImageCallback(){

            @Override
            public void invoke(@Nullable Bitmap bitmap) {
                callback.invoke((WXMediaMessage.IMediaObject)(bitmap == null ? null : new WXImageObject(bitmap)));
            }
        });
    }

    private void __jsonToImageUrlMedia(ReadableMap data, MediaObjectCallback callback) {
        if (!data.hasKey("imageUrl")) {
            callback.invoke(null);
            return;
        }
        String imageUrl = data.getString("imageUrl");
        this.__jsonToImageMedia(imageUrl, callback);
    }

    private void __jsonToImageFileMedia(ReadableMap data, MediaObjectCallback callback) {
        if (!data.hasKey("imageUrl")) {
            callback.invoke(null);
            return;
        }
        String imageUrl = data.getString("imageUrl");
        if (!imageUrl.toLowerCase().startsWith("file://")) {
            imageUrl = "file://" + imageUrl;
        }
        this.__jsonToImageMedia(imageUrl, callback);
    }

    private WXMusicObject __jsonToMusicMedia(ReadableMap data) {
        if (!data.hasKey("musicUrl")) {
            return null;
        }
        WXMusicObject ret = new WXMusicObject();
        ret.musicUrl = data.getString("musicUrl");
        return ret;
    }

    private WXVideoObject __jsonToVideoMedia(ReadableMap data) {
        if (!data.hasKey("videoUrl")) {
            return null;
        }
        WXVideoObject ret = new WXVideoObject();
        ret.videoUrl = data.getString("videoUrl");
        return ret;
    }

    private WXFileObject __jsonToFileMedia(ReadableMap data) {
        if (!data.hasKey("filePath")) {
            return null;
        }
        return new WXFileObject(data.getString("filePath"));
    }

    public void onReq(BaseReq baseReq) {
    }

    public void onResp(BaseResp baseResp) {
        WritableMap map = Arguments.createMap();
        map.putInt("errCode", baseResp.errCode);
        map.putString("errStr", baseResp.errStr);
        map.putString("openId", baseResp.openId);
        map.putString("transaction", baseResp.transaction);
        if (baseResp instanceof SendAuth.Resp) {
            SendAuth.Resp resp = (SendAuth.Resp)baseResp;
            map.putString("type", "SendAuth.Resp");
            map.putString("code", resp.code);
            map.putString("state", resp.state);
            map.putString("url", resp.url);
            map.putString("lang", resp.lang);
            map.putString("country", resp.country);
        } else if (baseResp instanceof SendMessageToWX.Resp) {
            SendMessageToWX.Resp resp = (SendMessageToWX.Resp)baseResp;
            map.putString("type", "SendMessageToWX.Resp");
        } else if (baseResp instanceof PayResp) {
            PayResp resp = (PayResp)baseResp;
            map.putString("type", "PayReq.Resp");
            map.putString("returnKey", resp.returnKey);
        }
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("WeChat_Resp", (Object)map);
    }

    private static interface MediaObjectCallback {
        public void invoke(@Nullable WXMediaMessage.IMediaObject var1);
    }

    private static interface ImageCallback {
        public void invoke(@Nullable Bitmap var1);
    }
}

