/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.mediapipepose;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import expo.modules.kotlin.AppContext;
import expo.modules.kotlin.views.ExpoView;
import expo.modules.mediapipepose.PoseOverlayView;
import expo.modules.mediapipepose.ReactNativeMediapipePoseView;
import expo.modules.mediapipepose.camera.CameraController;
import expo.modules.mediapipepose.interfaces.CameraControllerDelegate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J0\u0010#\u001a\u00020\u00152\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lexpo/modules/mediapipepose/ReactNativeMediapipePoseView;", "Lexpo/modules/kotlin/views/ExpoView;", "context", "Landroid/content/Context;", "appContext", "Lexpo/modules/kotlin/AppContext;", "<init>", "(Landroid/content/Context;Lexpo/modules/kotlin/AppContext;)V", "previewView", "Landroidx/camera/view/PreviewView;", "fpsTextView", "Landroid/widget/TextView;", "overlayView", "Lexpo/modules/mediapipepose/PoseOverlayView;", "isActive", "", "showFps", "cameraController", "Lexpo/modules/mediapipepose/camera/CameraController;", "shouldInitializeCamera", "initializeCameraIfNeeded", "", "initializeCamera", "bindCameraToView", "setActive", "active", "controller", "setShowFps", "show", "setOverlayColor", "color", "", "updateFps", "fps", "", "updatePoseLandmarks", "landmarks", "", "", "imageWidth", "", "imageHeight", "Companion", "react-native-mediapipe-pose_debug"})
public final class ReactNativeMediapipePoseView
extends ExpoView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreviewView previewView;
    @NotNull
    private final TextView fpsTextView;
    @NotNull
    private final PoseOverlayView overlayView;
    private boolean isActive;
    private boolean showFps;
    @Nullable
    private CameraController cameraController;
    private boolean shouldInitializeCamera;
    @NotNull
    private static final String TAG = "MediapipePoseView";

    /*
     * WARNING - void declaration
     */
    public ReactNativeMediapipePoseView(@NotNull Context context, @NotNull AppContext appContext) {
        void $this$overlayView_u24lambda_u243;
        Object $this$fpsTextView_u24lambda_u242;
        FrameLayout.LayoutParams layoutParams;
        PreviewView $this$previewView_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        super(context, appContext);
        PreviewView previewView = object = new PreviewView(context);
        ReactNativeMediapipePoseView reactNativeMediapipePoseView = this;
        boolean bl = false;
        $this$previewView_u24lambda_u240.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        $this$previewView_u24lambda_u240.setScaleType(PreviewView.ScaleType.FILL_CENTER);
        reactNativeMediapipePoseView.previewView = object;
        $this$previewView_u24lambda_u240 = object = new TextView(context);
        reactNativeMediapipePoseView = this;
        boolean bl2 = false;
        FrameLayout.LayoutParams layoutParams2 = layoutParams = new FrameLayout.LayoutParams(-2, -2);
        void var8_9 = $this$fpsTextView_u24lambda_u242;
        boolean bl3 = false;
        $this$fpsTextView_u24lambda_u242_u24lambda_u241.topMargin = 20;
        $this$fpsTextView_u24lambda_u242_u24lambda_u241.leftMargin = 20;
        var8_9.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        $this$fpsTextView_u24lambda_u242.setTextSize(16.0f);
        $this$fpsTextView_u24lambda_u242.setTextColor(-1);
        $this$fpsTextView_u24lambda_u242.setShadowLayer(1.0f, 0.0f, 1.0f, -16777216);
        $this$fpsTextView_u24lambda_u242.setVisibility(8);
        reactNativeMediapipePoseView.fpsTextView = object;
        $this$fpsTextView_u24lambda_u242 = object = new PoseOverlayView(context);
        reactNativeMediapipePoseView = this;
        boolean bl4 = false;
        $this$overlayView_u24lambda_u243.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        reactNativeMediapipePoseView.overlayView = object;
        this.addView((View)this.previewView);
        this.addView(this.overlayView);
        this.addView((View)this.fpsTextView);
        Log.d((String)TAG, (String)"MediaPipe pose view initialized");
        this.initializeCameraIfNeeded();
    }

    private final void initializeCameraIfNeeded() {
        Log.d((String)TAG, (String)"Checking if camera initialization is needed...");
        Context context = this.getContext();
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0) {
            Log.d((String)TAG, (String)"Camera permission granted, initializing camera...");
            this.shouldInitializeCamera = true;
            this.initializeCamera();
        } else {
            Log.d((String)TAG, (String)"Camera permission not granted, will initialize when permission is available");
        }
    }

    private final void initializeCamera() {
        try {
            LifecycleOwner lifecycleOwner;
            Log.d((String)TAG, (String)"Starting camera initialization...");
            Context context = this.getContext();
            LifecycleOwner lifecycleOwner2 = context instanceof LifecycleOwner ? (LifecycleOwner)context : null;
            if (lifecycleOwner2 == null) {
                Object object;
                Context context2 = this.getContext();
                Activity activity = context2 instanceof Activity ? (Activity)context2 : null;
                if (activity != null) {
                    Activity activity2 = activity;
                    boolean bl = false;
                    object = activity2 instanceof LifecycleOwner ? activity2 : null;
                } else {
                    object = null;
                }
                lifecycleOwner2 = (LifecycleOwner)object;
            }
            if ((lifecycleOwner = lifecycleOwner2) != null) {
                Log.d((String)TAG, (String)"Found lifecycle owner, creating camera controller...");
                CameraControllerDelegate delegate2 = new CameraControllerDelegate(this){
                    final /* synthetic */ ReactNativeMediapipePoseView this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onCameraInitialized() {
                        Log.d((String)"MediapipePoseView", (String)"Camera initialized from view");
                    }

                    public void onCameraStarted() {
                        Log.d((String)"MediapipePoseView", (String)"Camera started from view");
                        this.this$0.post(() -> initializeCamera.delegate.1.onCameraStarted$lambda$0(this.this$0));
                    }

                    public void onCameraStopped() {
                        Log.d((String)"MediapipePoseView", (String)"Camera stopped from view");
                    }

                    public void onCameraSwitched(boolean isFrontCamera) {
                        Log.d((String)"MediapipePoseView", (String)"Camera switched from view");
                    }

                    public void onCameraError(String error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        Log.e((String)"MediapipePoseView", (String)("Camera error from view: " + error));
                    }

                    public void onFrameReceived(ImageProxy imageProxy) {
                        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
                        imageProxy.close();
                    }

                    private static final void onCameraStarted$lambda$0(ReactNativeMediapipePoseView this$0) {
                        ReactNativeMediapipePoseView.access$bindCameraToView(this$0);
                    }
                };
                Context context3 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
                CameraController cameraController = this.cameraController = new CameraController(context3, lifecycleOwner, delegate2);
                if (cameraController != null) {
                    cameraController.initialize();
                }
                CameraController cameraController2 = this.cameraController;
                if (cameraController2 != null) {
                    cameraController2.startCamera();
                }
                v6 = Log.d((String)TAG, (String)"Camera controller created and started");
            } else {
                v6 = Log.e((String)TAG, (String)"Could not find lifecycle owner for camera initialization");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to initialize camera from view", (Throwable)e);
        }
    }

    private final void bindCameraToView() {
        Preview preview;
        Log.d((String)TAG, (String)"Binding camera to view...");
        CameraController cameraController = this.cameraController;
        Object object = preview = cameraController != null ? cameraController.getPreview() : null;
        if (preview != null) {
            preview.setSurfaceProvider(this.previewView.getSurfaceProvider());
            v2 = Log.d((String)TAG, (String)"Camera preview bound to view successfully");
        } else {
            v2 = Log.w((String)TAG, (String)"Preview is null when trying to bind");
        }
    }

    public final void setActive(boolean active, @Nullable CameraController controller) {
        CameraController effectiveController;
        Log.d((String)TAG, (String)("Setting active state: " + active + ", controller: " + (controller != null)));
        this.isActive = active;
        CameraController cameraController = this.cameraController;
        if (cameraController == null) {
            cameraController = effectiveController = controller;
        }
        if (active && effectiveController != null) {
            Log.d((String)TAG, (String)"Binding camera preview to view");
            Preview preview = effectiveController.getPreview();
            Log.d((String)TAG, (String)("Preview object: " + (preview != null)));
            if (preview != null) {
                preview.setSurfaceProvider(this.previewView.getSurfaceProvider());
                v1 = Log.d((String)TAG, (String)"Surface provider set successfully");
            } else {
                v1 = Log.w((String)TAG, (String)"Preview is null - camera may not be started yet");
            }
        } else if (active && effectiveController == null) {
            Log.d((String)TAG, (String)"Active but no controller - trying to initialize camera...");
            this.initializeCameraIfNeeded();
        } else {
            Log.d((String)TAG, (String)("Not binding camera - active: " + active + ", controller: " + (effectiveController != null)));
        }
    }

    public final void setShowFps(boolean show) {
        this.showFps = show;
        this.fpsTextView.setVisibility(show ? 0 : 8);
    }

    public final void setOverlayColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        try {
            int colorInt = Color.parseColor((String)color);
            this.overlayView.setOverlayColor(colorInt);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Invalid color format: " + color), (Throwable)e);
        }
    }

    public final void updateFps(float fps) {
        if (this.showFps) {
            String string = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf(fps)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.fpsTextView.setText((CharSequence)("FPS: " + string2));
        }
    }

    public final void updatePoseLandmarks(@NotNull List<? extends Map<String, Float>> landmarks, int imageWidth, int imageHeight) {
        Intrinsics.checkNotNullParameter(landmarks, (String)"landmarks");
        this.overlayView.updatePoseLandmarks(landmarks, imageWidth, imageHeight);
    }

    public static final /* synthetic */ void access$bindCameraToView(ReactNativeMediapipePoseView $this) {
        $this.bindCameraToView();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lexpo/modules/mediapipepose/ReactNativeMediapipePoseView$Companion;", "", "<init>", "()V", "TAG", "", "react-native-mediapipe-pose_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

