/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.mediapipepose.camera;

import android.content.Context;
import android.util.Log;
import android.util.Size;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import expo.modules.mediapipepose.interfaces.CameraControllerDelegate;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0015J\u0006\u0010%\u001a\u00020\u0017J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010&\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lexpo/modules/mediapipepose/camera/CameraController;", "", "context", "Landroid/content/Context;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "delegate", "Lexpo/modules/mediapipepose/interfaces/CameraControllerDelegate;", "<init>", "(Landroid/content/Context;Landroidx/lifecycle/LifecycleOwner;Lexpo/modules/mediapipepose/interfaces/CameraControllerDelegate;)V", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "camera", "Landroidx/camera/core/Camera;", "preview", "Landroidx/camera/core/Preview;", "imageAnalysis", "Landroidx/camera/core/ImageAnalysis;", "cameraExecutor", "Ljava/util/concurrent/Executor;", "cameraFacing", "", "isRunning", "", "targetResolution", "Landroid/util/Size;", "targetFrameRate", "initialize", "", "startCamera", "stopCamera", "switchCamera", "updateResolution", "width", "height", "updateFrameRate", "fps", "isFrontCamera", "getPreview", "processImageFrame", "imageProxy", "Landroidx/camera/core/ImageProxy;", "cleanup", "Companion", "react-native-mediapipe-pose_debug"})
public final class CameraController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @Nullable
    private final CameraControllerDelegate delegate;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    @Nullable
    private Camera camera;
    @Nullable
    private Preview preview;
    @Nullable
    private ImageAnalysis imageAnalysis;
    @NotNull
    private Executor cameraExecutor;
    private int cameraFacing;
    private boolean isRunning;
    @NotNull
    private Size targetResolution;
    private int targetFrameRate;
    @NotNull
    private static final String TAG = "CameraController";

    public CameraController(@NotNull Context context, @NotNull LifecycleOwner lifecycleOwner, @Nullable CameraControllerDelegate delegate2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        this.context = context;
        this.lifecycleOwner = lifecycleOwner;
        this.delegate = delegate2;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.cameraExecutor = executorService;
        this.targetResolution = new Size(640, 480);
        this.targetFrameRate = 30;
    }

    public final void initialize() {
        Log.d((String)TAG, (String)"Initializing camera controller");
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getInstance(...)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(() -> CameraController.initialize$lambda$0(this, cameraProviderFuture), ContextCompat.getMainExecutor((Context)this.context));
    }

    public final void startCamera() {
        block12: {
            ProcessCameraProvider processCameraProvider;
            block11: {
                Object object;
                Log.d((String)TAG, (String)"Starting camera");
                processCameraProvider = this.cameraProvider;
                if (processCameraProvider == null) break block11;
                ProcessCameraProvider provider = processCameraProvider;
                boolean bl = false;
                try {
                    provider.unbindAll();
                    CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.cameraFacing).build();
                    Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"build(...)");
                    CameraSelector cameraSelector2 = cameraSelector;
                    this.preview = new Preview.Builder().setTargetResolution(this.targetResolution).build();
                    ImageAnalysis imageAnalysis = this.imageAnalysis = new ImageAnalysis.Builder().setTargetResolution(this.targetResolution).setBackpressureStrategy(0).setOutputImageFormat(1).build();
                    if (imageAnalysis != null) {
                        imageAnalysis.setAnalyzer(this.cameraExecutor, arg_0 -> CameraController.startCamera$lambda$2$lambda$1(this, arg_0));
                    }
                    UseCase[] useCaseArray = new UseCase[]{this.preview, this.imageAnalysis};
                    this.camera = provider.bindToLifecycle(this.lifecycleOwner, cameraSelector2, useCaseArray);
                    this.isRunning = true;
                    CameraControllerDelegate cameraControllerDelegate = this.delegate;
                    if (cameraControllerDelegate != null) {
                        cameraControllerDelegate.onCameraStarted();
                    }
                    object = Log.d((String)TAG, (String)"Camera started successfully");
                }
                catch (Exception e) {
                    Unit unit;
                    Log.e((String)TAG, (String)"Camera start failed", (Throwable)e);
                    CameraControllerDelegate cameraControllerDelegate = this.delegate;
                    if (cameraControllerDelegate != null) {
                        cameraControllerDelegate.onCameraError("Failed to start camera: " + e.getMessage());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    object = unit;
                }
                Unit unit = object;
                processCameraProvider = unit;
                if (unit != null) break block12;
            }
            CameraController $this$startCamera_u24lambda_u243 = this;
            boolean bl = false;
            CameraControllerDelegate cameraControllerDelegate = $this$startCamera_u24lambda_u243.delegate;
            if (cameraControllerDelegate != null) {
                cameraControllerDelegate.onCameraError("Camera provider not initialized");
                processCameraProvider = Unit.INSTANCE;
            } else {
                processCameraProvider = null;
            }
        }
    }

    public final void stopCamera() {
        Log.d((String)TAG, (String)"Stopping camera");
        try {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider != null) {
                processCameraProvider.unbindAll();
            }
            this.isRunning = false;
            CameraControllerDelegate cameraControllerDelegate = this.delegate;
            if (cameraControllerDelegate != null) {
                cameraControllerDelegate.onCameraStopped();
            }
            Log.d((String)TAG, (String)"Camera stopped successfully");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error stopping camera", (Throwable)e);
        }
    }

    public final void switchCamera() {
        block1: {
            Log.d((String)TAG, (String)"Switching camera");
            int n = this.cameraFacing = this.cameraFacing == 0 ? 1 : 0;
            if (this.isRunning) {
                this.stopCamera();
                this.startCamera();
            }
            CameraControllerDelegate cameraControllerDelegate = this.delegate;
            if (cameraControllerDelegate == null) break block1;
            cameraControllerDelegate.onCameraSwitched(this.cameraFacing == 0);
        }
    }

    public final void updateResolution(int width, int height) {
        Log.d((String)TAG, (String)("Updating resolution to " + width + "x" + height));
        this.targetResolution = new Size(width, height);
        if (this.isRunning) {
            this.stopCamera();
            this.startCamera();
        }
    }

    public final void updateFrameRate(int fps) {
        Log.d((String)TAG, (String)("Updating frame rate to " + fps));
        this.targetFrameRate = fps;
    }

    public final boolean isFrontCamera() {
        return this.cameraFacing == 0;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    public final Preview getPreview() {
        return this.preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processImageFrame(ImageProxy imageProxy) {
        try {
            CameraControllerDelegate cameraControllerDelegate = this.delegate;
            if (cameraControllerDelegate != null) {
                cameraControllerDelegate.onFrameReceived(imageProxy);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error processing frame", (Throwable)e);
        }
        finally {
            imageProxy.close();
        }
    }

    public final void cleanup() {
        Log.d((String)TAG, (String)"Cleaning up camera controller");
        this.stopCamera();
        try {
            if (this.cameraExecutor instanceof ExecutorService) {
                Executor executor = this.cameraExecutor;
                Intrinsics.checkNotNull((Object)executor, (String)"null cannot be cast to non-null type java.util.concurrent.ExecutorService");
                ((ExecutorService)executor).shutdown();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not shutdown executor", (Throwable)e);
        }
    }

    private static final void initialize$lambda$0(CameraController this$0, ListenableFuture $cameraProviderFuture) {
        block2: {
            try {
                this$0.cameraProvider = (ProcessCameraProvider)$cameraProviderFuture.get();
                CameraControllerDelegate cameraControllerDelegate = this$0.delegate;
                if (cameraControllerDelegate == null) break block2;
                cameraControllerDelegate.onCameraInitialized();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Camera initialization failed", (Throwable)e);
                CameraControllerDelegate cameraControllerDelegate = this$0.delegate;
                if (cameraControllerDelegate == null) break block2;
                cameraControllerDelegate.onCameraError("Camera initialization failed: " + e.getMessage());
            }
        }
    }

    private static final void startCamera$lambda$2$lambda$1(CameraController this$0, ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        this$0.processImageFrame(imageProxy);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lexpo/modules/mediapipepose/camera/CameraController$Companion;", "", "<init>", "()V", "TAG", "", "react-native-mediapipe-pose_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

