/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.mediapipepose.detection;

import android.content.Context;
import android.util.Log;
import androidx.camera.core.ImageProxy;
import expo.modules.mediapipepose.data.PerformanceStats;
import expo.modules.mediapipepose.data.PoseLandmark;
import expo.modules.mediapipepose.data.PoseResult;
import expo.modules.mediapipepose.interfaces.PoseDetectorDelegate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0006\u0010%\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lexpo/modules/mediapipepose/detection/PoseDetectorService;", "", "context", "Landroid/content/Context;", "delegate", "Lexpo/modules/mediapipepose/interfaces/PoseDetectorDelegate;", "<init>", "(Landroid/content/Context;Lexpo/modules/mediapipepose/interfaces/PoseDetectorDelegate;)V", "isInitialized", "", "lastFrameTime", "", "frameCount", "", "totalInferenceTime", "droppedFrames", "useGpuDelegate", "minDetectionConfidence", "", "minTrackingConfidence", "minPresenceConfidence", "initialize", "", "processFrame", "imageProxy", "Landroidx/camera/core/ImageProxy;", "createDummyResult", "width", "height", "timestamp", "updateConfiguration", "useGpu", "detectionConfidence", "trackingConfidence", "presenceConfidence", "updatePerformanceStats", "inferenceTime", "cleanup", "Companion", "react-native-mediapipe-pose_debug"})
public final class PoseDetectorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final PoseDetectorDelegate delegate;
    private boolean isInitialized;
    private long lastFrameTime;
    private int frameCount;
    private long totalInferenceTime;
    private int droppedFrames;
    private boolean useGpuDelegate;
    private float minDetectionConfidence;
    private float minTrackingConfidence;
    private float minPresenceConfidence;
    @NotNull
    private static final String TAG = "PoseDetectorService";
    @NotNull
    private static final String MODEL_FILE = "pose_landmarker.task";

    public PoseDetectorService(@NotNull Context context, @Nullable PoseDetectorDelegate delegate2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.delegate = delegate2;
        this.useGpuDelegate = true;
        this.minDetectionConfidence = 0.5f;
        this.minTrackingConfidence = 0.5f;
        this.minPresenceConfidence = 0.5f;
    }

    public final void initialize() {
        block2: {
            Log.d((String)TAG, (String)"Initializing pose detector");
            try {
                this.isInitialized = true;
                Log.d((String)TAG, (String)"Pose detector initialized successfully (template mode)");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to initialize pose detector", (Throwable)e);
                PoseDetectorDelegate poseDetectorDelegate = this.delegate;
                if (poseDetectorDelegate == null) break block2;
                poseDetectorDelegate.onPoseDetectionError("Initialization failed: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processFrame(@NotNull ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        if (!this.isInitialized) {
            imageProxy.close();
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            this.createDummyResult(imageProxy.getWidth(), imageProxy.getHeight(), System.currentTimeMillis());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error processing frame", (Throwable)e);
            int n = this.droppedFrames;
            this.droppedFrames = n + 1;
        }
        finally {
            imageProxy.close();
            long inferenceTime = System.currentTimeMillis() - startTime;
            this.updatePerformanceStats(inferenceTime);
        }
    }

    private final void createDummyResult(int width, int height, long timestamp) {
        block1: {
            List landmarks = new ArrayList();
            for (int i = 0; i < 33; ++i) {
                landmarks.add(new PoseLandmark(0.5f + (float)i * 0.01f, 0.5f + (float)i * 0.01f, 0.0f, 0.8f));
            }
            PoseResult poseResult = new PoseResult(landmarks, width, height, timestamp);
            PoseDetectorDelegate poseDetectorDelegate = this.delegate;
            if (poseDetectorDelegate == null) break block1;
            poseDetectorDelegate.onPoseDetected(poseResult);
        }
    }

    public final void updateConfiguration(boolean useGpu, float detectionConfidence, float trackingConfidence, float presenceConfidence) {
        Log.d((String)TAG, (String)("Updating configuration - GPU: " + useGpu + ", Detection: " + detectionConfidence));
        this.useGpuDelegate = useGpu;
        this.minDetectionConfidence = detectionConfidence;
        this.minTrackingConfidence = trackingConfidence;
        this.minPresenceConfidence = presenceConfidence;
        Log.d((String)TAG, (String)"Configuration updated (template mode)");
    }

    private final void updatePerformanceStats(long inferenceTime) {
        int n = this.frameCount;
        this.frameCount = n + 1;
        this.totalInferenceTime += inferenceTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFrameTime >= 1000L) {
            float frameRate = this.frameCount;
            float avgInferenceTime = (float)this.totalInferenceTime / (float)this.frameCount;
            PerformanceStats stats = new PerformanceStats(frameRate, avgInferenceTime, 0.0f, 0.0f, this.frameCount, this.droppedFrames);
            PoseDetectorDelegate poseDetectorDelegate = this.delegate;
            if (poseDetectorDelegate != null) {
                poseDetectorDelegate.onPerformanceUpdate(stats);
            }
            this.frameCount = 0;
            this.totalInferenceTime = 0L;
            this.lastFrameTime = currentTime;
        }
    }

    public final void cleanup() {
        Log.d((String)TAG, (String)"Cleaning up pose detector");
        try {
            this.isInitialized = false;
            Log.d((String)TAG, (String)"Pose detector cleanup completed");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error during cleanup", (Throwable)e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lexpo/modules/mediapipepose/detection/PoseDetectorService$Companion;", "", "<init>", "()V", "TAG", "", "MODEL_FILE", "react-native-mediapipe-pose_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

