/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.useideem.zsm.core.CredentialsInfo;
import com.useideem.zsm.core.EncryptedStorageKt;
import com.useideem.zsm.core.StorageBase;
import com.useideem.zsm.core.ZSMClientBase;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMLogger;
import com.useideem.zsm.utils.ExtensionsKt;
import com.useideem.zsm.utils.KeystoreHelper;
import com.useideem.zsm.utils.KeystoreSecretStorage;
import java.security.PublicKey;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 G2\u00020\u0001:\u0001GB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010:\u001a\u0004\u0018\u00010;H\u0002J\b\u0010<\u001a\u00020,H\u0002J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020DH\u0016J\b\u0010F\u001a\u00020DH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010$\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010'R(\u0010(\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010+R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010\u001d\u001a\u0004\u0018\u00010,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R(\u00102\u001a\u0004\u0018\u00010,2\b\u0010\u001d\u001a\u0004\u0018\u00010,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010/\"\u0004\b4\u00101R(\u00105\u001a\u0004\u0018\u00010,2\b\u0010\u001d\u001a\u0004\u0018\u00010,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010/\"\u0004\b7\u00101R\u0014\u00108\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0013R\u001a\u0010=\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010@\u001a\u0004\bA\u0010B\u00a8\u0006H"}, d2={"Lcom/useideem/zsm/core/EncryptedStorage;", "Lcom/useideem/zsm/core/StorageBase;", "zsm", "Lcom/useideem/zsm/core/ZSMClientBase;", "storageIdentifier", "Ljava/util/UUID;", "<init>", "(Lcom/useideem/zsm/core/ZSMClientBase;Ljava/util/UUID;)V", "getZsm", "()Lcom/useideem/zsm/core/ZSMClientBase;", "getStorageIdentifier", "()Ljava/util/UUID;", "_application", "Landroid/app/Application;", "_keystore", "Lcom/useideem/zsm/utils/KeystoreSecretStorage;", "keysetAlias", "", "getKeysetAlias", "()Ljava/lang/String;", "webauthnStateAlias", "getWebauthnStateAlias", "webauthnCredentialAlias", "getWebauthnCredentialAlias", "identityIdAlias", "getIdentityIdAlias", "enclaveSigningKeyAlias", "getEnclaveSigningKeyAlias$zsm_release", "hasKeysetAlias", "value", "", "usedAndroidIdBasedInstallationId", "getUsedAndroidIdBasedInstallationId", "()Z", "setUsedAndroidIdBasedInstallationId", "(Z)V", "installationId", "getInstallationId", "setInstallationId", "(Ljava/util/UUID;)V", "identityId", "getIdentityId", "setIdentityId", "(Ljava/lang/String;)V", "", "keyset", "getKeyset", "()[B", "setKeyset", "([B)V", "webauthnState", "getWebauthnState", "setWebauthnState", "webauthnCredential", "getWebauthnCredential", "setWebauthnCredential", "deviceName", "getDeviceName", "getPublicKey", "Ljava/security/PublicKey;", "getPublicKeyBytes", "credentials", "Lcom/useideem/zsm/core/CredentialsInfo;", "getCredentials$annotations", "()V", "getCredentials", "()Lcom/useideem/zsm/core/CredentialsInfo;", "reset", "", "factoryReset", "clearCredentials", "EncryptedStatic", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nEncryptedStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptedStorage.kt\ncom/useideem/zsm/core/EncryptedStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class EncryptedStorage
extends StorageBase {
    @NotNull
    public static final EncryptedStatic EncryptedStatic = new EncryptedStatic(null);
    @NotNull
    private final ZSMClientBase zsm;
    @NotNull
    private final UUID storageIdentifier;
    @NotNull
    private final Application _application;
    @NotNull
    private final KeystoreSecretStorage _keystore;
    @NotNull
    private final String enclaveSigningKeyAlias;
    @NotNull
    private final String hasKeysetAlias;

    public EncryptedStorage(@NotNull ZSMClientBase zsm, @NotNull UUID storageIdentifier) {
        Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
        Intrinsics.checkNotNullParameter((Object)storageIdentifier, (String)"storageIdentifier");
        this.zsm = zsm;
        this.storageIdentifier = storageIdentifier;
        Context context = this.zsm.getContext().getApplicationContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Application");
        this._application = (Application)context;
        this._keystore = new KeystoreSecretStorage((Context)this._application, false, 2, null);
        this.enclaveSigningKeyAlias = EncryptedStatic.enclaveSigningKeyAlias$zsm_release(this.getStorageIdentifier());
        this.hasKeysetAlias = EncryptedStorage.EncryptedStatic.hasKeysetAlias(this.getStorageIdentifier());
    }

    @NotNull
    public final ZSMClientBase getZsm() {
        return this.zsm;
    }

    @Override
    @NotNull
    public UUID getStorageIdentifier() {
        return this.storageIdentifier;
    }

    private final String getKeysetAlias() {
        return this.getStorageIdentifier() + ".keyset";
    }

    private final String getWebauthnStateAlias() {
        return this.getStorageIdentifier() + ".webauthnState";
    }

    private final String getWebauthnCredentialAlias() {
        return this.getStorageIdentifier() + ".webauthnCredential";
    }

    private final String getIdentityIdAlias() {
        return this.getStorageIdentifier() + ".identityId";
    }

    @NotNull
    public final String getEnclaveSigningKeyAlias$zsm_release() {
        return this.enclaveSigningKeyAlias;
    }

    private final boolean getUsedAndroidIdBasedInstallationId() {
        return EncryptedStorage.EncryptedStatic.getSharePreferences((Context)this._application).getBoolean(EncryptedStorage.EncryptedStatic.getInstallationIdFromAndroidIdKeyAlias(), false);
    }

    private final void setUsedAndroidIdBasedInstallationId(boolean value) {
        EncryptedStorage.EncryptedStatic.getSharePreferences((Context)this._application).edit().putBoolean(EncryptedStorage.EncryptedStatic.getInstallationIdFromAndroidIdKeyAlias(), value).apply();
    }

    @NotNull
    public final UUID getInstallationId() {
        UUID uUID;
        Object[] objectArray;
        byte[] stored = this._keystore.retrieveKey(EncryptedStorage.EncryptedStatic.getInstallationIdKeyAlias());
        if (stored != null) {
            UUID uUID2 = UUID.fromString(new String(stored, Charsets.UTF_8));
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
            return uUID2;
        }
        if (this.getUsedAndroidIdBasedInstallationId()) {
            objectArray = new Object[]{"Generating random installation ID"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            uUID = UUID.randomUUID();
        } else {
            objectArray = new Object[]{"Generating Android ID based installation ID"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            this.setUsedAndroidIdBasedInstallationId(true);
            uUID = ExtensionsKt.toUUID$default("android_id", null, 1, null);
        }
        UUID newUUID = uUID;
        this.setInstallationId(newUUID);
        Intrinsics.checkNotNull((Object)newUUID);
        return newUUID;
    }

    public final void setInstallationId(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = EncryptedStorage.EncryptedStatic.getInstallationIdKeyAlias();
        String string2 = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this._keystore.storeKey(string, byArray);
    }

    @Override
    @Nullable
    public String getIdentityId() {
        String string;
        byte[] stored;
        block6: {
            String configIdentityId;
            block8: {
                Object object;
                block7: {
                    configIdentityId = this.zsm.getConfig().getIdentityId();
                    object = configIdentityId;
                    if (object == null || StringsKt.isBlank((CharSequence)object)) break block6;
                    if (this._keystore.retrieveKey(this.getIdentityIdAlias()) == null) break block7;
                    byte[] byArray = this._keystore.retrieveKey(this.getIdentityIdAlias());
                    if (byArray == null) {
                        byArray = new byte[]{};
                    }
                    if (Intrinsics.areEqual((Object)new String((byte[])(object = (Object)byArray), Charsets.UTF_8), (Object)configIdentityId)) break block8;
                }
                String string2 = this.getIdentityIdAlias();
                object = configIdentityId;
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this._keystore.storeKey(string2, byArray);
            }
            return configIdentityId;
        }
        if (stored != null) {
            byte[] it = stored = this._keystore.retrieveKey(this.getIdentityIdAlias());
            boolean bl = false;
            string = new String(it, Charsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void setIdentityId(@Nullable String value) {
        boolean bl;
        if (value == null) {
            bl = this._keystore.deleteKey(this.getIdentityIdAlias());
        } else {
            String string = this.getIdentityIdAlias();
            String string2 = value;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            bl = this._keystore.storeKey(string, byArray);
        }
    }

    @Override
    @Nullable
    public byte[] getKeyset() {
        return this._keystore.retrieveKey(this.getKeysetAlias());
    }

    @Override
    public void setKeyset(@Nullable byte[] value) {
        boolean bl = value == null ? this._keystore.deleteKey(this.getKeysetAlias()) : this._keystore.storeKey(this.getKeysetAlias(), value);
        EncryptedStatic.setHasCryptographicKey((Context)this._application, this.getStorageIdentifier(), value != null);
    }

    @Override
    @Nullable
    public byte[] getWebauthnState() {
        return this._keystore.retrieveKey(this.getWebauthnStateAlias());
    }

    @Override
    public void setWebauthnState(@Nullable byte[] value) {
        boolean bl = value == null ? this._keystore.deleteKey(this.getWebauthnStateAlias()) : this._keystore.storeKey(this.getWebauthnStateAlias(), value);
    }

    @Override
    @Nullable
    public byte[] getWebauthnCredential() {
        return this._keystore.retrieveKey(this.getWebauthnCredentialAlias());
    }

    @Override
    public void setWebauthnCredential(@Nullable byte[] value) {
        boolean bl = value == null ? this._keystore.deleteKey(this.getWebauthnCredentialAlias()) : this._keystore.storeKey(this.getWebauthnCredentialAlias(), value);
    }

    private final String getDeviceName() {
        return Build.MANUFACTURER + ' ' + Build.DEVICE + " (" + Build.MODEL + ')';
    }

    /*
     * Unable to fully structure code
     */
    private final PublicKey getPublicKey() {
        block3: {
            publicKey = KeystoreHelper.INSTANCE.getPublicKey(this.enclaveSigningKeyAlias);
            if (publicKey != null) break block3;
            var2_2 = new Object[]{"Public key not found. Generating a new key pair for alias: " + this.enclaveSigningKeyAlias};
            ZSMLogger.log$default(var2_2, null, null, 6, null);
            KeystoreHelper.generateKeyPair$default(KeystoreHelper.INSTANCE, this.enclaveSigningKeyAlias, null, 2, null);
            Thread.sleep(200L);
            publicKey = KeystoreHelper.INSTANCE.getPublicKey(this.enclaveSigningKeyAlias);
            var2_2 = new Object[1];
            v0 = new StringBuilder().append("Public key bytes: ");
            v1 = publicKey;
            if (v1 == null) ** GOTO lbl-1000
            v2 = v1.getEncoded();
            v1 = v2;
            if (v2 != null) {
                v3 = EncryptedStorageKt.toHex((byte[])v1);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            var2_2[0] = v0.append(v3).toString();
            ZSMLogger.log$default(var2_2, null, null, 6, null);
            if (publicKey == null) {
                var2_2 = new Object[]{"Failed to generate or retrieve public key after regeneration."};
                ZSMLogger.log$default(var2_2, null, null, 6, null);
                return null;
            }
        }
        return publicKey;
    }

    private final byte[] getPublicKeyBytes() {
        PublicKey publicKey = this.getPublicKey();
        if (publicKey == null) {
            throw new ZSMError("Unable to generate or retrieve public key", null);
        }
        byte[] byArray = publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @Override
    @NotNull
    public CredentialsInfo getCredentials() {
        byte[] publicKey = this.getPublicKeyBytes();
        String string = this.getInstallationId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new CredentialsInfo(string, this.getDeviceName(), this.zsm.getConfig().getConsumerId(), this.zsm.getConfig().getApplicationId(), this.zsm.getConfig().getApplicationEnvironment(), publicKey, this.getIdentityId());
    }

    public static /* synthetic */ void getCredentials$annotations() {
    }

    @Override
    public void reset() {
        this.clearCredentials();
        KeystoreHelper.INSTANCE.deleteKeyPair(this.enclaveSigningKeyAlias);
        this._keystore.deleteKey(this.getKeysetAlias());
        this._keystore.deleteKey(this.hasKeysetAlias);
        this._keystore.deleteKey(EncryptedStorage.EncryptedStatic.getInstallationIdKeyAlias());
        UUID installationId = this.getInstallationId();
        Object[] objectArray = new Object[]{"Generating new installation ID: " + installationId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    @Override
    public void factoryReset() {
        this.reset();
        this._keystore.deleteKey(EncryptedStorage.EncryptedStatic.getInstallationIdKeyAlias());
        this._keystore.deleteKey(this.getIdentityIdAlias());
        EncryptedStorage.EncryptedStatic.getSharePreferences((Context)this._application).edit().remove(EncryptedStorage.EncryptedStatic.getInstallationIdFromAndroidIdKeyAlias()).apply();
    }

    @Override
    public void clearCredentials() {
        this._keystore.deleteKey(this.getWebauthnStateAlias());
        this._keystore.deleteKey(this.getWebauthnCredentialAlias());
    }

    @JvmStatic
    public static final void get(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super EncryptedStorage, ? super ZSMError, Unit> completion) {
        EncryptedStatic.get(zsm, identifier, completion);
    }

    @JvmStatic
    public static final void getAsBase(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super StorageBase, ? super ZSMError, Unit> completion) {
        EncryptedStatic.getAsBase(zsm, identifier, completion);
    }

    @JvmStatic
    public static final boolean hasCryptographicKey(@NotNull Context context, @NotNull UUID identifier) {
        return EncryptedStatic.hasCryptographicKey(context, identifier);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0012JC\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102)\u0010\u0017\u001a%\u0012\u0004\u0012\u00020\u0019\u0012\u0015\u0012\u0013\u0018\u00010\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J4\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/useideem/zsm/core/EncryptedStorage$EncryptedStatic;", "", "<init>", "()V", "getSharePreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "installationIdKeyAlias", "", "getInstallationIdKeyAlias", "()Ljava/lang/String;", "installationIdFromAndroidIdKeyAlias", "getInstallationIdFromAndroidIdKeyAlias", "hasKeysetAlias", "identifier", "Ljava/util/UUID;", "enclaveSigningKeyAlias", "enclaveSigningKeyAlias$zsm_release", "get", "", "zsm", "Lcom/useideem/zsm/core/ZSMClientBase;", "completion", "Lkotlin/Function2;", "Lcom/useideem/zsm/core/EncryptedStorage;", "Lcom/useideem/zsm/core/ZSMError;", "Lkotlin/ParameterName;", "name", "error", "getAsBase", "Lcom/useideem/zsm/core/StorageBase;", "hasCryptographicKey", "", "setHasCryptographicKey", "value", "zsm_release"})
    public static final class EncryptedStatic {
        private EncryptedStatic() {
        }

        private final SharedPreferences getSharePreferences(Context context) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("ZSM", 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
            return sharedPreferences;
        }

        private final String getInstallationIdKeyAlias() {
            return "installationID";
        }

        private final String getInstallationIdFromAndroidIdKeyAlias() {
            return this.getInstallationIdKeyAlias() + ".fromAndroidId";
        }

        private final String hasKeysetAlias(UUID identifier) {
            return identifier + ".hasKeyset";
        }

        @NotNull
        public final String enclaveSigningKeyAlias$zsm_release(@NotNull UUID identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            return identifier + ".signingKey";
        }

        @JvmStatic
        public final void get(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super EncryptedStorage, ? super ZSMError, Unit> completion) {
            Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            completion.invoke((Object)new EncryptedStorage(zsm, identifier), null);
        }

        @JvmStatic
        public final void getAsBase(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super StorageBase, ? super ZSMError, Unit> completion) {
            Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            this.get(zsm, identifier, (Function2<? super EncryptedStorage, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> EncryptedStatic.getAsBase$lambda$0(completion, arg_0, arg_1)));
        }

        @JvmStatic
        public final boolean hasCryptographicKey(@NotNull Context context, @NotNull UUID identifier) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            KeystoreSecretStorage storage = new KeystoreSecretStorage(context, false, 2, null);
            return storage.keyExists(this.hasKeysetAlias(identifier));
        }

        public final void setHasCryptographicKey(@NotNull Context context, @NotNull UUID identifier, boolean value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            KeystoreSecretStorage storage = new KeystoreSecretStorage(context, false, 2, null);
            if (value) {
                byte[] byArray = new byte[]{1};
                bl = storage.storeKey(this.hasKeysetAlias(identifier), byArray);
            } else {
                bl = storage.deleteKey(this.hasKeysetAlias(identifier));
            }
        }

        private static final Unit getAsBase$lambda$0(Function2 $completion, EncryptedStorage storage, ZSMError error) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            $completion.invoke((Object)storage, (Object)error);
            return Unit.INSTANCE;
        }

        public /* synthetic */ EncryptedStatic(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

