/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import android.content.Context;
import android.os.Build;
import com.useideem.zsm.core.CredentialsInfo;
import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.StorageBase;
import com.useideem.zsm.core.ZSMClientBase;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMLogger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u000205H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R(\u0010%\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R(\u0010(\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R(\u0010+\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00069"}, d2={"Lcom/useideem/zsm/core/MemoryStorage;", "Lcom/useideem/zsm/core/StorageBase;", "zsm", "Lcom/useideem/zsm/core/ZSMClientBase;", "storageIdentifier", "Ljava/util/UUID;", "<init>", "(Lcom/useideem/zsm/core/ZSMClientBase;Ljava/util/UUID;)V", "getZsm", "()Lcom/useideem/zsm/core/ZSMClientBase;", "getStorageIdentifier", "()Ljava/util/UUID;", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "installationId", "kotlin.jvm.PlatformType", "Ljava/util/UUID;", "publicKey", "KEYSET_KEY", "WEBAUTHN_STATE_KEY", "WEBAUTHN_CREDENTIAL_KEY", "IDENTITY_ID_KEY", "store", "", "key", "data", "retrieve", "remove", "getStorageKey", "value", "keyset", "getKeyset", "()[B", "setKeyset", "([B)V", "webauthnState", "getWebauthnState", "setWebauthnState", "webauthnCredential", "getWebauthnCredential", "setWebauthnCredential", "identityId", "getIdentityId", "()Ljava/lang/String;", "setIdentityId", "(Ljava/lang/String;)V", "credentials", "Lcom/useideem/zsm/core/CredentialsInfo;", "getCredentials", "()Lcom/useideem/zsm/core/CredentialsInfo;", "clearCredentials", "", "reset", "factoryReset", "Companion", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nMemoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryStorage.kt\ncom/useideem/zsm/core/MemoryStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class MemoryStorage
extends StorageBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZSMClientBase zsm;
    @NotNull
    private final UUID storageIdentifier;
    @NotNull
    private final ConcurrentHashMap<String, byte[]> storage;
    private final UUID installationId;
    @NotNull
    private final byte[] publicKey;
    @NotNull
    private final String KEYSET_KEY;
    @NotNull
    private final String WEBAUTHN_STATE_KEY;
    @NotNull
    private final String WEBAUTHN_CREDENTIAL_KEY;
    @NotNull
    private final String IDENTITY_ID_KEY;
    @NotNull
    private static final ConcurrentHashMap<UUID, MemoryStorage> instances = new ConcurrentHashMap();

    private MemoryStorage(ZSMClientBase zsm, UUID storageIdentifier) {
        this.zsm = zsm;
        this.storageIdentifier = storageIdentifier;
        this.storage = new ConcurrentHashMap();
        this.installationId = UUID.randomUUID();
        this.KEYSET_KEY = "keyset";
        this.WEBAUTHN_STATE_KEY = "webauthnState";
        this.WEBAUTHN_CREDENTIAL_KEY = "webauthnCredential";
        this.IDENTITY_ID_KEY = "identityId";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        SecureRandom random = new SecureRandom();
        keyPairGenerator.initialize(256, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.publicKey = keyPair.getPublic().getEncoded();
    }

    @NotNull
    public final ZSMClientBase getZsm() {
        return this.zsm;
    }

    @Override
    @NotNull
    public UUID getStorageIdentifier() {
        return this.storageIdentifier;
    }

    private final boolean store(String key, byte[] data) {
        String storageKey = this.getStorageKey(key);
        ((Map)this.storage).put(storageKey, data.clone());
        Object[] objectArray = new Object[]{"MemoryStorage: Stored data for key " + key};
        ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
        return true;
    }

    private final byte[] retrieve(String key) {
        String storageKey = this.getStorageKey(key);
        byte[] byArray = this.storage.get(storageKey);
        byte[] result = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
        Object[] objectArray = new Object[]{"MemoryStorage: Retrieved data for key " + key};
        ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
        return result;
    }

    private final boolean remove(String key) {
        String storageKey = this.getStorageKey(key);
        boolean removed = this.storage.remove(storageKey) != null;
        Object[] objectArray = new Object[]{"MemoryStorage: Removed data for key " + key};
        ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
        return removed;
    }

    private final String getStorageKey(String key) {
        return this.getStorageIdentifier() + '_' + key;
    }

    @Override
    @Nullable
    public byte[] getKeyset() {
        return this.retrieve(this.KEYSET_KEY);
    }

    @Override
    public void setKeyset(@Nullable byte[] value) {
        boolean bl = value == null ? this.remove(this.KEYSET_KEY) : this.store(this.KEYSET_KEY, value);
    }

    @Override
    @Nullable
    public byte[] getWebauthnState() {
        return this.retrieve(this.WEBAUTHN_STATE_KEY);
    }

    @Override
    public void setWebauthnState(@Nullable byte[] value) {
        boolean bl = value == null ? this.remove(this.WEBAUTHN_STATE_KEY) : this.store(this.WEBAUTHN_STATE_KEY, value);
    }

    @Override
    @Nullable
    public byte[] getWebauthnCredential() {
        return this.retrieve(this.WEBAUTHN_CREDENTIAL_KEY);
    }

    @Override
    public void setWebauthnCredential(@Nullable byte[] value) {
        boolean bl = value == null ? this.remove(this.WEBAUTHN_CREDENTIAL_KEY) : this.store(this.WEBAUTHN_CREDENTIAL_KEY, value);
    }

    @Override
    @Nullable
    public String getIdentityId() {
        String string;
        String configIdentityId = this.zsm.getConfig().getIdentityId();
        CharSequence charSequence = configIdentityId;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String storedId;
            String string2;
            byte[] byArray = this.retrieve(this.IDENTITY_ID_KEY);
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                string2 = new String(it, Charsets.UTF_8);
            } else {
                string2 = storedId = null;
            }
            if (!Intrinsics.areEqual((Object)storedId, (Object)configIdentityId)) {
                this.setIdentityId(configIdentityId);
            }
            return configIdentityId;
        }
        byte[] byArray = this.retrieve(this.IDENTITY_ID_KEY);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            string = new String(it, Charsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void setIdentityId(@Nullable String value) {
        boolean bl;
        if (value == null) {
            bl = this.remove(this.IDENTITY_ID_KEY);
        } else {
            String string = value;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            bl = this.store(this.IDENTITY_ID_KEY, byArray);
        }
    }

    @Override
    @NotNull
    public CredentialsInfo getCredentials() {
        String string = this.installationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new CredentialsInfo(string, Build.MANUFACTURER + ' ' + Build.MODEL + " (Memory)", this.zsm.getConfig().getConsumerId(), this.zsm.getConfig().getApplicationId(), this.zsm.getConfig().getApplicationEnvironment(), this.publicKey, this.getIdentityId());
    }

    @Override
    public void clearCredentials() {
        this.remove(this.WEBAUTHN_STATE_KEY);
        this.remove(this.WEBAUTHN_CREDENTIAL_KEY);
        Object[] objectArray = new Object[]{"MemoryStorage: Cleared credentials"};
        ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
    }

    @Override
    public void reset() {
        this.storage.clear();
        Object[] objectArray = new Object[]{"MemoryStorage: Reset storage"};
        ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
    }

    @Override
    public void factoryReset() {
        this.reset();
        instances.remove(this.getStorageIdentifier());
        Object[] objectArray = new Object[]{"MemoryStorage: Factory reset completed, removed from instances map"};
        ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
    }

    @JvmStatic
    public static final void get(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super MemoryStorage, ? super ZSMError, Unit> completion) {
        Companion.get(zsm, identifier, completion);
    }

    @JvmStatic
    public static final void getAsBase(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super StorageBase, ? super ZSMError, Unit> completion) {
        Companion.getAsBase(zsm, identifier, completion);
    }

    @JvmStatic
    public static final boolean hasCryptographicKey(@NotNull Context context, @NotNull UUID identifier) {
        return Companion.hasCryptographicKey(context, identifier);
    }

    public /* synthetic */ MemoryStorage(ZSMClientBase zsm, UUID storageIdentifier, DefaultConstructorMarker $constructor_marker) {
        this(zsm, storageIdentifier);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\t0\u000eH\u0007J4\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\t0\u000eH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/useideem/zsm/core/MemoryStorage$Companion;", "", "<init>", "()V", "instances", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/useideem/zsm/core/MemoryStorage;", "get", "", "zsm", "Lcom/useideem/zsm/core/ZSMClientBase;", "identifier", "completion", "Lkotlin/Function2;", "Lcom/useideem/zsm/core/ZSMError;", "getAsBase", "Lcom/useideem/zsm/core/StorageBase;", "hasCryptographicKey", "", "context", "Landroid/content/Context;", "zsm_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void get(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super MemoryStorage, ? super ZSMError, Unit> completion) {
            Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            MemoryStorage memoryStorage = instances.computeIfAbsent(identifier, arg_0 -> Companion.get$lambda$1(arg_0 -> Companion.get$lambda$0(zsm, identifier, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)memoryStorage, (String)"computeIfAbsent(...)");
            MemoryStorage storage = memoryStorage;
            completion.invoke((Object)storage, null);
        }

        @JvmStatic
        public final void getAsBase(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super StorageBase, ? super ZSMError, Unit> completion) {
            Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            this.get(zsm, identifier, (Function2<? super MemoryStorage, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> Companion.getAsBase$lambda$2(completion, arg_0, arg_1)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean hasCryptographicKey(@NotNull Context context, @NotNull UUID identifier) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            if (!instances.containsKey(identifier)) return false;
            MemoryStorage memoryStorage = (MemoryStorage)instances.get(identifier);
            if (memoryStorage == null) return false;
            Object v = instances.get(identifier);
            Intrinsics.checkNotNull(v);
            byte[] byArray = memoryStorage.retrieve(((MemoryStorage)v).KEYSET_KEY);
            if (byArray == null) return false;
            return true;
        }

        private static final MemoryStorage get$lambda$0(ZSMClientBase $zsm, UUID $identifier, UUID it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new MemoryStorage($zsm, $identifier, null);
        }

        private static final MemoryStorage get$lambda$1(Function1 $tmp0, Object p0) {
            return (MemoryStorage)$tmp0.invoke(p0);
        }

        private static final Unit getAsBase$lambda$2(Function2 $completion, MemoryStorage storage, ZSMError error) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            $completion.invoke((Object)storage, (Object)error);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

