/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import com.useideem.zsm.core.EncryptedStorage;
import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.MemoryStorage;
import com.useideem.zsm.core.StorageBase;
import com.useideem.zsm.core.ZSMClientBase;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMLogger;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0005H\u0003JR\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a28\u0010\u001b\u001a4\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0015\u0012\u0013\u0018\u00010!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00160\u001cH\u0007J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007JR\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a28\u0010\u001b\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b('\u0012\u0015\u0012\u0013\u0018\u00010!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00160\u001cH\u0007R*\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006("}, d2={"Lcom/useideem/zsm/core/SecureStorageFactory;", "", "<init>", "()V", "value", "", "forceEncryptedStorage", "getForceEncryptedStorage", "()Ljava/lang/Boolean;", "setForceEncryptedStorage", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "requireHardwareBackedKeystore", "getRequireHardwareBackedKeystore", "()Z", "setRequireHardwareBackedKeystore", "(Z)V", "useEncryptedStorage", "getUseEncryptedStorage$annotations", "getUseEncryptedStorage", "isEncryptedStorageAvailable", "getStorage", "", "zsm", "Lcom/useideem/zsm/core/ZSMClientBase;", "identifier", "Ljava/util/UUID;", "completion", "Lkotlin/Function2;", "Lcom/useideem/zsm/core/StorageBase;", "Lkotlin/ParameterName;", "name", "storage", "Lcom/useideem/zsm/core/ZSMError;", "error", "hasCryptographicKey", "context", "Landroid/content/Context;", "factoryReset", "success", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nSecureStorageFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureStorageFactory.kt\ncom/useideem/zsm/core/SecureStorageFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class SecureStorageFactory {
    @NotNull
    public static final SecureStorageFactory INSTANCE = new SecureStorageFactory();
    @Nullable
    private static Boolean forceEncryptedStorage;
    private static boolean requireHardwareBackedKeystore;

    private SecureStorageFactory() {
    }

    @Nullable
    public final Boolean getForceEncryptedStorage() {
        return forceEncryptedStorage;
    }

    @JvmStatic
    public static final void setForceEncryptedStorage(@Nullable Boolean bl) {
        forceEncryptedStorage = bl;
    }

    public final boolean getRequireHardwareBackedKeystore() {
        return requireHardwareBackedKeystore;
    }

    @JvmStatic
    public static final void setRequireHardwareBackedKeystore(boolean bl) {
        requireHardwareBackedKeystore = bl;
    }

    public static final boolean getUseEncryptedStorage() {
        Boolean bl = forceEncryptedStorage;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        boolean isAvailable = INSTANCE.isEncryptedStorageAvailable();
        if (requireHardwareBackedKeystore && !isAvailable) {
            Object[] objectArray = new Object[]{"Hardware-backed keystore required but not available, falling back to in-memory storage"};
            ZSMLogger.log$default(objectArray, LogLevel.WARN, null, 4, null);
            return false;
        }
        return isAvailable;
    }

    @JvmStatic
    public static /* synthetic */ void getUseEncryptedStorage$annotations() {
    }

    @JvmStatic
    private static final boolean isEncryptedStorageAvailable() {
        try {
            boolean hasStrongBoxSupport;
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            int apiLevel = Build.VERSION.SDK_INT;
            boolean bl = hasStrongBoxSupport = apiLevel >= 28;
            if (apiLevel < 23) {
                Object[] objectArray = new Object[]{"Android API level is below M (23), secure storage not available"};
                ZSMLogger.log$default(objectArray, LogLevel.WARN, null, 4, null);
                return false;
            }
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
                String[] stringArray = new String[]{"CBC"};
                KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder("com.useideem.zsm.test.key", 3).setBlockModes(stringArray);
                stringArray = new String[]{"PKCS7Padding"};
                KeyGenParameterSpec.Builder builder2 = builder.setEncryptionPaddings(stringArray).setKeySize(256);
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKeySize(...)");
                KeyGenParameterSpec.Builder builder3 = builder2;
                if (hasStrongBoxSupport && Build.VERSION.SDK_INT >= 28) {
                    builder3.setIsStrongBoxBacked(true);
                }
                try {
                    keyGenerator.init((AlgorithmParameterSpec)builder3.build());
                    keyGenerator.generateKey();
                    keyStore.deleteEntry("com.useideem.zsm.test.key");
                    Object[] objectArray = new Object[]{"KeyStore encryption is available"};
                    ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
                    objectArray = new Object[]{"Hardware-backed encryption appears to be available"};
                    ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
                    return true;
                }
                catch (Exception e) {
                    if (hasStrongBoxSupport && Build.VERSION.SDK_INT >= 28) {
                        Object[] objectArray = new Object[]{"StrongBox unavailable: " + e.getMessage()};
                        ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
                        try {
                            builder3.setIsStrongBoxBacked(false);
                            keyGenerator.init((AlgorithmParameterSpec)builder3.build());
                            keyGenerator.generateKey();
                            keyStore.deleteEntry("com.useideem.zsm.test.key");
                            objectArray = new Object[]{"KeyStore encryption is available, but StrongBox is not"};
                            ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
                            objectArray = new Object[]{"Hardware-backed encryption appears to be available"};
                            ZSMLogger.log$default(objectArray, LogLevel.INFO, null, 4, null);
                            return true;
                        }
                        catch (Exception e2) {
                            Object[] objectArray2 = new Object[]{"Failed to create hardware-backed key: " + e2.getMessage()};
                            ZSMLogger.log$default(objectArray2, LogLevel.WARN, null, 4, null);
                            return false;
                        }
                    }
                    Object[] objectArray = new Object[]{"Failed to create hardware-backed key: " + e.getMessage()};
                    ZSMLogger.log$default(objectArray, LogLevel.WARN, null, 4, null);
                    return false;
                }
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{"KeyGenerator unavailable: " + e.getMessage()};
                ZSMLogger.log$default(objectArray, LogLevel.WARN, null, 4, null);
                return false;
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"AndroidKeyStore unavailable: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, LogLevel.WARN, null, 4, null);
            return false;
        }
    }

    @JvmStatic
    public static final void getStorage(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super StorageBase, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (INSTANCE.getUseEncryptedStorage()) {
            EncryptedStorage.EncryptedStatic.getAsBase(zsm, identifier, (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> SecureStorageFactory.getStorage$lambda$1(completion, arg_0, arg_1)));
        } else {
            MemoryStorage.Companion.getAsBase(zsm, identifier, (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> SecureStorageFactory.getStorage$lambda$2(completion, arg_0, arg_1)));
        }
    }

    @JvmStatic
    public static final boolean hasCryptographicKey(@NotNull Context context, @NotNull UUID identifier) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return INSTANCE.getUseEncryptedStorage() ? EncryptedStorage.EncryptedStatic.hasCryptographicKey(context, identifier) : MemoryStorage.Companion.hasCryptographicKey(context, identifier);
    }

    @JvmStatic
    public static final void factoryReset(@NotNull ZSMClientBase zsm, @NotNull UUID identifier, @NotNull Function2<? super Boolean, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)zsm, (String)"zsm");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        SecureStorageFactory.getStorage(zsm, identifier, (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> SecureStorageFactory.factoryReset$lambda$3(completion, arg_0, arg_1)));
    }

    private static final Unit getStorage$lambda$1(Function2 $completion, StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        $completion.invoke((Object)storage, (Object)error);
        return Unit.INSTANCE;
    }

    private static final Unit getStorage$lambda$2(Function2 $completion, StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        $completion.invoke((Object)storage, (Object)error);
        return Unit.INSTANCE;
    }

    private static final Unit factoryReset$lambda$3(Function2 $completion, StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (error != null) {
            $completion.invoke((Object)false, (Object)error);
        } else {
            try {
                storage.factoryReset();
                $completion.invoke((Object)true, null);
            }
            catch (Exception e) {
                $completion.invoke((Object)false, (Object)new ZSMError("Failed to perform factory reset: " + e.getMessage(), null, 2, null));
            }
        }
        return Unit.INSTANCE;
    }
}

