/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import android.content.Context;
import com.useideem.zsm.core.EncryptedStorage;
import com.useideem.zsm.core.HostInfo;
import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.SecureStorageFactory;
import com.useideem.zsm.core.StorageBase;
import com.useideem.zsm.core.ZSMConfig;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMException;
import com.useideem.zsm.core.ZSMInstanceRegistry;
import com.useideem.zsm.core.ZSMLogger;
import com.useideem.zsm.utils.ExtensionsKt;
import com.useideem.zsm.utils.KeystoreHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005Jk\u0010\u0019\u001a\u00020\u00182a\u0010\u001a\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012!\u0012\u001f\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\"\u0012\u0015\u0012\u0013\u0018\u00010#\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180\u001bj\u0002`%H\u0016Js\u0010\u0019\u001a\u00020\u00182\u0006\u0010&\u001a\u00020!2a\u0010\u001a\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012!\u0012\u001f\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\"\u0012\u0015\u0012\u0013\u0018\u00010#\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180\u001bj\u0002`%H\u0016Ji\u0010'\u001a\u00020\u00182_\u0010\u001a\u001a[\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b((\u0012!\u0012\u001f\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\"\u0012\u0015\u0012\u0013\u0018\u00010#\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180\u001bj\u0002`)H\u0016JH\u0010*\u001a\u00020+2\u0016\b\u0002\u0010,\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000201J\b\u00103\u001a\u00020\u0018H\u0002J\b\u00104\u001a\u00020\u0018H\u0002J\t\u00105\u001a\u00020\u0018H\u0082 J\t\u00106\u001a\u00020!H\u0086 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u00068"}, d2={"Lcom/useideem/zsm/core/ZSMClientBase;", "", "context", "Landroid/content/Context;", "config", "Lcom/useideem/zsm/core/ZSMConfig;", "<init>", "(Landroid/content/Context;Lcom/useideem/zsm/core/ZSMConfig;)V", "getContext", "()Landroid/content/Context;", "getConfig", "()Lcom/useideem/zsm/core/ZSMConfig;", "storageIdentifier", "Ljava/util/UUID;", "getStorageIdentifier", "()Ljava/util/UUID;", "hasCryptographicKey", "", "getHasCryptographicKey", "()Z", "value", "initialized", "getInitialized", "configure", "", "unbind", "completion", "Lkotlin/Function3;", "Lorg/json/JSONObject;", "Lkotlin/ParameterName;", "name", "result", "", "", "metadata", "Lcom/useideem/zsm/core/ZSMError;", "error", "Lcom/useideem/zsm/core/ZSMJSONCallbackFn;", "user", "factoryReset", "success", "Lcom/useideem/zsm/core/ZSMBooleanCallbackFn;", "buildHostInfo", "Lcom/useideem/zsm/core/HostInfo;", "headers", "traceId", "logLevel", "", "signMessageEnclave", "", "data", "registerWithRegistry", "unregisterFromRegistry", "initialize", "invokeNativePing", "Companion", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nZSMClientBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZSMClientBase.kt\ncom/useideem/zsm/core/ZSMClientBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,380:1\n11228#2:381\n11563#2,3:382\n11228#2:385\n11563#2,3:386\n*S KotlinDebug\n*F\n+ 1 ZSMClientBase.kt\ncom/useideem/zsm/core/ZSMClientBase\n*L\n246#1:381\n246#1:382,3\n276#1:385\n276#1:386,3\n*E\n"})
public class ZSMClientBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ZSMConfig config;
    private boolean initialized;
    @JvmField
    @NotNull
    public static final LogLevel errorLogLevel = LogLevel.DEBUG;
    @JvmField
    public static final int traceLogLevel = LogLevel.TRACE.getValue();

    public ZSMClientBase(@NotNull Context context, @NotNull ZSMConfig config) throws ZSMException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        String initTraceId = ZSMLogger.generateTraceId();
        try {
            Object[] objectArray = new Object[]{"Loading ZSM native library"};
            ZSMLogger.log(objectArray, LogLevel.INFO, initTraceId);
            System.loadLibrary("zsm");
            this.initialize();
            objectArray = new Object[]{"Native library loaded successfully"};
            ZSMLogger.log(objectArray, LogLevel.INFO, initTraceId);
            this.configure(this.config);
            this.initialized = true;
            this.registerWithRegistry();
            objectArray = new Object[]{"ZSMClientBase initialized successfully"};
            ZSMLogger.log(objectArray, LogLevel.INFO, initTraceId);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"ZSMClientBase failed during init: " + e.getMessage()};
            ZSMLogger.log(objectArray, LogLevel.ERROR, initTraceId);
            throw new ZSMException(e);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final ZSMConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final UUID getStorageIdentifier() {
        StringBuilder stringBuilder = new StringBuilder().append(this.context.getPackageName());
        String string = this.config.getApplicationEnvironment();
        if (string == null) {
            string = "";
        }
        return ExtensionsKt.toUUID$default(stringBuilder.append(string).append(this.config.getHostUrl()).append(this.config.getConsumerId()).toString(), null, 1, null);
    }

    public final boolean getHasCryptographicKey() {
        return SecureStorageFactory.hasCryptographicKey(this.context, this.getStorageIdentifier());
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void configure(@NotNull ZSMConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String configTraceId = ZSMLogger.generateTraceId();
        Object[] objectArray = new Object[]{"Configuring ZSMClientBase"};
        ZSMLogger.log(objectArray, LogLevel.INFO, configTraceId);
        String oldConsumerId = this.config.getConsumerId();
        this.config.setConsumerId(config.getConsumerId());
        this.config.setHostUrl(config.getHostUrl());
        this.config.setApplicationId(config.getApplicationId());
        this.config.setApplicationEnvironment(config.getApplicationEnvironment());
        this.config.setIdentityId(config.getIdentityId());
        this.config.setApiKey(config.getApiKey());
        this.config.setLogLevel(config.getLogLevel());
        Object[] objectArray2 = new Object[]{"Updated consumer_id: '" + oldConsumerId + "' -> '" + this.config.getConsumerId() + '\''};
        ZSMLogger.log(objectArray2, LogLevel.DEBUG, configTraceId);
        objectArray2 = new Object[]{"Updated identity_id: '" + this.config.getIdentityId() + '\''};
        ZSMLogger.log(objectArray2, LogLevel.DEBUG, configTraceId);
        ZSMLogger.setLogLevel(config.getLogLevel());
        objectArray2 = new Object[]{"Log level set to " + (Object)((Object)config.getLogLevel())};
        ZSMLogger.log(objectArray2, LogLevel.DEBUG, configTraceId);
        Object object = config.getLogging();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            if (TypeIntrinsics.isFunctionOfArity((Object)it, (int)2)) {
                ZSMLogger.setLogFunction((Function2<? super LogLevel, ? super String, Unit>)((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)it, (int)2)));
                Object[] objectArray3 = new Object[]{"Custom logging function configured"};
                ZSMLogger.log(objectArray3, LogLevel.DEBUG, configTraceId);
            }
        }
        objectArray2 = new Object[]{"Configuration updated: " + this.config};
        ZSMLogger.log(objectArray2, LogLevel.DEBUG, configTraceId);
    }

    public void unbind(@NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        String unbindTraceId = ZSMLogger.generateTraceId();
        Object[] objectArray = new Object[]{"Unbinding user " + this.config.getConsumerId()};
        ZSMLogger.log(objectArray, LogLevel.INFO, unbindTraceId);
        try {
            objectArray = new Object[]{"Accessing secure storage to unbind user"};
            ZSMLogger.log(objectArray, LogLevel.DEBUG, unbindTraceId);
            SecureStorageFactory.getStorage(this, this.getStorageIdentifier(), (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> ZSMClientBase.unbind$lambda$1(unbindTraceId, completion, arg_0, arg_1)));
        }
        catch (Error err) {
            Object[] objectArray2 = new Object[]{"Error during unbind: " + err.getMessage()};
            ZSMLogger.log(objectArray2, LogLevel.ERROR, unbindTraceId);
            completion.invoke(null, null, (Object)new ZSMError(err, null, 2, null));
        }
    }

    public void unbind(@NotNull String user, @NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        String unbindUserTraceId = ZSMLogger.generateTraceId();
        Object[] objectArray = new Object[]{"Changing consumer ID to " + user + " for unbinding"};
        ZSMLogger.log(objectArray, LogLevel.INFO, unbindUserTraceId);
        this.config.setConsumerId(user);
        objectArray = new Object[]{"Reconfiguring client with new consumer ID"};
        ZSMLogger.log(objectArray, LogLevel.DEBUG, unbindUserTraceId);
        this.configure(this.config);
        objectArray = new Object[]{"Delegating to main unbind method"};
        ZSMLogger.log(objectArray, LogLevel.DEBUG, unbindUserTraceId);
        this.unbind(completion);
    }

    public void factoryReset(@NotNull Function3<? super Boolean, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        String resetTraceId = ZSMLogger.generateTraceId();
        Object[] objectArray = new Object[]{"Performing factory reset for user " + this.config.getConsumerId()};
        ZSMLogger.log(objectArray, LogLevel.INFO, resetTraceId);
        try {
            objectArray = new Object[]{"Accessing secure storage factory for reset"};
            ZSMLogger.log(objectArray, LogLevel.DEBUG, resetTraceId);
            SecureStorageFactory.factoryReset(this, this.getStorageIdentifier(), (Function2<? super Boolean, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> ZSMClientBase.factoryReset$lambda$2(resetTraceId, completion, arg_0, arg_1)));
        }
        catch (Error err) {
            Object[] objectArray2 = new Object[]{"Error during factory reset: " + err.getMessage()};
            ZSMLogger.log(objectArray2, LogLevel.ERROR, resetTraceId);
            completion.invoke((Object)false, (Object)MapsKt.emptyMap(), (Object)new ZSMError(err, null, 2, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final HostInfo buildHostInfo(@Nullable Map<String, String> headers, @Nullable Map<String, String> metadata, @NotNull String traceId, int logLevel) {
        String[] metadataArray;
        String[] stringArray;
        Collection collection;
        int n;
        Collection destination$iv$iv;
        String[] headersArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Object[] objectArray = new Object[]{"Building host info for operation"};
        ZSMLogger.log(objectArray, errorLogLevel, traceId);
        objectArray = new Object[1];
        StringBuilder stringBuilder = new StringBuilder().append("Host config: URL=").append(this.config.getHostUrl()).append(", authHost=");
        String string = this.config.getAuthenticationHost();
        if (string == null) {
            string = "none";
        }
        objectArray[0] = stringBuilder.append(string).append(", timeout=").append((Object)UInt.toString-impl((int)this.config.getRequestTimeoutMS-pVg5ArA())).append("ms, retries=").append((Object)UInt.toString-impl((int)this.config.getRetryCount-pVg5ArA())).toString();
        ZSMLogger.log(objectArray, LogLevel.TRACE, traceId);
        if (this.config.getHeaders() != null) {
            JSONObject jSONObject = this.config.getHeaders();
            Intrinsics.checkNotNull((Object)jSONObject);
            Object[] objectArray2 = ExtensionsKt.toArray(jSONObject);
            Object[] objectArray3 = headers;
            if (headers == null || (objectArray3 = ExtensionsKt.toArray(objectArray3)) == null) {
                objectArray3 = new String[]{};
            }
            stringArray2 = (String[])ArraysKt.plus((Object[])objectArray2, (Object[])objectArray3);
        } else {
            stringArray2 = headersArray = headers != null ? ExtensionsKt.toArray(headers) : new String[]{};
        }
        if (!(headersArray.length == 0)) {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            String[] stringArray3 = headersArray;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                String string2;
                void header;
                void item$iv$iv;
                void var15_18 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray4 = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)((CharSequence)header), (String[])stringArray4, (boolean)false, (int)2, (int)2, null);
                if (parts.size() == 2) {
                    String key;
                    Intrinsics.checkNotNullExpressionValue((Object)((String)parts.get(0)).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    string2 = StringsKt.contains$default((CharSequence)key, (CharSequence)"key", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)key, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)key, (CharSequence)"auth", (boolean)false, (int)2, null) ? (String)parts.get(0) + "=<REDACTED>" : (String)parts.get(0) + '=' + (String)parts.get(1);
                } else {
                    string2 = header;
                }
                collection.add(string2);
            }
            String safeHeaders = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            $this$map$iv = new Object[]{"Headers: " + safeHeaders};
            ZSMLogger.log($this$map$iv, LogLevel.TRACE, traceId);
        }
        if (this.config.getMetadata() != null) {
            JSONObject jSONObject = this.config.getMetadata();
            Intrinsics.checkNotNull((Object)jSONObject);
            Object[] objectArray4 = ExtensionsKt.toArray(jSONObject);
            Object[] objectArray5 = metadata;
            if (metadata == null || (objectArray5 = ExtensionsKt.toArray(objectArray5)) == null) {
                objectArray5 = new String[]{};
            }
            stringArray = (String[])ArraysKt.plus((Object[])objectArray4, (Object[])objectArray5);
        } else {
            stringArray = metadataArray = metadata != null ? ExtensionsKt.toArray(metadata) : new String[]{};
        }
        if (!(metadataArray.length == 0)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] $i$f$map = metadataArray;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void metadataItem;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[n];
                collection = destination$iv$iv2;
                boolean bl2 = false;
                String[] stringArray5 = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)((CharSequence)metadataItem), (String[])stringArray5, (boolean)false, (int)2, (int)2, null);
                collection.add(parts.size() == 2 ? (String)parts.get(0) + '=' + (String)parts.get(1) : metadataItem);
            }
            String metadataLog = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray6 = new Object[]{"Metadata: " + metadataLog};
            ZSMLogger.log(objectArray6, LogLevel.TRACE, traceId);
        }
        return new HostInfo(this.config.getHostUrl(), this.config.getAuthenticationHost(), null, headersArray, metadataArray, this.config.getRequestTimeoutMS-pVg5ArA(), this.config.getRetryCount-pVg5ArA(), traceId, logLevel, null);
    }

    public static /* synthetic */ HostInfo buildHostInfo$default(ZSMClientBase zSMClientBase, Map map, Map map2, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildHostInfo");
        }
        if ((n2 & 1) != 0) {
            map = null;
        }
        if ((n2 & 2) != 0) {
            map2 = null;
        }
        return zSMClientBase.buildHostInfo(map, map2, string, n);
    }

    @Nullable
    public final byte[] signMessageEnclave(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String signTraceId = ZSMLogger.generateTraceId();
        Object[] objectArray = new Object[]{"Signing message with enclave key"};
        ZSMLogger.log(objectArray, LogLevel.DEBUG, signTraceId);
        try {
            String keyAlias = EncryptedStorage.EncryptedStatic.enclaveSigningKeyAlias$zsm_release(this.getStorageIdentifier());
            Object[] objectArray2 = new Object[]{"Using key alias: " + keyAlias};
            ZSMLogger.log(objectArray2, LogLevel.TRACE, signTraceId);
            byte[] result = KeystoreHelper.signMessage$default(KeystoreHelper.INSTANCE, keyAlias, data, null, 4, null);
            if (result == null) {
                Object[] objectArray3 = new Object[]{"Failed to sign message - null result"};
                ZSMLogger.log(objectArray3, LogLevel.ERROR, signTraceId);
            } else {
                Object[] objectArray4 = new Object[]{"Message signed successfully"};
                ZSMLogger.log(objectArray4, LogLevel.TRACE, signTraceId);
            }
            return result;
        }
        catch (Exception e) {
            Object[] objectArray5 = new Object[]{"Error signing message: " + e.getMessage()};
            ZSMLogger.log(objectArray5, LogLevel.ERROR, signTraceId);
            return null;
        }
    }

    private final void registerWithRegistry() {
        try {
            SecureStorageFactory.getStorage(this, this.getStorageIdentifier(), (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> ZSMClientBase.registerWithRegistry$lambda$5(this, arg_0, arg_1)));
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Exception during client registration: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, LogLevel.ERROR, null, 4, null);
        }
    }

    private final void unregisterFromRegistry() {
        try {
            SecureStorageFactory.getStorage(this, this.getStorageIdentifier(), (Function2<? super StorageBase, ? super ZSMError, Unit>)((Function2)ZSMClientBase::unregisterFromRegistry$lambda$6));
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Exception during client unregistration: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, LogLevel.ERROR, null, 4, null);
        }
    }

    private final native void initialize();

    @NotNull
    public final native String invokeNativePing();

    private static final Unit unbind$lambda$1(String $unbindTraceId, Function3 $completion, StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (error != null) {
            Object[] objectArray = new Object[]{"Failed to access secure storage: " + error.getMessage()};
            ZSMLogger.log(objectArray, LogLevel.ERROR, $unbindTraceId);
            $completion.invoke(null, null, (Object)error);
        } else {
            Object[] objectArray = new Object[]{"Clearing credentials for user"};
            ZSMLogger.log(objectArray, LogLevel.DEBUG, $unbindTraceId);
            storage.clearCredentials();
            objectArray = new Object[]{"User successfully unbound"};
            ZSMLogger.log(objectArray, LogLevel.INFO, $unbindTraceId);
            $completion.invoke((Object)new JSONObject("{\"status\":\"unbound\"}"), (Object)MapsKt.emptyMap(), null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit factoryReset$lambda$2(String $resetTraceId, Function3 $completion, boolean success, ZSMError error) {
        if (error != null) {
            Object[] objectArray = new Object[]{"Factory reset failed: " + error.getMessage()};
            ZSMLogger.log(objectArray, LogLevel.ERROR, $resetTraceId);
            $completion.invoke((Object)false, (Object)MapsKt.emptyMap(), (Object)error);
        } else {
            if (success) {
                Object[] objectArray = new Object[]{"Factory reset completed successfully"};
                ZSMLogger.log(objectArray, LogLevel.INFO, $resetTraceId);
            } else {
                Object[] objectArray = new Object[]{"Factory reset completed but returned false"};
                ZSMLogger.log(objectArray, LogLevel.WARN, $resetTraceId);
            }
            $completion.invoke((Object)success, (Object)MapsKt.emptyMap(), null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerWithRegistry$lambda$5(ZSMClientBase this$0, StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (error == null) {
            Object object = storage instanceof EncryptedStorage ? (EncryptedStorage)storage : null;
            if (object == null || (object = ((EncryptedStorage)object).getInstallationId()) == null || (object = ((UUID)object).toString()) == null) {
                object = storage.getCredentials().getInstallationId();
            }
            Object installationId = object;
            Object[] objectArray = new Object[]{"Registering ZSMClient with installationId: " + (String)installationId};
            ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
            ZSMInstanceRegistry.registerClient(this$0, (String)installationId);
        } else {
            Object[] objectArray = new Object[]{"Failed to register client: " + error.getMessage()};
            ZSMLogger.log$default(objectArray, LogLevel.ERROR, null, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unregisterFromRegistry$lambda$6(StorageBase storage, ZSMError error) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (error == null) {
            Object object = storage instanceof EncryptedStorage ? (EncryptedStorage)storage : null;
            if (object == null || (object = ((EncryptedStorage)object).getInstallationId()) == null || (object = ((UUID)object).toString()) == null) {
                object = storage.getCredentials().getInstallationId();
            }
            Object installationId = object;
            Object[] objectArray = new Object[]{"Unregistering ZSMClient with installationId: " + (String)installationId};
            ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
            ZSMInstanceRegistry.unregisterClient((String)installationId);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/useideem/zsm/core/ZSMClientBase$Companion;", "", "<init>", "()V", "errorLogLevel", "Lcom/useideem/zsm/core/LogLevel;", "traceLogLevel", "", "zsm_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

