/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.ZSMConfigKt;
import com.useideem.zsm.crypto.MPCAlgorithm;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010F\u001a\u00020\u0003J\b\u0010G\u001a\u00020\u0007H\u0016J\u0018\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070I*\u00020\u0003H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\u0005R\u001c\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010,\u001a\u00020&X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001c\u0010A\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006J"}, d2={"Lcom/useideem/zsm/core/ZSMConfig;", "", "json", "Lorg/json/JSONObject;", "<init>", "(Lorg/json/JSONObject;)V", "hostUrl", "", "getHostUrl", "()Ljava/lang/String;", "setHostUrl", "(Ljava/lang/String;)V", "applicationId", "getApplicationId", "setApplicationId", "consumerId", "getConsumerId", "setConsumerId", "authenticationHost", "getAuthenticationHost", "setAuthenticationHost", "apiKey", "getApiKey", "setApiKey", "identityId", "getIdentityId", "setIdentityId", "applicationEnvironment", "getApplicationEnvironment", "setApplicationEnvironment", "headers", "getHeaders", "()Lorg/json/JSONObject;", "setHeaders", "metadata", "getMetadata", "setMetadata", "requestTimeoutMS", "Lkotlin/UInt;", "getRequestTimeoutMS-pVg5ArA", "()I", "setRequestTimeoutMS-WZ4Q5Ns", "(I)V", "I", "retryCount", "getRetryCount-pVg5ArA", "setRetryCount-WZ4Q5Ns", "performNetworkHealthCheck", "", "getPerformNetworkHealthCheck", "()Z", "setPerformNetworkHealthCheck", "(Z)V", "logLevel", "Lcom/useideem/zsm/core/LogLevel;", "getLogLevel", "()Lcom/useideem/zsm/core/LogLevel;", "setLogLevel", "(Lcom/useideem/zsm/core/LogLevel;)V", "mpcAlgorithm", "Lcom/useideem/zsm/crypto/MPCAlgorithm;", "getMpcAlgorithm", "()Lcom/useideem/zsm/crypto/MPCAlgorithm;", "setMpcAlgorithm", "(Lcom/useideem/zsm/crypto/MPCAlgorithm;)V", "logging", "getLogging", "()Ljava/lang/Object;", "setLogging", "(Ljava/lang/Object;)V", "toJson", "toString", "toMap", "", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nZSMConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZSMConfig.kt\ncom/useideem/zsm/core/ZSMConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,84:1\n1#2:85\n32#3,2:86\n*S KotlinDebug\n*F\n+ 1 ZSMConfig.kt\ncom/useideem/zsm/core/ZSMConfig\n*L\n71#1:86,2\n*E\n"})
public final class ZSMConfig {
    @NotNull
    private String hostUrl;
    @NotNull
    private String applicationId;
    @NotNull
    private String consumerId;
    @Nullable
    private String authenticationHost;
    @Nullable
    private String apiKey;
    @Nullable
    private String identityId;
    @Nullable
    private String applicationEnvironment;
    @Nullable
    private JSONObject headers;
    @Nullable
    private JSONObject metadata;
    private int requestTimeoutMS;
    private int retryCount;
    private boolean performNetworkHealthCheck;
    @NotNull
    private LogLevel logLevel;
    @NotNull
    private MPCAlgorithm mpcAlgorithm;
    @Nullable
    private Object logging;

    public ZSMConfig(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = ZSMConfigKt.optTrimmed(json, "host_url");
        if (string == null) {
            throw new IllegalArgumentException("host_url is required");
        }
        this.hostUrl = string;
        String string2 = ZSMConfigKt.optTrimmed(json, "application_id");
        if (string2 == null) {
            throw new IllegalArgumentException("application_id is required");
        }
        this.applicationId = string2;
        String string3 = ZSMConfigKt.optTrimmed(json, "consumer_id");
        if (string3 == null) {
            throw new IllegalArgumentException("consumer_id is required");
        }
        this.consumerId = string3;
        this.requestTimeoutMS = 30000;
        this.logLevel = LogLevel.DEBUG;
        this.mpcAlgorithm = MPCAlgorithm.ECDSAP256;
        this.authenticationHost = ZSMConfigKt.optTrimmed(json, "authentication_host");
        this.apiKey = ZSMConfigKt.optTrimmed(json, "api_key");
        this.identityId = ZSMConfigKt.optTrimmed(json, "identity_id");
        String string4 = ZSMConfigKt.optTrimmed(json, "application_environment");
        if (string4 == null) {
            string4 = this.applicationEnvironment;
        }
        this.applicationEnvironment = string4;
        this.headers = json.optJSONObject("headers");
        this.metadata = json.optJSONObject("metadata");
        this.requestTimeoutMS = UInt.constructor-impl((int)json.optInt("request_timeout_ms", this.requestTimeoutMS));
        this.retryCount = UInt.constructor-impl((int)json.optInt("retry_count", this.retryCount));
        this.performNetworkHealthCheck = json.optBoolean("perform_network_health_check", this.performNetworkHealthCheck);
        this.logLevel = LogLevel.Companion.fromStringOrDefault(ZSMConfigKt.optTrimmed(json, "log_level"), LogLevel.DEBUG);
        this.mpcAlgorithm = MPCAlgorithm.Companion.fromStringOrDefault(ZSMConfigKt.optTrimmed(json, "mpc_algorithm"), MPCAlgorithm.ECDSAP256);
    }

    @NotNull
    public final String getHostUrl() {
        return this.hostUrl;
    }

    public final void setHostUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.hostUrl = string;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    public final void setApplicationId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.applicationId = string;
    }

    @NotNull
    public final String getConsumerId() {
        return this.consumerId;
    }

    public final void setConsumerId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.consumerId = string;
    }

    @Nullable
    public final String getAuthenticationHost() {
        return this.authenticationHost;
    }

    public final void setAuthenticationHost(@Nullable String string) {
        this.authenticationHost = string;
    }

    @Nullable
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@Nullable String string) {
        this.apiKey = string;
    }

    @Nullable
    public final String getIdentityId() {
        return this.identityId;
    }

    public final void setIdentityId(@Nullable String string) {
        this.identityId = string;
    }

    @Nullable
    public final String getApplicationEnvironment() {
        return this.applicationEnvironment;
    }

    public final void setApplicationEnvironment(@Nullable String string) {
        this.applicationEnvironment = string;
    }

    @Nullable
    public final JSONObject getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable JSONObject jSONObject) {
        this.headers = jSONObject;
    }

    @Nullable
    public final JSONObject getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable JSONObject jSONObject) {
        this.metadata = jSONObject;
    }

    public final int getRequestTimeoutMS-pVg5ArA() {
        return this.requestTimeoutMS;
    }

    public final void setRequestTimeoutMS-WZ4Q5Ns(int n) {
        this.requestTimeoutMS = n;
    }

    public final int getRetryCount-pVg5ArA() {
        return this.retryCount;
    }

    public final void setRetryCount-WZ4Q5Ns(int n) {
        this.retryCount = n;
    }

    public final boolean getPerformNetworkHealthCheck() {
        return this.performNetworkHealthCheck;
    }

    public final void setPerformNetworkHealthCheck(boolean bl) {
        this.performNetworkHealthCheck = bl;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        this.logLevel = logLevel;
    }

    @NotNull
    public final MPCAlgorithm getMpcAlgorithm() {
        return this.mpcAlgorithm;
    }

    public final void setMpcAlgorithm(@NotNull MPCAlgorithm mPCAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)mPCAlgorithm), (String)"<set-?>");
        this.mpcAlgorithm = mPCAlgorithm;
    }

    @Nullable
    public final Object getLogging() {
        return this.logging;
    }

    public final void setLogging(@Nullable Object object) {
        this.logging = object;
    }

    @NotNull
    public final JSONObject toJson() {
        String it;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("host_url", (Object)this.hostUrl);
        String string = this.authenticationHost;
        if (string != null) {
            it = string;
            boolean bl = false;
            jsonObject.put("authentication_host", (Object)it);
        }
        String string2 = this.apiKey;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            jsonObject.put("api_key", (Object)it);
        }
        jsonObject.put("application_id", (Object)this.applicationId);
        jsonObject.put("consumer_id", (Object)this.consumerId);
        String string3 = this.identityId;
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            jsonObject.put("identity_id", (Object)it);
        }
        String string4 = this.applicationEnvironment;
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            jsonObject.put("application_environment", (Object)it);
        }
        JSONObject jSONObject = this.headers;
        if (jSONObject != null) {
            it = jSONObject;
            boolean bl = false;
            jsonObject.put("headers", (Object)it);
        }
        JSONObject jSONObject2 = this.metadata;
        if (jSONObject2 != null) {
            it = jSONObject2;
            boolean bl = false;
            jsonObject.put("metadata", (Object)it);
        }
        jsonObject.put("request_timeout_ms", (Object)UInt.box-impl((int)this.requestTimeoutMS));
        jsonObject.put("retry_count", (Object)UInt.box-impl((int)this.retryCount));
        jsonObject.put("perform_network_health_check", this.performNetworkHealthCheck);
        jsonObject.put("log_level", (Object)this.logLevel.name());
        jsonObject.put("mpc_algorithm", (Object)this.mpcAlgorithm.name());
        return jsonObject;
    }

    @NotNull
    public String toString() {
        String string = this.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Map<String, String> toMap(JSONObject $this$toMap) {
        Map map = new LinkedHashMap();
        Iterator iterator = $this$toMap.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key);
            String value = ZSMConfigKt.optTrimmed($this$toMap, key);
            CharSequence charSequence = value;
            if (charSequence == null || charSequence.length() == 0) continue;
            map.put(key, value);
        }
        return map;
    }
}

