/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMErrorCode;
import com.useideem.zsm.core.ZSMLogger;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0089\u0001\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u0001H\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b20\u0010\r\u001a,\u0012\u0006\u0012\u0004\u0018\u0001H\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00050\u000e2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J7\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0019J&\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000bJ&\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000bJ&\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\bJ\u001f\u0010 \u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a8\u0006%"}, d2={"Lcom/useideem/zsm/core/ZSMErrorHandler;", "", "<init>", "()V", "handleOperation", "", "T", "operationName", "", "result", "error", "Lcom/useideem/zsm/core/ZSMError;", "traceId", "completion", "Lkotlin/Function3;", "", "metadata", "errorCode", "Lcom/useideem/zsm/core/ZSMErrorCode;", "(Ljava/lang/String;Ljava/lang/Object;Lcom/useideem/zsm/core/ZSMError;Ljava/lang/String;Lkotlin/jvm/functions/Function3;Ljava/util/Map;Lcom/useideem/zsm/core/ZSMErrorCode;)V", "createNetworkError", "message", "statusCode", "", "cause", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/useideem/zsm/core/ZSMError;)Lcom/useideem/zsm/core/ZSMError;", "createAuthError", "createWebAuthnError", "createStorageError", "extractErrorFromResponse", "response", "Lorg/json/JSONObject;", "determineNetworkErrorCode", "(Ljava/lang/Integer;Ljava/lang/String;)Lcom/useideem/zsm/core/ZSMErrorCode;", "determineAuthErrorCode", "determineWebAuthnErrorCode", "determineStorageErrorCode", "zsm_release"})
public final class ZSMErrorHandler {
    @NotNull
    public static final ZSMErrorHandler INSTANCE = new ZSMErrorHandler();

    private ZSMErrorHandler() {
    }

    public final <T> void handleOperation(@NotNull String operationName, @Nullable T result, @Nullable ZSMError error, @NotNull String traceId, @NotNull Function3<? super T, ? super Map<String, String>, ? super ZSMError, Unit> completion, @Nullable Map<String, String> metadata, @NotNull ZSMErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (error != null) {
            Object[] objectArray = new Object[]{operationName + " failed: " + error.getMessage()};
            ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
            completion.invoke(null, null, (Object)error);
            return;
        }
        if (result == null) {
            ZSMError newError = new ZSMError(operationName + " failed: No result returned", errorCode, traceId);
            Object[] objectArray = new Object[1];
            String string = newError.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
            completion.invoke(null, null, (Object)newError);
            return;
        }
        Object[] objectArray = new Object[]{operationName + " completed successfully"};
        ZSMLogger.log(objectArray, LogLevel.DEBUG, traceId);
        Map map = metadata;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        completion.invoke(result, (Object)map, null);
    }

    public static /* synthetic */ void handleOperation$default(ZSMErrorHandler zSMErrorHandler, String string, Object object, ZSMError zSMError, String string2, Function3 function3, Map map, ZSMErrorCode zSMErrorCode, int n, Object object2) {
        if ((n & 0x20) != 0) {
            map = null;
        }
        if ((n & 0x40) != 0) {
            zSMErrorCode = ZSMErrorCode.ERROR;
        }
        zSMErrorHandler.handleOperation(string, object, zSMError, string2, function3, map, zSMErrorCode);
    }

    @NotNull
    public final ZSMError createNetworkError(@NotNull String message, @Nullable Integer statusCode, @Nullable String traceId, @Nullable ZSMError cause) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ZSMErrorCode errorCode = this.determineNetworkErrorCode(statusCode, message);
        switch (WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
            case 1: {
                string = "Authentication failed: " + message;
                break;
            }
            case 2: {
                string = "Network error: " + message;
                break;
            }
            case 3: {
                string = "Server unreachable: " + message;
                break;
            }
            default: {
                string = message;
            }
        }
        String finalMessage = string;
        Object[] objectArray = new Object[]{"Network error: " + finalMessage + " (code: " + errorCode.getValue() + ')'};
        ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
        return new ZSMError(finalMessage, errorCode, traceId);
    }

    public static /* synthetic */ ZSMError createNetworkError$default(ZSMErrorHandler zSMErrorHandler, String string, Integer n, String string2, ZSMError zSMError, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n2 & 8) != 0) {
            zSMError = null;
        }
        return zSMErrorHandler.createNetworkError(string, n, string2, zSMError);
    }

    @NotNull
    public final ZSMError createAuthError(@NotNull String message, @Nullable String traceId, @Nullable ZSMError cause) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ZSMErrorCode errorCode = this.determineAuthErrorCode(message);
        switch (WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
            case 4: {
                string = "Login failed: " + message;
                break;
            }
            case 1: {
                string = "Unauthorized: " + message;
                break;
            }
            case 5: {
                string = "Account suspended: " + message;
                break;
            }
            case 6: {
                string = "Account deactivated: " + message;
                break;
            }
            default: {
                string = message;
            }
        }
        String finalMessage = string;
        Object[] objectArray = new Object[]{"Authentication error: " + finalMessage + " (code: " + errorCode.getValue() + ')'};
        ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
        return new ZSMError(finalMessage, errorCode, traceId);
    }

    public static /* synthetic */ ZSMError createAuthError$default(ZSMErrorHandler zSMErrorHandler, String string, String string2, ZSMError zSMError, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 4) != 0) {
            zSMError = null;
        }
        return zSMErrorHandler.createAuthError(string, string2, zSMError);
    }

    @NotNull
    public final ZSMError createWebAuthnError(@NotNull String message, @Nullable String traceId, @Nullable ZSMError cause) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ZSMErrorCode errorCode = this.determineWebAuthnErrorCode(message);
        switch (WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
            case 7: {
                string = "No WebAuthn credentials found: " + message;
                break;
            }
            case 8: {
                string = "Invalid WebAuthn credentials: " + message;
                break;
            }
            case 9: {
                string = "WebAuthn operation failed: " + message;
                break;
            }
            default: {
                string = message;
            }
        }
        String finalMessage = string;
        Object[] objectArray = new Object[]{"WebAuthn error: " + finalMessage + " (code: " + errorCode.getValue() + ')'};
        ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
        return new ZSMError(finalMessage, errorCode, traceId);
    }

    public static /* synthetic */ ZSMError createWebAuthnError$default(ZSMErrorHandler zSMErrorHandler, String string, String string2, ZSMError zSMError, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 4) != 0) {
            zSMError = null;
        }
        return zSMErrorHandler.createWebAuthnError(string, string2, zSMError);
    }

    @NotNull
    public final ZSMError createStorageError(@NotNull String message, @Nullable String traceId, @Nullable ZSMError cause) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ZSMErrorCode errorCode = this.determineStorageErrorCode(message);
        switch (WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
            case 10: {
                string = "Secure storage unavailable: " + message;
                break;
            }
            case 11: {
                string = "Secure storage operation failed: " + message;
                break;
            }
            case 12: {
                string = "Secure storage requires authentication: " + message;
                break;
            }
            default: {
                string = message;
            }
        }
        String finalMessage = string;
        Object[] objectArray = new Object[]{"Storage error: " + finalMessage + " (code: " + errorCode.getValue() + ')'};
        ZSMLogger.log(objectArray, LogLevel.ERROR, traceId);
        return new ZSMError(finalMessage, errorCode, traceId);
    }

    public static /* synthetic */ ZSMError createStorageError$default(ZSMErrorHandler zSMErrorHandler, String string, String string2, ZSMError zSMError, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 4) != 0) {
            zSMError = null;
        }
        return zSMErrorHandler.createStorageError(string, string2, zSMError);
    }

    @Nullable
    public final ZSMError extractErrorFromResponse(@Nullable JSONObject response, @Nullable String traceId) {
        if (response == null) {
            return null;
        }
        JSONObject error = response.optJSONObject("error");
        if (error != null) {
            int code = error.optInt("code", 0);
            String message = error.optString("message", "Unknown error");
            return new ZSMError(message, ZSMErrorCode.Companion.fromInt(code), traceId);
        }
        String errorMessage = response.optString("error_message", "");
        Intrinsics.checkNotNull((Object)errorMessage);
        if (!StringsKt.isBlank((CharSequence)errorMessage)) {
            return new ZSMError(errorMessage, ZSMErrorCode.ERROR, traceId);
        }
        String status = response.optString("status", "");
        if (Intrinsics.areEqual((Object)status, (Object)"error") || Intrinsics.areEqual((Object)status, (Object)"failure")) {
            String message = response.optString("message", "Operation failed");
            return new ZSMError(message, ZSMErrorCode.ERROR, traceId);
        }
        return null;
    }

    public static /* synthetic */ ZSMError extractErrorFromResponse$default(ZSMErrorHandler zSMErrorHandler, JSONObject jSONObject, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = UUID.randomUUID().toString();
        }
        return zSMErrorHandler.extractErrorFromResponse(jSONObject, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ZSMErrorCode determineNetworkErrorCode(Integer statusCode, String message) {
        ZSMErrorCode zSMErrorCode;
        block12: {
            ZSMErrorCode zSMErrorCode2;
            int n;
            Integer n2;
            block14: {
                block13: {
                    if (statusCode == null) break block12;
                    n2 = statusCode;
                    n = 401;
                    if (n2 == n) break block13;
                    n = 403;
                    if (n2 != n) break block14;
                }
                zSMErrorCode2 = ZSMErrorCode.UNAUTHORIZED_USER;
                return zSMErrorCode2;
            }
            n = 404;
            if (n2 == n) {
                zSMErrorCode2 = ZSMErrorCode.INVALID_SERVER_RESPONSE;
                return zSMErrorCode2;
            }
            n = 500;
            if (n2 != n) {
                n = 502;
                if (n2 != n) {
                    n = 503;
                    if (n2 != n) {
                        n = 504;
                        if (n2 != n) {
                            zSMErrorCode2 = ZSMErrorCode.NETWORK_FAILURE;
                            return zSMErrorCode2;
                        }
                    }
                }
            }
            zSMErrorCode2 = ZSMErrorCode.SERVER_UNREACHABLE;
            return zSMErrorCode2;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"timeout", (boolean)true)) {
            zSMErrorCode = ZSMErrorCode.OPERATION_TIMEOUT;
            return zSMErrorCode;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"unreachable", (boolean)true)) {
            zSMErrorCode = ZSMErrorCode.SERVER_UNREACHABLE;
            return zSMErrorCode;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"connection", (boolean)true)) {
            zSMErrorCode = ZSMErrorCode.NETWORK_FAILURE;
            return zSMErrorCode;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"unauthorized", (boolean)true)) {
            zSMErrorCode = ZSMErrorCode.UNAUTHORIZED_USER;
            return zSMErrorCode;
        }
        zSMErrorCode = ZSMErrorCode.NETWORK_FAILURE;
        return zSMErrorCode;
    }

    private final ZSMErrorCode determineAuthErrorCode(String message) {
        return StringsKt.contains((CharSequence)message, (CharSequence)"invalid login", (boolean)true) ? ZSMErrorCode.INVALID_LOGIN : (StringsKt.contains((CharSequence)message, (CharSequence)"unauthorized", (boolean)true) ? ZSMErrorCode.UNAUTHORIZED_USER : (StringsKt.contains((CharSequence)message, (CharSequence)"suspended", (boolean)true) ? ZSMErrorCode.ACCOUNT_SUSPENDED : (StringsKt.contains((CharSequence)message, (CharSequence)"deactivated", (boolean)true) ? ZSMErrorCode.ACCOUNT_DEACTIVATED : ZSMErrorCode.UNAUTHORIZED_USER)));
    }

    private final ZSMErrorCode determineWebAuthnErrorCode(String message) {
        return StringsKt.contains((CharSequence)message, (CharSequence)"no credentials", (boolean)true) ? ZSMErrorCode.WEBAUTHN_NO_CREDENTIALS : (StringsKt.contains((CharSequence)message, (CharSequence)"invalid credential", (boolean)true) ? ZSMErrorCode.WEBAUTHN_INVALID_CREDENTIALS : ZSMErrorCode.WEBAUTHN_ERROR);
    }

    private final ZSMErrorCode determineStorageErrorCode(String message) {
        return StringsKt.contains((CharSequence)message, (CharSequence)"unavailable", (boolean)true) ? ZSMErrorCode.SECURE_STORAGE_UNAVAILABLE : (StringsKt.contains((CharSequence)message, (CharSequence)"unauthenticated", (boolean)true) ? ZSMErrorCode.SECURE_STORAGE_UNAUTHENTICATED : ZSMErrorCode.SECURE_STORAGE_FAILURE);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZSMErrorCode.values().length];
            try {
                nArray[ZSMErrorCode.UNAUTHORIZED_USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.NETWORK_FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.SERVER_UNREACHABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.INVALID_LOGIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.ACCOUNT_SUSPENDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.ACCOUNT_DEACTIVATED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.WEBAUTHN_NO_CREDENTIALS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.WEBAUTHN_INVALID_CREDENTIALS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.WEBAUTHN_ERROR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.SECURE_STORAGE_UNAVAILABLE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.SECURE_STORAGE_FAILURE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZSMErrorCode.SECURE_STORAGE_UNAUTHENTICATED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

