/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMErrorCode;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00060\u0001j\u0002`\u0002:\u0001\u001cB9\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0015\b\u0016\u0012\n\u0010\r\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0004\b\u000b\u0010\u000eB#\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\u0004\b\u000b\u0010\u000fB+\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/useideem/zsm/core/ZSMException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "code", "Lcom/useideem/zsm/core/ZSMErrorCode;", "traceId", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/lang/String;Lcom/useideem/zsm/core/ZSMErrorCode;Ljava/lang/String;Ljava/lang/Exception;)V", "err", "(Ljava/lang/Exception;)V", "(Ljava/lang/String;Ljava/lang/Exception;)V", "(Ljava/lang/String;Lcom/useideem/zsm/core/ZSMErrorCode;Ljava/lang/Exception;)V", "getCode", "()Lcom/useideem/zsm/core/ZSMErrorCode;", "getTraceId", "()Ljava/lang/String;", "getUserFriendlyMessage", "getTechnicalDetails", "isRecoverable", "", "getRecommendedAction", "toError", "Lcom/useideem/zsm/core/ZSMError;", "Companion", "zsm_release"})
public class ZSMException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZSMErrorCode code;
    @Nullable
    private final String traceId;

    public ZSMException(@Nullable String message, @NotNull ZSMErrorCode code, @Nullable String traceId, @Nullable Exception cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        super(message, cause);
        this.code = code;
        this.traceId = traceId;
    }

    public /* synthetic */ ZSMException(String string, ZSMErrorCode zSMErrorCode, String string2, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            zSMErrorCode = ZSMErrorCode.ERROR;
        }
        if ((n & 4) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 8) != 0) {
            exception = null;
        }
        this(string, zSMErrorCode, string2, exception);
    }

    @NotNull
    public final ZSMErrorCode getCode() {
        return this.code;
    }

    @Nullable
    public final String getTraceId() {
        return this.traceId;
    }

    public ZSMException(@NotNull Exception err) {
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        this(err.getMessage(), ZSMErrorCode.Companion.fromMessage(err.getMessage()), UUID.randomUUID().toString(), err);
    }

    public ZSMException(@Nullable String message, @Nullable Exception cause) {
        this(message, ZSMErrorCode.Companion.fromMessage(message), UUID.randomUUID().toString(), cause);
    }

    public ZSMException(@Nullable String message, @NotNull ZSMErrorCode code, @Nullable Exception cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        this(message, code, UUID.randomUUID().toString(), cause);
    }

    @NotNull
    public final String getUserFriendlyMessage() {
        return this.code.getUserMessage();
    }

    @NotNull
    public final String getTechnicalDetails() {
        StringBuilder stringBuilder = new StringBuilder().append("Exception code: ").append(this.code.getValue()).append(", Trace ID: ").append(this.traceId).append(", Message: ");
        String string = this.getMessage();
        if (string == null) {
            string = "No message";
        }
        return stringBuilder.append(string).toString();
    }

    public final boolean isRecoverable() {
        return this.code.isRecoverable();
    }

    @NotNull
    public final String getRecommendedAction() {
        return this.code.getRecommendedAction();
    }

    @NotNull
    public final ZSMError toError() {
        Throwable throwable;
        String string = this.getMessage();
        String string2 = this.traceId;
        if (string2 == null) {
            String string3 = UUID.randomUUID().toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return new ZSMError(string, this.code, string2, (throwable = this.getCause()) instanceof Exception ? (Exception)throwable : null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u000eJ6\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a8\u0006\u0012"}, d2={"Lcom/useideem/zsm/core/ZSMException$Companion;", "", "<init>", "()V", "createNetworkException", "Lcom/useideem/zsm/core/ZSMException;", "message", "", "statusCode", "", "traceId", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Exception;)Lcom/useideem/zsm/core/ZSMException;", "createEnrollmentException", "isAlreadyEnrolled", "", "zsm_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final ZSMException createNetworkException(@NotNull String message, @Nullable Integer statusCode, @Nullable String traceId, @Nullable Exception cause) {
            block4: {
                block6: {
                    block5: {
                        block3: {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                v0 = var6_5 = statusCode;
                                var7_6 = 401;
                                if (v0 != null && v0 == var7_6) break block2;
                                v1 = var6_5;
                                var7_6 = 403;
                                if (v1 == null || v1 != var7_6) break block3;
                            }
                            v2 = ZSMErrorCode.UNAUTHORIZED_USER;
                            break block4;
                        }
                        v3 = var6_5;
                        var7_6 = 404;
                        if (v3 == null || v3 != var7_6) break block5;
                        v2 = ZSMErrorCode.INVALID_SERVER_RESPONSE;
                        break block4;
                    }
                    v4 = var6_5;
                    var7_6 = 408;
                    if (v4 == null || v4 != var7_6) break block6;
                    v2 = ZSMErrorCode.OPERATION_TIMEOUT;
                    break block4;
                }
                v5 = var6_5;
                var7_6 = 500;
                if (v5 != null && v5 == var7_6) ** GOTO lbl-1000
                v6 = var6_5;
                var7_6 = 502;
                if (v6 != null && v6 == var7_6) ** GOTO lbl-1000
                v7 = var6_5;
                var7_6 = 503;
                if (v7 != null && v7 == var7_6) ** GOTO lbl-1000
                v8 = var6_5;
                var7_6 = 504;
                if (v8 != null && v8 == var7_6) lbl-1000:
                // 4 sources

                {
                    v2 = ZSMErrorCode.SERVER_UNREACHABLE;
                } else {
                    v2 = ZSMErrorCode.NETWORK_FAILURE;
                }
            }
            code = v2;
            return new ZSMException("Network error (" + statusCode + "): " + message, code, traceId, cause);
        }

        public static /* synthetic */ ZSMException createNetworkException$default(Companion companion, String string, Integer n, String string2, Exception exception, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                string2 = UUID.randomUUID().toString();
            }
            if ((n2 & 8) != 0) {
                exception = null;
            }
            return companion.createNetworkException(string, n, string2, exception);
        }

        @NotNull
        public final ZSMException createEnrollmentException(@NotNull String message, boolean isAlreadyEnrolled, @Nullable String traceId, @Nullable Exception cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ZSMErrorCode code = isAlreadyEnrolled ? ZSMErrorCode.USER_ALREADY_ENROLLED : ZSMErrorCode.USER_NOT_ENROLLED;
            return new ZSMException(message, code, traceId, cause);
        }

        public static /* synthetic */ ZSMException createEnrollmentException$default(Companion companion, String string, boolean bl, String string2, Exception exception, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                string2 = UUID.randomUUID().toString();
            }
            if ((n & 8) != 0) {
                exception = null;
            }
            return companion.createEnrollmentException(string, bl, string2, exception);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

