/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import com.useideem.zsm.core.CredentialsInfo;
import com.useideem.zsm.core.LogLevel;
import com.useideem.zsm.core.ZSMClientBase;
import com.useideem.zsm.core.ZSMLogger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/useideem/zsm/core/ZSMInstanceRegistry;", "", "<init>", "()V", "clientRegistry", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/useideem/zsm/core/ZSMClientBase;", "registerClient", "", "client", "installationId", "unregisterClient", "getClientForCredentials", "credentialsInfo", "Lcom/useideem/zsm/core/CredentialsInfo;", "getClientForInstallationId", "getRegisteredClientCount", "", "clearAllClients", "zsm_release"})
public final class ZSMInstanceRegistry {
    @NotNull
    public static final ZSMInstanceRegistry INSTANCE = new ZSMInstanceRegistry();
    @NotNull
    private static final ConcurrentHashMap<String, ZSMClientBase> clientRegistry = new ConcurrentHashMap();

    private ZSMInstanceRegistry() {
    }

    @JvmStatic
    public static final void registerClient(@NotNull ZSMClientBase client, @NotNull String installationId) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)installationId, (String)"installationId");
        if (StringsKt.isBlank((CharSequence)installationId)) {
            Object[] objectArray = new Object[]{"Invalid installation ID for registration: '" + installationId + '\''};
            ZSMLogger.log$default(objectArray, LogLevel.ERROR, null, 4, null);
            return;
        }
        ((Map)clientRegistry).put(installationId, client);
        Object[] objectArray = new Object[]{"Registered ZSMClient for installation ID: " + installationId};
        ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
    }

    @JvmStatic
    public static final void unregisterClient(@NotNull String installationId) {
        Intrinsics.checkNotNullParameter((Object)installationId, (String)"installationId");
        if (StringsKt.isBlank((CharSequence)installationId)) {
            return;
        }
        clientRegistry.remove(installationId);
        Object[] objectArray = new Object[]{"Unregistered client for installation ID: " + installationId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    @JvmStatic
    @Nullable
    public static final ZSMClientBase getClientForCredentials(@NotNull CredentialsInfo credentialsInfo) {
        Intrinsics.checkNotNullParameter((Object)credentialsInfo, (String)"credentialsInfo");
        return ZSMInstanceRegistry.getClientForInstallationId(credentialsInfo.getInstallationId());
    }

    @JvmStatic
    @Nullable
    public static final ZSMClientBase getClientForInstallationId(@NotNull String installationId) {
        Intrinsics.checkNotNullParameter((Object)installationId, (String)"installationId");
        if (StringsKt.isBlank((CharSequence)installationId)) {
            return null;
        }
        ZSMClientBase client = clientRegistry.get(installationId);
        if (client == null) {
            for (Map.Entry entry : ((Map)clientRegistry).entrySet()) {
                String key = (String)entry.getKey();
                ZSMClientBase value = (ZSMClientBase)entry.getValue();
                if (!StringsKt.equals((String)key, (String)installationId, (boolean)true)) continue;
                Object[] objectArray = new Object[]{"Found client using case-insensitive match: " + installationId + " -> " + key};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                client = value;
                break;
            }
        }
        if (client == null) {
            Object[] objectArray = new Object[]{"No client found for installation ID: " + installationId};
            ZSMLogger.log$default(objectArray, LogLevel.ERROR, null, 4, null);
            objectArray = new Object[1];
            StringBuilder stringBuilder = new StringBuilder().append("Available keys: ");
            Set set = clientRegistry.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            objectArray[0] = stringBuilder.append(CollectionsKt.toList((Iterable)set)).toString();
            ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
            objectArray = new Object[]{"Registry has " + clientRegistry.size() + " clients"};
            ZSMLogger.log$default(objectArray, LogLevel.DEBUG, null, 4, null);
        }
        return client;
    }

    @JvmStatic
    public static final int getRegisteredClientCount() {
        return clientRegistry.size();
    }

    @JvmStatic
    public static final void clearAllClients() {
        clientRegistry.clear();
        Object[] objectArray = new Object[]{"Cleared all registered clients"};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }
}

