/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.core;

import android.util.Log;
import com.useideem.zsm.core.LogLevel;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0015\u001a\u00020\u001028\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\nH\u0007JB\u0010\u0017\u001a\u00020\u001028\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\nH\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0005H\u0007J\b\u0010\u0019\u001a\u00020\u000eH\u0007J\u001a\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J;\u0010\u001d\u001a\u00020\u00102\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001f\"\u0004\u0018\u00010\u00012\b\b\u0002\u0010\r\u001a\u00020\u00052\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0007R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u008a\u0001\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n28\u0010\u0004\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/useideem/zsm/core/ZSMLogger;", "", "<init>", "()V", "value", "Lcom/useideem/zsm/core/LogLevel;", "logLevel", "getLogLevel$annotations", "getLogLevel", "()Lcom/useideem/zsm/core/LogLevel;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "level", "", "message", "", "logFunction", "getLogFunction$annotations", "getLogFunction", "()Lkotlin/jvm/functions/Function2;", "setLogFunction", "logger", "overrideLogger", "setLogLevel", "generateTraceId", "formatTraceMessage", "traceId", "extractTraceId", "log", "args", "", "([Ljava/lang/Object;Lcom/useideem/zsm/core/LogLevel;Ljava/lang/String;)V", "logTraceData", "traceData", "", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nZSMLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZSMLogger.kt\ncom/useideem/zsm/core/ZSMLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1869#2,2:266\n*S KotlinDebug\n*F\n+ 1 ZSMLogger.kt\ncom/useideem/zsm/core/ZSMLogger\n*L\n256#1:266,2\n*E\n"})
public final class ZSMLogger {
    @NotNull
    public static final ZSMLogger INSTANCE = new ZSMLogger();
    @NotNull
    private static LogLevel logLevel = LogLevel.INFO;
    @Nullable
    private static Function2<? super LogLevel, ? super String, Unit> logFunction;

    private ZSMLogger() {
    }

    @NotNull
    public static final LogLevel getLogLevel() {
        return logLevel;
    }

    @JvmStatic
    public static /* synthetic */ void getLogLevel$annotations() {
    }

    @Nullable
    public static final Function2<LogLevel, String, Unit> getLogFunction() {
        return logFunction;
    }

    @JvmStatic
    public static /* synthetic */ void getLogFunction$annotations() {
    }

    @JvmStatic
    public static final void setLogFunction(@Nullable Function2<? super LogLevel, ? super String, Unit> logger) {
        logFunction = logger;
    }

    @JvmStatic
    public static final void overrideLogger(@Nullable Function2<? super LogLevel, ? super String, Unit> logger) {
        ZSMLogger.setLogFunction(logger);
    }

    @JvmStatic
    public static final void setLogLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        logLevel = level;
    }

    @JvmStatic
    @NotNull
    public static final String generateTraceId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String formatTraceMessage(@Nullable String traceId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (traceId == null) {
            return message;
        }
        if (StringsKt.contains$default((CharSequence)message, (CharSequence)"[TID:", (boolean)false, (int)2, null)) {
            return message;
        }
        return "[TID:" + traceId + "] " + message;
    }

    @JvmStatic
    @Nullable
    public static final String extractTraceId(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Pattern tidPattern = Pattern.compile("\\[TID:([^\\]]+)\\]");
        Matcher tidMatcher = tidPattern.matcher(message);
        if (tidMatcher.find()) {
            return tidMatcher.group(1);
        }
        Pattern traceIdPattern = Pattern.compile("traceId=([^\\s]+)");
        Matcher traceIdMatcher = traceIdPattern.matcher(message);
        if (traceIdMatcher.find()) {
            return traceIdMatcher.group(1);
        }
        Pattern tidColonPattern = Pattern.compile("TID:\\s*([^\\s\\)]+)");
        Matcher tidColonMatcher = tidColonPattern.matcher(message);
        if (tidColonMatcher.find()) {
            return tidColonMatcher.group(1);
        }
        return null;
    }

    @JvmStatic
    public static final void log(@NotNull Object[] args, @NotNull LogLevel level, @Nullable String traceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (level.getValue() < logLevel.getValue()) {
            return;
        }
        String rawMessage = ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String finalTraceId = traceId;
        String extractedTraceId = ZSMLogger.extractTraceId(rawMessage);
        if (extractedTraceId != null) {
            finalTraceId = extractedTraceId;
        }
        if (level == LogLevel.TRACE && finalTraceId == null) {
            finalTraceId = INSTANCE.generateTraceId();
        }
        ZonedDateTime now = ZonedDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String iso8601String = now.format(formatter);
        if (finalTraceId != null) {
            String messageWithoutTraceId = extractedTraceId != null ? ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)rawMessage, (String)("[TID:" + extractedTraceId + ']'), (String)"", (boolean)false, (int)4, null), (String)("traceId=" + extractedTraceId), (String)"", (boolean)false, (int)4, null), (String)("TID: " + extractedTraceId), (String)"", (boolean)false, (int)4, null))).toString() : rawMessage;
            string = "ZSM [" + iso8601String + "] level [" + (Object)((Object)level) + "] [TID:" + finalTraceId + "] " + messageWithoutTraceId;
        } else {
            string = "ZSM [" + iso8601String + "] level [" + (Object)((Object)level) + "] " + rawMessage;
        }
        String formattedMessage = string;
        Function2<? super LogLevel, ? super String, Unit> function2 = logFunction;
        if (function2 != null) {
            Function2<? super LogLevel, ? super String, Unit> it = function2;
            boolean bl = false;
            it.invoke((Object)level, (Object)formattedMessage);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                int n = Log.v((String)"ZSM", (String)formattedMessage);
                break;
            }
            case 2: {
                int n = Log.d((String)"ZSM", (String)formattedMessage);
                break;
            }
            case 3: {
                int n = Log.i((String)"ZSM", (String)formattedMessage);
                break;
            }
            case 4: {
                int n = Log.w((String)"ZSM", (String)formattedMessage);
                break;
            }
            case 5: {
                int n = Log.e((String)"ZSM", (String)formattedMessage);
                break;
            }
            case 6: {
                int n = Log.wtf((String)"ZSM", (String)formattedMessage);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void log$default(Object[] objectArray, LogLevel logLevel, String string, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.DEBUG;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        ZSMLogger.log(objectArray, logLevel, string);
    }

    @JvmStatic
    public static final void logTraceData(@Nullable byte[] traceData, @Nullable String traceId) {
        String string = traceId;
        if (string == null) {
            string = INSTANCE.generateTraceId();
        }
        String finalTraceId = string;
        Object[] objectArray = new Object[]{"Processing trace data from Rust"};
        ZSMLogger.log(objectArray, LogLevel.TRACE, finalTraceId);
        if (traceData == null || traceData.length == 0) {
            objectArray = new Object[]{"No trace data to process"};
            ZSMLogger.log(objectArray, LogLevel.TRACE, finalTraceId);
            return;
        }
        try {
            String string2;
            String usedTraceId;
            String string3;
            Object[] objectArray2;
            MatchResult traceIdMatch;
            String traceString = new String(traceData, Charsets.UTF_8);
            String extractedTraceId = null;
            if (traceId == null && (traceIdMatch = Regex.find$default((Regex)new Regex("trace_id:([^\\s]+)"), (CharSequence)traceString, (int)0, (int)2, null)) != null) {
                extractedTraceId = (String)traceIdMatch.getGroupValues().get(1);
                objectArray2 = new Object[]{"Extracted trace ID from data: " + extractedTraceId};
                ZSMLogger.log(objectArray2, LogLevel.TRACE, finalTraceId);
            }
            if (extractedTraceId != null && extractedTraceId.length() >= 32) {
                objectArray2 = new Object[]{"Using extracted trace ID"};
                ZSMLogger.log(objectArray2, LogLevel.TRACE, extractedTraceId);
                string3 = extractedTraceId;
            } else {
                string3 = usedTraceId = finalTraceId;
            }
            if (traceString.length() > 50) {
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = traceString.substring(0, 50);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                string2 = stringBuilder.append(string4).append("...").toString();
            } else {
                string2 = traceString;
            }
            String preview = string2;
            Object[] objectArray3 = new Object[]{"Trace data preview: " + preview};
            ZSMLogger.log(objectArray3, LogLevel.TRACE, usedTraceId);
            Object[] objectArray4 = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)traceString, (String[])objectArray4, (boolean)false, (int)0, (int)6, null);
            objectArray4 = new Object[]{"Processing " + lines.size() + " trace lines"};
            ZSMLogger.log(objectArray4, LogLevel.TRACE, usedTraceId);
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (!(((CharSequence)line).length() > 0)) continue;
                Object[] objectArray5 = new Object[]{line};
                ZSMLogger.log(objectArray5, LogLevel.TRACE, usedTraceId);
            }
        }
        catch (Exception e) {
            Object[] objectArray6 = new Object[]{"Error processing trace data: " + e.getMessage()};
            ZSMLogger.log(objectArray6, LogLevel.ERROR, finalTraceId);
        }
    }

    public static /* synthetic */ void logTraceData$default(byte[] byArray, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        ZSMLogger.logTraceData(byArray, string);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.FATAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

