/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.umfa;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMErrorCode;
import com.useideem.zsm.core.ZSMLogger;
import com.useideem.zsm.umfa.RelyingPartyError;
import com.useideem.zsm.umfa.RelyingPartyResponseError;
import com.useideem.zsm.utils.IdentityMapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u0004\u0018\u00010\u0003J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u001bJ@\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u00032\u001c\u0010'\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001b0(H\u0002JB\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u001c\u0010'\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001b0(J?\u0010-\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u001c\u0010'\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001b0(H\u0000\u00a2\u0006\u0002\b.JG\u0010/\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u000e2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u001c\u0010'\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001b0(H\u0000\u00a2\u0006\u0002\b1JB\u00102\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u0002042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u001c\u0010'\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001b0(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/useideem/zsm/umfa/RelyingParty;", "", "host", "", "apiKey", "applicationId", "context", "Landroid/content/Context;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/content/Context;)V", "customerDefinedIdentifier", "credentialID", "identityID", "publicKey", "Lorg/json/JSONObject;", "getPublicKey$zsm_release", "()Lorg/json/JSONObject;", "setPublicKey$zsm_release", "(Lorg/json/JSONObject;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ExecutorService;", "mainHandler", "Landroid/os/Handler;", "getUserIdentifier", "setUserIdentifier", "", "identifier", "getCredentialID", "setCredentialID", "id", "getIdentityID", "setIdentityID", "unbind", "makePostRequest", "endpoint", "body", "traceId", "callback", "Lkotlin/Function2;", "Lcom/useideem/zsm/core/ZSMError;", "authenticationStart", "userId", "credentialId", "createIdentityThenRegistrationStart", "createIdentityThenRegistrationStart$zsm_release", "registrationFinishAuthenticationStart", "credential", "registrationFinishAuthenticationStart$zsm_release", "checkServerSideIdentity", "createNewIdentity", "", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nRelyingParty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelyingParty.kt\ncom/useideem/zsm/umfa/RelyingParty\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class RelyingParty {
    @NotNull
    private final String host;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String applicationId;
    @NotNull
    private final Context context;
    @Nullable
    private String customerDefinedIdentifier;
    @Nullable
    private String credentialID;
    @Nullable
    private String identityID;
    @Nullable
    private JSONObject publicKey;
    private final ExecutorService executor;
    @NotNull
    private final Handler mainHandler;

    public RelyingParty(@NotNull String host, @NotNull String apiKey, @NotNull String applicationId, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.host = host;
        this.apiKey = apiKey;
        this.applicationId = applicationId;
        this.context = context;
        this.executor = Executors.newSingleThreadExecutor();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    @Nullable
    public final JSONObject getPublicKey$zsm_release() {
        return this.publicKey;
    }

    public final void setPublicKey$zsm_release(@Nullable JSONObject jSONObject) {
        this.publicKey = jSONObject;
    }

    @Nullable
    public final String getUserIdentifier() {
        return this.customerDefinedIdentifier;
    }

    public final void setUserIdentifier(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.customerDefinedIdentifier = identifier;
    }

    @Nullable
    public final String getCredentialID() {
        return this.credentialID;
    }

    public final void setCredentialID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.credentialID = id;
    }

    @Nullable
    public final String getIdentityID() {
        return this.identityID;
    }

    public final void setIdentityID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.identityID = id;
    }

    public final void unbind() {
        this.customerDefinedIdentifier = null;
        this.credentialID = null;
        this.identityID = null;
        this.publicKey = null;
    }

    private final void makePostRequest(String endpoint, JSONObject body, String traceId, Function2<? super JSONObject, ? super ZSMError, Unit> callback) {
        this.executor.execute(() -> RelyingParty.makePostRequest$lambda$5(this, endpoint, body, callback, traceId));
    }

    public final void authenticationStart(@NotNull String userId, @Nullable String credentialId, @Nullable String traceId, @NotNull Function2<? super JSONObject, ? super ZSMError, Unit> callback) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (credentialId == null) {
            callback.invoke(null, (Object)new RelyingPartyError("No credential ID provided", ZSMErrorCode.WEBAUTHN_NO_CREDENTIALS, traceId));
            return;
        }
        Object[] $this$authenticationStart_u24lambda_u247 = objectArray = new JSONObject();
        boolean bl = false;
        $this$authenticationStart_u24lambda_u247.put("customer_defined_identifier", (Object)userId);
        $this$authenticationStart_u24lambda_u247.put("application_id", (Object)this.applicationId);
        $this$authenticationStart_u24lambda_u247.put("credential_id", (Object)credentialId);
        String string = this.identityID;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$authenticationStart_u24lambda_u247.put("identity_id", (Object)it);
        }
        Object[] payload = objectArray;
        objectArray = new Object[]{"Authentication request payload: " + payload};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        this.makePostRequest("api/webauthn/authentication/start", (JSONObject)payload, traceId, (Function2<? super JSONObject, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> RelyingParty.authenticationStart$lambda$8(this, userId, callback, arg_0, arg_1)));
    }

    public static /* synthetic */ void authenticationStart$default(RelyingParty relyingParty, String string, String string2, String string3, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = UUID.randomUUID().toString();
        }
        relyingParty.authenticationStart(string, string2, string3, (Function2<? super JSONObject, ? super ZSMError, Unit>)function2);
    }

    public final void createIdentityThenRegistrationStart$zsm_release(@NotNull String userId, @Nullable String traceId, @NotNull Function2<? super JSONObject, ? super ZSMError, Unit> callback) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        JSONObject $this$createIdentityThenRegistrationStart_u24lambda_u249 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$createIdentityThenRegistrationStart_u24lambda_u249.put("customer_defined_identifier", (Object)userId);
        $this$createIdentityThenRegistrationStart_u24lambda_u249.put("application_id", (Object)this.applicationId);
        JSONObject payload = jSONObject;
        this.makePostRequest("api/webauthn/registration/create-identity-then-start", payload, traceId, (Function2<? super JSONObject, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> RelyingParty.createIdentityThenRegistrationStart$lambda$10(this, userId, callback, arg_0, arg_1)));
    }

    public static /* synthetic */ void createIdentityThenRegistrationStart$zsm_release$default(RelyingParty relyingParty, String string, String string2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        relyingParty.createIdentityThenRegistrationStart$zsm_release(string, string2, (Function2<? super JSONObject, ? super ZSMError, Unit>)function2);
    }

    public final void registrationFinishAuthenticationStart$zsm_release(@NotNull String userId, @NotNull JSONObject credential, @Nullable String traceId, @NotNull Function2<? super JSONObject, ? super ZSMError, Unit> callback) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        JSONObject $this$registrationFinishAuthenticationStart_u24lambda_u2411 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$registrationFinishAuthenticationStart_u24lambda_u2411.put("customer_defined_identifier", (Object)userId);
        $this$registrationFinishAuthenticationStart_u24lambda_u2411.put("application_id", (Object)this.applicationId);
        $this$registrationFinishAuthenticationStart_u24lambda_u2411.put("credential", (Object)credential);
        JSONObject payload = jSONObject;
        this.makePostRequest("api/webauthn/registration/finish-then-authentication-start", payload, traceId, (Function2<? super JSONObject, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> RelyingParty.registrationFinishAuthenticationStart$lambda$12(this, credential, userId, callback, arg_0, arg_1)));
    }

    public static /* synthetic */ void registrationFinishAuthenticationStart$zsm_release$default(RelyingParty relyingParty, String string, JSONObject jSONObject, String string2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        relyingParty.registrationFinishAuthenticationStart$zsm_release(string, jSONObject, string2, (Function2<? super JSONObject, ? super ZSMError, Unit>)function2);
    }

    public final void checkServerSideIdentity(@NotNull String userId, boolean createNewIdentity, @Nullable String traceId, @NotNull Function2<? super JSONObject, ? super ZSMError, Unit> callback) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.customerDefinedIdentifier = userId;
        JSONObject $this$checkServerSideIdentity_u24lambda_u2413 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$checkServerSideIdentity_u24lambda_u2413.put("customer_defined_identifier", (Object)userId);
        $this$checkServerSideIdentity_u24lambda_u2413.put("application_id", (Object)this.applicationId);
        if (createNewIdentity) {
            $this$checkServerSideIdentity_u24lambda_u2413.put("create_new_identity", (Object)"true");
        }
        JSONObject payload = jSONObject;
        this.makePostRequest("api/umfa/check-identity", payload, traceId, (Function2<? super JSONObject, ? super ZSMError, Unit>)((Function2)(arg_0, arg_1) -> RelyingParty.checkServerSideIdentity$lambda$14(this, userId, callback, arg_0, arg_1)));
    }

    public static /* synthetic */ void checkServerSideIdentity$default(RelyingParty relyingParty, String string, boolean bl, String string2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        relyingParty.checkServerSideIdentity(string, bl, string2, (Function2<? super JSONObject, ? super ZSMError, Unit>)function2);
    }

    private static final void makePostRequest$lambda$5$lambda$2(Function2 $callback, String $response) {
        $callback.invoke((Object)new JSONObject($response), null);
    }

    private static final void makePostRequest$lambda$5$lambda$3(Function2 $callback, int $responseCode, String $errorMessage, String $traceId) {
        Intrinsics.checkNotNull((Object)$errorMessage);
        $callback.invoke(null, (Object)new RelyingPartyResponseError($responseCode, $errorMessage, $traceId));
    }

    private static final void makePostRequest$lambda$5$lambda$4(Function2 $callback, Exception $e, String $traceId) {
        $callback.invoke(null, (Object)new RelyingPartyError($e, $traceId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void makePostRequest$lambda$5(RelyingParty this$0, String $endpoint, JSONObject $body, Function2 $callback, String $traceId) {
        block20: {
            char[] cArray = new char[]{'/'};
            StringBuilder stringBuilder = new StringBuilder().append(StringsKt.trimEnd((String)this$0.host, (char[])cArray)).append('/');
            cArray = new char[]{'/'};
            URL url = new URL(stringBuilder.append(StringsKt.trimStart((String)$endpoint, (char[])cArray)).toString());
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            try {
                boolean bl;
                Object reader;
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", "Bearer " + this$0.apiKey);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                Object object = new Object[]{"Making request to " + url + " with body: " + $body};
                ZSMLogger.log$default(object, null, null, 6, null);
                object = new OutputStreamWriter(connection.getOutputStream());
                Throwable throwable = null;
                try {
                    OutputStreamWriter writer = (OutputStreamWriter)object;
                    boolean bl2 = false;
                    writer.write($body.toString());
                    writer.flush();
                    writer = Unit.INSTANCE;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                int responseCode = connection.getResponseCode();
                InputStream responseStream = (200 <= responseCode ? responseCode < 300 : false) ? connection.getInputStream() : connection.getErrorStream();
                Object[] bl2 = (Object[])new BufferedReader(new InputStreamReader(responseStream));
                Object[] objectArray = null;
                try {
                    reader = (BufferedReader)bl2;
                    boolean bl3 = false;
                    reader = TextStreamsKt.readText((Reader)((Reader)reader));
                }
                catch (Throwable throwable2) {
                    objectArray = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)bl2, (Throwable)objectArray);
                }
                Object response = reader;
                boolean bl4 = 200 <= responseCode ? responseCode < 300 : false;
                if (bl4) {
                    bl2 = new Object[]{"Request successful (" + url + ") - " + (String)response};
                    ZSMLogger.log$default(bl2, null, null, 6, null);
                    bl = this$0.mainHandler.post(() -> RelyingParty.makePostRequest$lambda$5$lambda$2($callback, (String)response));
                    break block20;
                }
                try {
                    objectArray = new JSONObject((String)response).optString("error", (String)response);
                }
                catch (Exception e) {
                    objectArray = response;
                }
                Object[] errorMessage = objectArray;
                objectArray = new Object[]{"Request failed (" + url + ") - HTTP " + responseCode + " - " + (String)errorMessage};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                bl = this$0.mainHandler.post(() -> RelyingParty.makePostRequest$lambda$5$lambda$3($callback, responseCode, (String)errorMessage, $traceId));
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{"Network request failed (" + url + "): " + e.getMessage()};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                this$0.mainHandler.post(() -> RelyingParty.makePostRequest$lambda$5$lambda$4($callback, e, $traceId));
            }
            finally {
                connection.disconnect();
            }
        }
    }

    private static final Unit authenticationStart$lambda$8(RelyingParty this$0, String $userId, Function2 $callback, JSONObject response, ZSMError error) {
        String respIdentityId;
        Object[] objectArray;
        if (response != null && !((objectArray = (Object[])(respIdentityId = response.optString("identity_id", ""))) == null || objectArray.length() == 0) && this$0.identityID == null) {
            this$0.identityID = respIdentityId;
            objectArray = new Object[]{"Identity ID retrieved during authentication: " + respIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            IdentityMapper.INSTANCE.storeIdentityId(this$0.context, $userId, respIdentityId);
            objectArray = new Object[]{"Stored identity mapping: " + $userId + " -> " + respIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        $callback.invoke((Object)response, (Object)error);
        return Unit.INSTANCE;
    }

    private static final Unit createIdentityThenRegistrationStart$lambda$10(RelyingParty this$0, String $userId, Function2 $callback, JSONObject response, ZSMError error) {
        if (response != null) {
            this$0.publicKey = response.getJSONObject("ccr").getJSONObject("publicKey");
            String respIdentityId = response.optString("identity_id", "");
            Object[] objectArray = (Object[])respIdentityId;
            if (!(objectArray == null || objectArray.length() == 0)) {
                this$0.identityID = respIdentityId;
                objectArray = new Object[]{"Identity ID retrieved: " + respIdentityId};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                IdentityMapper.INSTANCE.storeIdentityId(this$0.context, $userId, respIdentityId);
                objectArray = new Object[]{"Stored identity mapping: " + $userId + " -> " + respIdentityId};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
            }
        }
        $callback.invoke((Object)response, (Object)error);
        return Unit.INSTANCE;
    }

    private static final Unit registrationFinishAuthenticationStart$lambda$12(RelyingParty this$0, JSONObject $credential, String $userId, Function2 $callback, JSONObject response, ZSMError error) {
        if (response != null) {
            this$0.credentialID = $credential.has("rawId") ? $credential.getString("rawId") : null;
            String respIdentityId = response.optString("identity_id", "");
            Object[] objectArray = (Object[])respIdentityId;
            if (!(objectArray == null || objectArray.length() == 0) && this$0.identityID == null) {
                this$0.identityID = respIdentityId;
                objectArray = new Object[]{"Identity ID retrieved during registration finish: " + respIdentityId};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                IdentityMapper.INSTANCE.storeIdentityId(this$0.context, $userId, respIdentityId);
                objectArray = new Object[]{"Stored identity mapping: " + $userId + " -> " + respIdentityId};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
            }
        }
        $callback.invoke((Object)response, (Object)error);
        return Unit.INSTANCE;
    }

    private static final Unit checkServerSideIdentity$lambda$14(RelyingParty this$0, String $userId, Function2 $callback, JSONObject response, ZSMError error) {
        String respIdentityId;
        Object[] objectArray;
        if (response != null && !((objectArray = (Object[])(respIdentityId = response.optString("identity_id", ""))) == null || objectArray.length() == 0)) {
            this$0.identityID = respIdentityId;
            objectArray = new Object[]{"Identity ID retrieved from check-identity: " + respIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            IdentityMapper.INSTANCE.storeIdentityId(this$0.context, $userId, respIdentityId);
            objectArray = new Object[]{"Stored identity mapping: " + $userId + " -> " + respIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        $callback.invoke((Object)response, (Object)error);
        return Unit.INSTANCE;
    }
}

