/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.umfa;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.useideem.zsm.core.ZSMBooleanCallback;
import com.useideem.zsm.core.ZSMClientBase;
import com.useideem.zsm.core.ZSMConfig;
import com.useideem.zsm.core.ZSMError;
import com.useideem.zsm.core.ZSMJSONCallback;
import com.useideem.zsm.core.ZSMLogger;
import com.useideem.zsm.fido2.FIDO2Client;
import com.useideem.zsm.fido2.MPCNetworkClient;
import com.useideem.zsm.umfa.RelyingParty;
import com.useideem.zsm.utils.CredentialMapper;
import com.useideem.zsm.utils.IdentityMapper;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u00010B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002Jq\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#Jq\u0010$\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!J\u0016\u0010$\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#Js\u0010%\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!H\u0002Jo\u0010&\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132_\u0010\u0017\u001a[\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b((\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`)J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010&\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020+Jq\u0010,\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!J\u0016\u0010,\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#Js\u0010-\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!H\u0002Jk\u0010.\u001a\u00020\u00162a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!H\u0016Js\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00132a\u0010\u0017\u001a]\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u0018j\u0002`!H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lcom/useideem/zsm/umfa/UMFAClient;", "Lcom/useideem/zsm/core/ZSMClientBase;", "context", "Landroid/content/Context;", "config", "Lcom/useideem/zsm/core/ZSMConfig;", "relyingParty", "Lcom/useideem/zsm/umfa/RelyingParty;", "mpcNetworkClient", "Lcom/useideem/zsm/fido2/MPCNetworkClient;", "<init>", "(Landroid/content/Context;Lcom/useideem/zsm/core/ZSMConfig;Lcom/useideem/zsm/umfa/RelyingParty;Lcom/useideem/zsm/fido2/MPCNetworkClient;)V", "(Landroid/content/Context;Lcom/useideem/zsm/core/ZSMConfig;Lcom/useideem/zsm/fido2/MPCNetworkClient;)V", "fido2Client", "Lcom/useideem/zsm/fido2/FIDO2Client;", "getRelyingParty$zsm_release", "()Lcom/useideem/zsm/umfa/RelyingParty;", "getClient", "userId", "", "ensureCorrectConsumerIdForMPC", "checkEnrollment", "", "completion", "Lkotlin/Function3;", "Lorg/json/JSONObject;", "Lkotlin/ParameterName;", "name", "result", "", "metadata", "Lcom/useideem/zsm/core/ZSMError;", "error", "Lcom/useideem/zsm/core/ZSMJSONCallbackFn;", "callback", "Lcom/useideem/zsm/core/ZSMJSONCallback;", "enroll", "webauthnCreate", "unenroll", "", "success", "Lcom/useideem/zsm/core/ZSMBooleanCallbackFn;", "cleanupUserData", "Lcom/useideem/zsm/core/ZSMBooleanCallback;", "authenticate", "webauthnPartialGet", "unbind", "user", "Companion", "zsm_release"})
public final class UMFAClient
extends ZSMClientBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FIDO2Client fido2Client;
    @Nullable
    private final MPCNetworkClient mpcNetworkClient;
    @NotNull
    private final RelyingParty relyingParty;
    @JvmField
    @NotNull
    public static final String versionString = Reflection.getOrCreateKotlinClass(UMFAClient.class).getSimpleName() + " 2.4.4";

    @NotNull
    public final RelyingParty getRelyingParty$zsm_release() {
        return this.relyingParty;
    }

    public UMFAClient(@NotNull Context context, @NotNull ZSMConfig config, @NotNull RelyingParty relyingParty, @Nullable MPCNetworkClient mpcNetworkClient) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)relyingParty, (String)"relyingParty");
        super(context, config);
        this.relyingParty = relyingParty;
        this.mpcNetworkClient = mpcNetworkClient;
        this.fido2Client = new FIDO2Client(context, config, mpcNetworkClient);
    }

    public /* synthetic */ UMFAClient(Context context, ZSMConfig zSMConfig, RelyingParty relyingParty, MPCNetworkClient mPCNetworkClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            mPCNetworkClient = null;
        }
        this(context, zSMConfig, relyingParty, mPCNetworkClient);
    }

    public UMFAClient(@NotNull Context context, @NotNull ZSMConfig config, @Nullable MPCNetworkClient mpcNetworkClient) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getAuthenticationHost();
        if (string == null) {
            throw new IllegalStateException("Missing authenticationHost".toString());
        }
        String string2 = config.getApiKey();
        if (string2 == null) {
            throw new IllegalStateException("Missing apiKey".toString());
        }
        this(context, config, new RelyingParty(string, string2, config.getApplicationId(), context), mpcNetworkClient);
    }

    public /* synthetic */ UMFAClient(Context context, ZSMConfig zSMConfig, MPCNetworkClient mPCNetworkClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mPCNetworkClient = null;
        }
        this(context, zSMConfig, mPCNetworkClient);
    }

    private final FIDO2Client getClient(String userId) {
        FIDO2Client client;
        FIDO2Client fIDO2Client;
        Object[] currentUserId;
        boolean needsReset;
        boolean bl = needsReset = !Intrinsics.areEqual((Object)userId, (Object)this.relyingParty.getUserIdentifier());
        if (needsReset) {
            Object[] objectArray;
            String preservedCredentialId = this.relyingParty.getCredentialID();
            currentUserId = this.relyingParty.getUserIdentifier();
            this.relyingParty.unbind();
            this.fido2Client = null;
            this.relyingParty.setUserIdentifier(userId);
            if (preservedCredentialId != null && Intrinsics.areEqual((Object)currentUserId, (Object)userId)) {
                this.relyingParty.setCredentialID(preservedCredentialId);
                objectArray = new Object[]{"Restored credential ID for same user: " + preservedCredentialId};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
            }
            objectArray = new Object[]{"Switched to user: " + userId + ", identity_id will be loaded from storage"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        } else {
            this.relyingParty.setUserIdentifier(userId);
        }
        String correctConsumerId = this.ensureCorrectConsumerIdForMPC(userId);
        if (!Intrinsics.areEqual((Object)correctConsumerId, (Object)this.getConfig().getConsumerId())) {
            this.getConfig().setConsumerId(correctConsumerId);
            currentUserId = new Object[]{"Updated consumer_id for MPC: " + correctConsumerId};
            ZSMLogger.log$default(currentUserId, null, null, 6, null);
        }
        if ((fIDO2Client = this.fido2Client) == null) {
            fIDO2Client = new FIDO2Client(this.getContext(), this.getConfig(), this.mpcNetworkClient);
        }
        this.fido2Client = client = fIDO2Client;
        return client;
    }

    private final String ensureCorrectConsumerIdForMPC(String userId) {
        String storedIdentityId = IdentityMapper.INSTANCE.getIdentityId(this.getContext(), userId);
        if (storedIdentityId != null) {
            Object[] objectArray = new Object[]{"Found stored identity mapping: " + userId + " -> " + storedIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            this.relyingParty.setIdentityID(storedIdentityId);
            return storedIdentityId;
        }
        String string = this.relyingParty.getIdentityID();
        if (string != null) {
            String sessionIdentityId = string;
            boolean bl = false;
            Object[] objectArray = new Object[]{"Using cached identity_id for MPC: " + sessionIdentityId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return sessionIdentityId;
        }
        Object[] objectArray = new Object[]{"CRITICAL: No identity_id found for user " + userId + " - this suggests identity mapping is not working!"};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        objectArray = new Object[]{"CRITICAL: Temporarily falling back to userId, but this will likely cause 'Identity not found' errors"};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        return userId;
    }

    public final void checkEnrollment(@NotNull String userId, @NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke(null, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String traceId = string;
        Object[] objectArray = new Object[]{"checkEnrollment started TID: " + traceId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        FIDO2Client client = this.getClient(userId);
        client.configure(this.getConfig());
        client.webauthnRetrieveWithTraceId(traceId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.checkEnrollment$lambda$1(traceId, completion, this, arg_0, arg_1, arg_2)));
    }

    public final void checkEnrollment(@NotNull String userId, @NotNull ZSMJSONCallback callback) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.checkEnrollment(userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.checkEnrollment$lambda$2(callback, arg_0, arg_1, arg_2)));
    }

    public final void enroll(@NotNull String userId, @NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke(null, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        this.checkEnrollment(userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.enroll$lambda$3(completion, this, userId, arg_0, arg_1, arg_2)));
    }

    public final void enroll(@NotNull String userId, @NotNull ZSMJSONCallback callback) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.enroll(userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.enroll$lambda$4(callback, arg_0, arg_1, arg_2)));
    }

    private final void webauthnCreate(String userId, Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Object[] objectArray = new Object[]{"Calling checkIdentity with userId: " + userId + " and applicationId: " + this.getConfig().getApplicationId()};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke(null, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        FIDO2Client client = this.getClient(userId);
        RelyingParty.createIdentityThenRegistrationStart$zsm_release$default(this.relyingParty, userId, null, (arg_0, arg_1) -> UMFAClient.webauthnCreate$lambda$8(completion, userId, this, client, arg_0, arg_1), 2, null);
    }

    public final void unenroll(@NotNull String userId, @NotNull Function3<? super Boolean, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke((Object)false, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        String userId2 = this.ensureCorrectConsumerIdForMPC(userId);
        if (!Intrinsics.areEqual((Object)userId2, (Object)this.getConfig().getConsumerId())) {
            this.getConfig().setConsumerId(userId2);
            this.configure(this.getConfig());
        }
        this.checkEnrollment(userId2, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.unenroll$lambda$10(completion, this, userId2, arg_0, arg_1, arg_2)));
    }

    private final void cleanupUserData(String userId) {
        try {
            IdentityMapper.INSTANCE.removeIdentityId(this.getContext(), userId);
            Object[] objectArray = new Object[]{"Removed identity mapping for user: " + userId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            CredentialMapper.INSTANCE.removeCredentialId(this.getContext(), userId);
            objectArray = new Object[]{"Removed credential mapping for user: " + userId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Warning: Error cleaning up user data for " + userId + ": " + e.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
    }

    public final void unenroll(@NotNull String userId, @NotNull ZSMBooleanCallback callback) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.unenroll(userId, (Function3<? super Boolean, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.unenroll$lambda$11(callback, arg_0, arg_1, arg_2)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void authenticate(@NotNull String userId, @NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke(null, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        String currentCredentialId = this.relyingParty.getCredentialID();
        Object[] objectArray2 = new Object[]{"Current credential ID in RelyingParty: " + currentCredentialId};
        ZSMLogger.log$default(objectArray2, null, null, 6, null);
        CharSequence charSequence = currentCredentialId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string = CredentialMapper.INSTANCE.getCredentialId(this.getContext(), userId);
            if (string == null) {
                Object[] objectArray3 = new Object[]{"No stored credential ID found for user: " + userId};
                ZSMLogger.log$default(objectArray3, null, null, 6, null);
                completion.invoke(null, null, (Object)new ZSMError("User is not enrolled", null, 2, null));
                return;
            }
            this.relyingParty.setCredentialID(string);
            objectArray = new Object[]{"Retrieved stored credential ID: " + string};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        } else {
            Object[] objectArray4 = new Object[]{"Using existing credential ID: " + currentCredentialId};
            ZSMLogger.log$default(objectArray4, null, null, 6, null);
        }
        String string = this.relyingParty.getIdentityID();
        objectArray = new Object[]{"Current identity ID in RelyingParty: " + string};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        objectArray = string;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            String storedIdentityId = IdentityMapper.INSTANCE.getIdentityId(this.getContext(), userId);
            if (storedIdentityId != null) {
                this.relyingParty.setIdentityID(storedIdentityId);
                Object[] objectArray5 = new Object[]{"Retrieved stored identity ID for authentication: " + storedIdentityId};
                ZSMLogger.log$default(objectArray5, null, null, 6, null);
            } else {
                Object[] objectArray6 = new Object[]{"WARNING: No stored identity ID found for authentication"};
                ZSMLogger.log$default(objectArray6, null, null, 6, null);
            }
        } else {
            objectArray = new Object[]{"Using existing identity ID: " + string};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        objectArray = new Object[]{"About to call webauthnPartialGet with userId: " + userId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        this.webauthnPartialGet(userId, completion);
    }

    public final void authenticate(@NotNull String userId, @NotNull ZSMJSONCallback callback) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.authenticate(userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.authenticate$lambda$12(callback, arg_0, arg_1, arg_2)));
    }

    private final void webauthnPartialGet(String userId, Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        if (StringsKt.isBlank((CharSequence)userId)) {
            completion.invoke(null, null, (Object)new ZSMError("User ID is missing", null, 2, null));
            return;
        }
        FIDO2Client client = this.getClient(userId);
        Object[] objectArray = new Object[]{"Calling authenticationStart with credentialID: " + this.relyingParty.getCredentialID()};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
        RelyingParty.authenticationStart$default(this.relyingParty, userId, this.relyingParty.getCredentialID(), null, (arg_0, arg_1) -> UMFAClient.webauthnPartialGet$lambda$14(completion, client, arg_0, arg_1), 4, null);
    }

    @Override
    public void unbind(@NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        block0: {
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            this.relyingParty.unbind();
            FIDO2Client fIDO2Client = this.fido2Client;
            if (fIDO2Client == null) break block0;
            fIDO2Client.unbind(completion);
        }
    }

    @Override
    public void unbind(@NotNull String user, @NotNull Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit> completion) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            this.relyingParty.unbind();
            FIDO2Client fIDO2Client = this.fido2Client;
            if (fIDO2Client == null) break block0;
            fIDO2Client.unbind(user, completion);
        }
    }

    private static final Unit checkEnrollment$lambda$1(String $traceId, Function3 $completion, UMFAClient this$0, JSONObject result, Map map, ZSMError error) {
        if (error != null) {
            Object[] objectArray = new Object[]{"checkEnrollment failed TID: " + $traceId + " - " + error.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            $completion.invoke(null, null, (Object)error);
        } else if (result != null) {
            String credentialID = result.get("rawId").toString();
            this$0.relyingParty.setCredentialID(credentialID);
            Object[] objectArray = new Object[]{"checkEnrollment completed TID: " + $traceId + " - credential found"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            $completion.invoke((Object)result, (Object)MapsKt.emptyMap(), null);
        } else {
            Object[] objectArray = new Object[]{"checkEnrollment completed TID: " + $traceId + " - no credential found"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            $completion.invoke(null, null, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit checkEnrollment$lambda$2(ZSMJSONCallback $callback, JSONObject result, Map metadata, ZSMError error) {
        $callback.onComplete(result, metadata, error);
        return Unit.INSTANCE;
    }

    private static final Unit enroll$lambda$3(Function3 $completion, UMFAClient this$0, String $userId, JSONObject result, Map map, ZSMError error) {
        if (error != null) {
            $completion.invoke(null, null, (Object)error);
        } else if (result != null) {
            $completion.invoke(null, null, (Object)new ZSMError("User is already enrolled", null, 2, null));
        } else {
            this$0.webauthnCreate($userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)$completion);
        }
        return Unit.INSTANCE;
    }

    private static final Unit enroll$lambda$4(ZSMJSONCallback $callback, JSONObject result, Map metadata, ZSMError error) {
        $callback.onComplete(result, metadata, error);
        return Unit.INSTANCE;
    }

    private static final void webauthnCreate$lambda$8$lambda$7$lambda$6$lambda$5(String $token, Function3 $completion, JSONObject $credentialJson) {
        Intrinsics.checkNotNull((Object)$token);
        if (((CharSequence)$token).length() > 0) {
            JSONObject tokenResult = new JSONObject();
            tokenResult.put("token", (Object)$token);
            $completion.invoke((Object)tokenResult, (Object)MapsKt.emptyMap(), null);
        } else {
            $completion.invoke((Object)$credentialJson, (Object)MapsKt.emptyMap(), null);
        }
    }

    private static final Unit webauthnCreate$lambda$8$lambda$7$lambda$6(Function3 $completion, String $userId, JSONObject $credentialJson, UMFAClient this$0, JSONObject finalCredential, ZSMError regFinishError) {
        Object[] objectArray;
        if (regFinishError != null || finalCredential == null) {
            Object[] objectArray2 = new Object[1];
            ZSMError zSMError = regFinishError;
            objectArray2[0] = "registrationFinish failed: " + (zSMError != null ? zSMError.getMessage() : null);
            ZSMLogger.log$default(objectArray2, null, null, 6, null);
            ZSMError zSMError2 = regFinishError;
            $completion.invoke(null, null, (Object)new ZSMError("Failed to complete registration for user: " + $userId + " - " + (zSMError2 != null ? zSMError2.getMessage() : null), null, 2, null));
            return Unit.INSTANCE;
        }
        String credentialId = $credentialJson.optString("rawId");
        Intrinsics.checkNotNull((Object)credentialId);
        if (((CharSequence)credentialId).length() > 0) {
            this$0.relyingParty.setCredentialID(credentialId);
            CredentialMapper.INSTANCE.storeCredentialId(this$0.getContext(), $userId, credentialId);
            objectArray = new Object[]{"Credential ID set from enrollment: " + credentialId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        } else {
            objectArray = new Object[]{"WARNING: No rawId found in creation result"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        String enrollmentIdentityId = this$0.relyingParty.getIdentityID();
        Object[] objectArray3 = (Object[])enrollmentIdentityId;
        if (!(objectArray3 == null || objectArray3.length() == 0)) {
            this$0.getConfig().setIdentityId(enrollmentIdentityId);
            objectArray3 = new Object[]{"Identity ID propagated to config after enrollment: " + enrollmentIdentityId};
            ZSMLogger.log$default(objectArray3, null, null, 6, null);
        } else {
            objectArray3 = new Object[]{"WARNING: No identity_id available after enrollment"};
            ZSMLogger.log$default(objectArray3, null, null, 6, null);
        }
        String token = $credentialJson.optString("token");
        new Handler(Looper.getMainLooper()).post(() -> UMFAClient.webauthnCreate$lambda$8$lambda$7$lambda$6$lambda$5(token, $completion, $credentialJson));
        return Unit.INSTANCE;
    }

    private static final void webauthnCreate$lambda$8$lambda$7(String $userId, Function3 $completion, UMFAClient this$0, JSONObject creationResult, Map map, ZSMError creationError) {
        if (creationError != null || creationResult == null) {
            Object[] objectArray = new Object[1];
            ZSMError zSMError = creationError;
            objectArray[0] = "WebAuthn credential creation failed for user: " + $userId + " - " + (zSMError != null ? zSMError.getMessage() : null);
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            ZSMError zSMError2 = creationError;
            $completion.invoke(null, null, (Object)new ZSMError("WebAuthn credential creation failed for user: " + $userId + " - " + (zSMError2 != null ? zSMError2.getMessage() : null), null, 2, null));
            return;
        }
        JSONObject credentialJson = creationResult;
        RelyingParty.registrationFinishAuthenticationStart$zsm_release$default(this$0.relyingParty, $userId, credentialJson, null, (arg_0, arg_1) -> UMFAClient.webauthnCreate$lambda$8$lambda$7$lambda$6($completion, $userId, credentialJson, this$0, arg_0, arg_1), 4, null);
    }

    private static final Unit webauthnCreate$lambda$8(Function3 $completion, String $userId, UMFAClient this$0, FIDO2Client $client, JSONObject response, ZSMError error) {
        JSONObject publicKey;
        if (error != null || response == null) {
            Object[] objectArray = new Object[1];
            ZSMError zSMError = error;
            objectArray[0] = "checkIdentity failed: " + (zSMError != null ? zSMError.getMessage() : null);
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            ZSMError zSMError2 = error;
            $completion.invoke(null, null, (Object)new ZSMError("Failed to verify identity for user: " + $userId + " - " + (zSMError2 != null ? zSMError2.getMessage() : null), null, 2, null));
            return Unit.INSTANCE;
        }
        String correctConsumerId = this$0.ensureCorrectConsumerIdForMPC($userId);
        if (!Intrinsics.areEqual((Object)correctConsumerId, (Object)this$0.getConfig().getConsumerId())) {
            Object[] objectArray = new Object[]{"Reconfiguring FIDO2 client with correct consumer_id: " + correctConsumerId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            this$0.getConfig().setConsumerId(correctConsumerId);
            $client.configure(this$0.getConfig());
        }
        if ((publicKey = this$0.relyingParty.getPublicKey$zsm_release()) == null) {
            $completion.invoke(null, null, (Object)new ZSMError("Identity check did not return a Public Key", null, 2, null));
            return Unit.INSTANCE;
        }
        $client.webauthnCreate(publicKey, (arg_0, arg_1, arg_2) -> UMFAClient.webauthnCreate$lambda$8$lambda$7($userId, $completion, this$0, arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit unenroll$lambda$10$lambda$9(Function3 $completion, String $userId, JSONObject result, Map map, ZSMError error) {
        if (error != null) {
            $completion.invoke((Object)false, null, (Object)error);
        } else {
            Object[] objectArray = new Object[]{"User " + $userId + " successfully unenrolled and local data cleaned up"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            $completion.invoke((Object)true, (Object)MapsKt.emptyMap(), null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unenroll$lambda$10(Function3 $completion, UMFAClient this$0, String $userId, JSONObject result, Map map, ZSMError error) {
        if (error != null) {
            $completion.invoke((Object)false, null, (Object)error);
        } else if (result == null) {
            $completion.invoke((Object)false, null, (Object)new ZSMError("User is not enrolled", null, 2, null));
        } else {
            this$0.cleanupUserData($userId);
            this$0.unbind($userId, (Function3<? super JSONObject, ? super Map<String, String>, ? super ZSMError, Unit>)((Function3)(arg_0, arg_1, arg_2) -> UMFAClient.unenroll$lambda$10$lambda$9($completion, $userId, arg_0, arg_1, arg_2)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit unenroll$lambda$11(ZSMBooleanCallback $callback, boolean result, Map metadata, ZSMError error) {
        $callback.onComplete(result, metadata, error);
        return Unit.INSTANCE;
    }

    private static final Unit authenticate$lambda$12(ZSMJSONCallback $callback, JSONObject result, Map metadata, ZSMError error) {
        $callback.onComplete(result, metadata, error);
        return Unit.INSTANCE;
    }

    private static final void webauthnPartialGet$lambda$14$lambda$13(Function3 $completion, JSONObject credential, Map map, ZSMError authError) {
        if (authError != null || credential == null) {
            Object[] objectArray = new Object[1];
            ZSMError zSMError = authError;
            objectArray[0] = "webauthnGet failed: " + (zSMError != null ? zSMError.getMessage() : null);
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            ZSMError zSMError2 = authError;
            $completion.invoke(null, null, (Object)new ZSMError("Authentication failed: " + (zSMError2 != null ? zSMError2.getMessage() : null), null, 2, null));
            return;
        }
        $completion.invoke((Object)credential, (Object)MapsKt.emptyMap(), null);
    }

    private static final Unit webauthnPartialGet$lambda$14(Function3 $completion, FIDO2Client $client, JSONObject authStart, ZSMError authStartError) {
        JSONObject publicKey;
        if (authStartError != null || authStart == null) {
            Object object = authStartError;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "Unknown error during authentication start";
            }
            Object errorMessage = object;
            Object[] objectArray = new Object[]{"authenticationStart failed: " + (String)errorMessage};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            $completion.invoke(null, null, (Object)new ZSMError((String)errorMessage, null, 2, null));
            return Unit.INSTANCE;
        }
        Object[] errorMessage = new Object[]{"Authentication start response: " + authStart};
        ZSMLogger.log$default(errorMessage, null, null, 6, null);
        JSONObject jSONObject = authStart.optJSONObject("rcr");
        Object object = publicKey = jSONObject != null ? jSONObject.optJSONObject("publicKey") : null;
        if (publicKey == null) {
            $completion.invoke(null, null, (Object)new ZSMError("Authentication failed: Missing `publicKey` inside `rcr`", null, 2, null));
            return Unit.INSTANCE;
        }
        $client.webauthnGet(publicKey, (arg_0, arg_1, arg_2) -> UMFAClient.webauthnPartialGet$lambda$14$lambda$13($completion, arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/useideem/zsm/umfa/UMFAClient$Companion;", "", "<init>", "()V", "versionString", "", "zsm_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

