/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.useideem.zsm.core.ZSMLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/useideem/zsm/utils/CredentialMapper;", "", "<init>", "()V", "PREFS_NAME", "", "PREFIX", "storeCredentialId", "", "context", "Landroid/content/Context;", "userId", "credentialId", "getCredentialId", "removeCredentialId", "clearAllMappings", "getPreferences", "Landroid/content/SharedPreferences;", "zsm_release"})
public final class CredentialMapper {
    @NotNull
    public static final CredentialMapper INSTANCE = new CredentialMapper();
    @NotNull
    private static final String PREFS_NAME = "credential_mapper";
    @NotNull
    private static final String PREFIX = "credential_id_";

    private CredentialMapper() {
    }

    public final void storeCredentialId(@NotNull Context context, @NotNull String userId, @NotNull String credentialId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)credentialId, (String)"credentialId");
        if (StringsKt.isBlank((CharSequence)userId) || StringsKt.isBlank((CharSequence)credentialId)) {
            Object[] objectArray = new Object[]{"Cannot store empty userId or credentialId"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return;
        }
        SharedPreferences preferences = this.getPreferences(context);
        preferences.edit().putString(PREFIX + userId, credentialId).apply();
        Object[] objectArray = new Object[]{"Stored credential ID " + credentialId + " for user ID " + userId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    @Nullable
    public final String getCredentialId(@NotNull Context context, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (StringsKt.isBlank((CharSequence)userId)) {
            Object[] objectArray = new Object[]{"Cannot lookup credential for empty userId"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return null;
        }
        SharedPreferences preferences = this.getPreferences(context);
        String credentialId = preferences.getString(PREFIX + userId, null);
        if (credentialId != null) {
            Object[] objectArray = new Object[]{"Retrieved credential ID " + credentialId + " for user ID " + userId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        } else {
            Object[] objectArray = new Object[]{"No credential ID found for user ID " + userId};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
        }
        return credentialId;
    }

    public final void removeCredentialId(@NotNull Context context, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (StringsKt.isBlank((CharSequence)userId)) {
            Object[] objectArray = new Object[]{"Cannot remove credential for empty userId"};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return;
        }
        SharedPreferences preferences = this.getPreferences(context);
        preferences.edit().remove(PREFIX + userId).apply();
        Object[] objectArray = new Object[]{"Removed credential ID for user ID " + userId};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    public final void clearAllMappings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences preferences = this.getPreferences(context);
        preferences.edit().clear().apply();
        Object[] objectArray = new Object[]{"Cleared all credential ID mappings"};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    private final SharedPreferences getPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        return sharedPreferences;
    }
}

