/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.utils;

import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.useideem.zsm.core.ZSMLogger;
import com.useideem.zsm.utils.DecryptionSecret;
import com.useideem.zsm.utils.EncryptionSecret;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0007J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u0007J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0017\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/useideem/zsm/utils/KeystoreHelper;", "", "<init>", "()V", "KEY_SIZE", "", "PROVIDER", "", "TRANSFORMATION", "DEFAULT_ALGORITHM", "DEFAULT_DIGEST", "NULL", "", "EMPTY", "NEW_LINE", "encrypt", "Lcom/useideem/zsm/utils/DecryptionSecret;", "encryptionSecret", "Lcom/useideem/zsm/utils/EncryptionSecret;", "decrypt", "decryptionSecret", "generateKeyPair", "", "alias", "digests", "deleteKeyPair", "generateSigningKey", "signMessage", "", "data", "algorithm", "verifySignature", "", "signatureBytes", "getPublicKey", "Ljava/security/PublicKey;", "zsm_release"})
@SourceDebugExtension(value={"SMAP\nKeystoreHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeystoreHelper.kt\ncom/useideem/zsm/utils/KeystoreHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class KeystoreHelper {
    @NotNull
    public static final KeystoreHelper INSTANCE = new KeystoreHelper();
    private static final int KEY_SIZE = 128;
    @NotNull
    private static final String PROVIDER = "AndroidKeyStore";
    @NotNull
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    @NotNull
    public static final String DEFAULT_ALGORITHM = "NONEwithECDSA";
    @NotNull
    public static final String DEFAULT_DIGEST = "NONE";
    @Nullable
    private static final Void NULL;
    @NotNull
    private static final String EMPTY = "";
    @NotNull
    private static final String NEW_LINE = "\n";

    private KeystoreHelper() {
    }

    @NotNull
    public final DecryptionSecret encrypt(@NotNull EncryptionSecret encryptionSecret) {
        Intrinsics.checkNotNullParameter((Object)encryptionSecret, (String)"encryptionSecret");
        KeyGenerator kg = KeyGenerator.getInstance("AES", PROVIDER);
        String[] stringArray = new String[]{"GCM"};
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(encryptionSecret.getAlias(), 3).setBlockModes(stringArray);
        stringArray = new String[]{"NoPadding"};
        KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
        KeyGenParameterSpec kps = keyGenParameterSpec;
        kg.init((AlgorithmParameterSpec)kps);
        SecretKey sk = kg.generateKey();
        Cipher c = Cipher.getInstance(TRANSFORMATION);
        c.init(1, sk);
        String string = encryptionSecret.getData();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] eb = c.doFinal(byArray);
        String ctB64 = Base64.encodeToString((byte[])eb, (int)1);
        String ivB64 = Base64.encodeToString((byte[])c.getIV(), (int)1);
        Intrinsics.checkNotNull((Object)ctB64);
        String string2 = StringsKt.replace$default((String)ctB64, (String)NEW_LINE, (String)EMPTY, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)ivB64);
        String string3 = StringsKt.replace$default((String)ivB64, (String)NEW_LINE, (String)EMPTY, (boolean)false, (int)4, null);
        String string4 = encryptionSecret.getAlias();
        return new DecryptionSecret(string4, string2, string3);
    }

    @NotNull
    public final EncryptionSecret decrypt(@NotNull DecryptionSecret decryptionSecret) {
        Intrinsics.checkNotNullParameter((Object)decryptionSecret, (String)"decryptionSecret");
        byte[] iv = Base64.decode((String)decryptionSecret.getIv(), (int)1);
        byte[] ct = Base64.decode((String)decryptionSecret.getData(), (int)1);
        KeyStore ks = KeyStore.getInstance(PROVIDER);
        ks.load((KeyStore.LoadStoreParameter)((Object)NULL));
        KeyStore.Entry entry = ks.getEntry(decryptionSecret.getAlias(), (KeyStore.ProtectionParameter)((Object)NULL));
        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
        KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)entry;
        Cipher c = Cipher.getInstance(TRANSFORMATION);
        AlgorithmParameterSpec gps = new GCMParameterSpec(128, iv);
        c.init(2, (Key)ske.getSecretKey(), gps);
        byte[] byArray = c.doFinal(ct);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        byte[] byArray2 = byArray;
        String decryptedBytes = new String(byArray2, Charsets.UTF_8);
        return new EncryptionSecret(decryptionSecret.getAlias(), decryptedBytes);
    }

    public final void generateKeyPair(@NotNull String alias, @NotNull String digests) {
        KeyGenParameterSpec.Builder builder;
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)digests, (String)"digests");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", PROVIDER);
        KeyGenParameterSpec.Builder $this$generateKeyPair_u24lambda_u240 = builder = new KeyGenParameterSpec.Builder(alias, 12);
        boolean bl = false;
        String[] stringArray = new String[]{digests};
        $this$generateKeyPair_u24lambda_u240.setDigests(stringArray);
        KeyGenParameterSpec keyGenParameterSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
        KeyGenParameterSpec parameterSpec = keyGenParameterSpec;
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        keyPairGenerator.generateKeyPair();
    }

    public static /* synthetic */ void generateKeyPair$default(KeystoreHelper keystoreHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DEFAULT_DIGEST;
        }
        keystoreHelper.generateKeyPair(string, string2);
    }

    public final void deleteKeyPair(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        KeyStore keyStore = KeyStore.getInstance(PROVIDER);
        keyStore.load(null);
        keyStore.deleteEntry(alias);
        Object[] objectArray = new Object[]{"Deleted keypair " + alias};
        ZSMLogger.log$default(objectArray, null, null, 6, null);
    }

    public final void generateSigningKey(@NotNull String alias, @NotNull String digests) {
        KeyGenParameterSpec.Builder builder;
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)digests, (String)"digests");
        KeyStore $this$generateSigningKey_u24lambda_u241 = keyStore = KeyStore.getInstance(PROVIDER);
        boolean bl = false;
        $this$generateSigningKey_u24lambda_u241.load(null);
        KeyStore keyStore2 = keyStore;
        if (keyStore2.containsAlias(alias)) {
            return;
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", PROVIDER);
        KeyGenParameterSpec.Builder $this$generateSigningKey_u24lambda_u242 = builder = new KeyGenParameterSpec.Builder(alias, 12);
        boolean bl2 = false;
        String[] stringArray = new String[]{digests};
        $this$generateSigningKey_u24lambda_u242.setDigests(stringArray);
        KeyGenParameterSpec keyGenParameterSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
        KeyGenParameterSpec parameterSpec = keyGenParameterSpec;
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        keyPairGenerator.generateKeyPair();
    }

    public static /* synthetic */ void generateSigningKey$default(KeystoreHelper keystoreHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DEFAULT_DIGEST;
        }
        keystoreHelper.generateSigningKey(string, string2);
    }

    @Nullable
    public final byte[] signMessage(@NotNull String alias, @NotNull byte[] data, @NotNull String algorithm) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        KeyStore keyStore = KeyStore.getInstance(PROVIDER);
        keyStore.load(null);
        Key key = keyStore.getKey(alias, null);
        PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
        if (privateKey == null) {
            return null;
        }
        PrivateKey privateKey2 = privateKey;
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey2);
            signature.update(data);
            byArray = signature.sign();
        }
        catch (InvalidKeyException e) {
            Object[] objectArray = new Object[]{"Key [" + alias + "] is invalid. Deleting and regenerating. Reason: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            this.deleteKeyPair(alias);
            byArray = null;
        }
        return byArray;
    }

    public static /* synthetic */ byte[] signMessage$default(KeystoreHelper keystoreHelper, String string, byte[] byArray, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = DEFAULT_ALGORITHM;
        }
        return keystoreHelper.signMessage(string, byArray, string2);
    }

    public final boolean verifySignature(@NotNull String alias, @NotNull byte[] data, @NotNull byte[] signatureBytes, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signatureBytes, (String)"signatureBytes");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        PublicKey publicKey = this.getPublicKey(alias);
        if (publicKey == null) {
            return false;
        }
        PublicKey publicKey2 = publicKey;
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(publicKey2);
        signature.update(data);
        return signature.verify(signatureBytes);
    }

    public static /* synthetic */ boolean verifySignature$default(KeystoreHelper keystoreHelper, String string, byte[] byArray, byte[] byArray2, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = DEFAULT_ALGORITHM;
        }
        return keystoreHelper.verifySignature(string, byArray, byArray2, string2);
    }

    @Nullable
    public final PublicKey getPublicKey(@NotNull String alias) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        try {
            KeyStore keyStore;
            KeyStore $this$getPublicKey_u24lambda_u243 = keyStore = KeyStore.getInstance(PROVIDER);
            boolean bl = false;
            $this$getPublicKey_u24lambda_u243.load(null);
            KeyStore keyStore2 = keyStore;
            Serializable serializable2 = keyStore2.getCertificate(alias);
            if (serializable2 == null || (serializable2 = serializable2.getPublicKey()) == null) {
                KeystoreHelper $this$getPublicKey_u24lambda_u244 = this;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{"Public key for alias " + alias + " not found."};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                serializable2 = null;
            }
            serializable = serializable2;
        }
        catch (Exception e) {
            Object v3;
            Object[] objectArray;
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"code 7", (boolean)false, (int)2, null) : false;
            if (bl) {
                objectArray = new Object[]{"KeyStore entry missing for alias " + alias + ". Returning null."};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                v3 = null;
            } else {
                objectArray = new Object[]{"Unexpected KeyStore error: " + e.getMessage()};
                ZSMLogger.log$default(objectArray, null, null, 6, null);
                v3 = null;
            }
            serializable = v3;
        }
        return serializable;
    }
}

