/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.useideem.zsm.core.ZSMLogger;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/useideem/zsm/utils/KeystoreSecretStorage;", "", "context", "Landroid/content/Context;", "forTesting", "", "<init>", "(Landroid/content/Context;Z)V", "getContext", "()Landroid/content/Context;", "securePrefs", "Landroid/content/SharedPreferences;", "getSecurePrefs", "()Landroid/content/SharedPreferences;", "storeKey", "alias", "", "keyData", "", "retrieveKey", "deleteKey", "keyExists", "containsKey", "Companion", "zsm_release"})
public class KeystoreSecretStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final boolean forTesting;
    @NotNull
    private final SharedPreferences securePrefs;
    @NotNull
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    @NotNull
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    @NotNull
    private static final String MASTER_KEY_ALIAS = "ZSM_MASTER_KEY";
    private static final int TAG_LENGTH_BITS = 128;

    @JvmOverloads
    public KeystoreSecretStorage(@NotNull Context context, boolean forTesting) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.forTesting = forTesting;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("ZSM_SECURE_STORAGE", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.securePrefs = sharedPreferences;
    }

    public /* synthetic */ KeystoreSecretStorage(Context context, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl);
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final SharedPreferences getSecurePrefs() {
        return this.securePrefs;
    }

    public boolean storeKey(@NotNull String alias, @NotNull byte[] keyData) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
        try {
            SecretKey masterKey = KeystoreSecretStorage.getMasterKey();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, masterKey);
            byte[] iv = cipher.getIV();
            byte[] encryptedData = cipher.doFinal(keyData);
            byte[] combinedData = ByteBuffer.allocate(iv.length + encryptedData.length + 4).putInt(iv.length).put(iv).put(encryptedData).array();
            String encodedData = Base64.encodeToString((byte[])combinedData, (int)2);
            this.securePrefs.edit().putString(alias, encodedData).apply();
            return true;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Error storing key: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return false;
        }
    }

    @Nullable
    public byte[] retrieveKey(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        try {
            String string = this.securePrefs.getString(alias, null);
            if (string == null) {
                return null;
            }
            String encodedData = string;
            byte[] combinedData = Base64.decode((String)encodedData, (int)2);
            ByteBuffer buffer = ByteBuffer.wrap(combinedData);
            int ivSize = buffer.getInt();
            byte[] iv = new byte[ivSize];
            buffer.get(iv);
            byte[] encryptedData = new byte[buffer.remaining()];
            buffer.get(encryptedData);
            SecretKey masterKey = KeystoreSecretStorage.getMasterKey();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)masterKey, new GCMParameterSpec(128, iv));
            return cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Error retrieving key: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return null;
        }
    }

    public boolean deleteKey(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        try {
            this.securePrefs.edit().remove(alias).apply();
            return true;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"Error deleting key: " + e.getMessage()};
            ZSMLogger.log$default(objectArray, null, null, 6, null);
            return false;
        }
    }

    public boolean keyExists(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return this.securePrefs.contains(alias);
    }

    @Deprecated(message="Use keyExists instead", replaceWith=@ReplaceWith(expression="keyExists(alias)", imports={}))
    public boolean containsKey(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return this.keyExists(alias);
    }

    @JvmOverloads
    public KeystoreSecretStorage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, false, 2, null);
    }

    @JvmStatic
    @NotNull
    protected static final SecretKey getMasterKey() {
        return Companion.getMasterKey();
    }

    @JvmStatic
    @NotNull
    public static final KeystoreSecretStorage create(@NotNull Context context) {
        return Companion.create(context);
    }

    @JvmStatic
    public static final boolean isTestEnvironment() {
        return Companion.isTestEnvironment();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/useideem/zsm/utils/KeystoreSecretStorage$Companion;", "", "<init>", "()V", "ANDROID_KEYSTORE", "", "TRANSFORMATION", "MASTER_KEY_ALIAS", "TAG_LENGTH_BITS", "", "getMasterKey", "Ljavax/crypto/SecretKey;", "create", "Lcom/useideem/zsm/utils/KeystoreSecretStorage;", "context", "Landroid/content/Context;", "isTestEnvironment", "", "zsm_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final SecretKey getMasterKey() {
            KeyStore keyStore;
            KeyStore $this$getMasterKey_u24lambda_u240 = keyStore = KeyStore.getInstance(KeystoreSecretStorage.ANDROID_KEYSTORE);
            boolean bl = false;
            $this$getMasterKey_u24lambda_u240.load(null);
            KeyStore keyStore2 = keyStore;
            if (!keyStore2.containsAlias(KeystoreSecretStorage.MASTER_KEY_ALIAS)) {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", KeystoreSecretStorage.ANDROID_KEYSTORE);
                String[] stringArray = new String[]{"GCM"};
                KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(KeystoreSecretStorage.MASTER_KEY_ALIAS, 3).setBlockModes(stringArray);
                stringArray = new String[]{"NoPadding"};
                KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).setKeySize(256).build();
                Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
                KeyGenParameterSpec keyGenSpec = keyGenParameterSpec;
                keyGenerator.init((AlgorithmParameterSpec)keyGenSpec);
                keyGenerator.generateKey();
            }
            KeyStore.Entry entry = keyStore2.getEntry(KeystoreSecretStorage.MASTER_KEY_ALIAS, null);
            Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"getSecretKey(...)");
            return secretKey;
        }

        @JvmStatic
        @NotNull
        public final KeystoreSecretStorage create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new KeystoreSecretStorage(context, false, 2, null);
        }

        @JvmStatic
        public final boolean isTestEnvironment() {
            return Intrinsics.areEqual((Object)System.getProperty("zsm.testing.mode"), (Object)"true") || Intrinsics.areEqual((Object)System.getProperty("robolectric.offline"), (Object)"true");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

