/*
 * Decompiled with CFR 0.152.
 */
package com.useideem.zsm.utils;

import android.app.Application;
import android.content.SharedPreferences;
import com.useideem.zsm.utils.DecryptionSecret;
import com.useideem.zsm.utils.EncryptionSecret;
import com.useideem.zsm.utils.KeystoreHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/useideem/zsm/utils/KeystoreTransaction;", "", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "SP_NAME", "", "TOC", "", "TOC_KEY", "sp", "Landroid/content/SharedPreferences;", "getSp", "()Landroid/content/SharedPreferences;", "sp$delegate", "Lkotlin/Lazy;", "flush", "", "get", "alias", "contains", "key", "save", "Lcom/useideem/zsm/utils/DecryptionSecret;", "value", "failIfExists", "remove", "overwrite", "update", "zsm_release"})
public final class KeystoreTransaction {
    @NotNull
    private Application application;
    @NotNull
    private final String SP_NAME;
    @NotNull
    private Set<String> TOC;
    @NotNull
    private final String TOC_KEY;
    @NotNull
    private final Lazy sp$delegate;

    public KeystoreTransaction(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
        this.SP_NAME = "__encrypted_data";
        this.TOC = new LinkedHashSet();
        this.TOC_KEY = "KEYSTORE_INDEX";
        this.sp$delegate = LazyKt.lazy(() -> KeystoreTransaction.sp_delegate$lambda$0(this));
    }

    private final SharedPreferences getSp() {
        Lazy lazy = this.sp$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (SharedPreferences)object;
    }

    public final boolean flush() {
        try {
            while (!((Collection)this.TOC).isEmpty()) {
                String key = (String)CollectionsKt.elementAt((Iterable)this.TOC, (int)0);
                this.TOC.remove(key);
                this.remove(key);
            }
            CollectionsKt.removeAll((Iterable)this.TOC, KeystoreTransaction::flush$lambda$1);
            this.remove(this.TOC_KEY);
            return true;
        }
        catch (StackOverflowError err) {
            throw new StackOverflowError("Invalid Store Index addressed while emptying keystore! Details:\n" + err);
        }
    }

    @Nullable
    public final String get(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        String string = this.getSp().getString(alias, null);
        if (string == null) {
            return null;
        }
        String json = string;
        JSONObject obj = new JSONObject(json);
        String string2 = obj.getString("alias");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = string2;
        String string4 = obj.getString("iv");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        String string5 = string4;
        String string6 = obj.getString("data");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
        String string7 = string6;
        DecryptionSecret decryptionSecret = new DecryptionSecret(string3, string7, string5);
        try {
            string3 = KeystoreHelper.INSTANCE.decrypt(decryptionSecret).getData();
        }
        catch (Exception err) {
            this.flush();
            string3 = null;
        }
        return string3;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.get(key) != null;
    }

    @NotNull
    public final DecryptionSecret save(@NotNull String key, @NotNull String value, boolean failIfExists) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (failIfExists && this.getSp().contains(key)) {
            throw new IllegalAccessException("The KeyStore alias '" + key + "' already exists, and therefore cannot be saved to!");
        }
        if (CollectionsKt.indexOf((Iterable)this.TOC, (Object)key) == -1) {
            this.TOC.add(key);
            if (!Intrinsics.areEqual((Object)key, (Object)this.TOC_KEY)) {
                this.overwrite(this.TOC_KEY, CollectionsKt.joinToString$default((Iterable)this.TOC, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        EncryptionSecret input = new EncryptionSecret(key, value);
        DecryptionSecret encrypted = KeystoreHelper.INSTANCE.encrypt(input);
        JSONObject $this$save_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$save_u24lambda_u242.put("alias", (Object)encrypted.getAlias());
        $this$save_u24lambda_u242.put("data", (Object)encrypted.getData());
        $this$save_u24lambda_u242.put("iv", (Object)encrypted.getIv());
        JSONObject json = jSONObject;
        this.getSp().edit().putString(key, json.toString()).apply();
        return encrypted;
    }

    public static /* synthetic */ DecryptionSecret save$default(KeystoreTransaction keystoreTransaction, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return keystoreTransaction.save(string, string2, bl);
    }

    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getSp().edit().remove(key).apply();
        int keyPos = CollectionsKt.indexOf((Iterable)this.TOC, (Object)key);
        if (keyPos != -1) {
            this.TOC.remove(key);
            if (!Intrinsics.areEqual((Object)key, (Object)this.TOC_KEY)) {
                this.overwrite(this.TOC_KEY, CollectionsKt.joinToString$default((Iterable)this.TOC, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public final String overwrite(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.save(key, value, false);
        return this.get(key);
    }

    @Nullable
    public final String update(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.get(key), (Object)value)) {
            this.overwrite(key, value);
        }
        return this.get(key);
    }

    private static final SharedPreferences sp_delegate$lambda$0(KeystoreTransaction this$0) {
        return this$0.application.getSharedPreferences(this$0.SP_NAME, 0);
    }

    private static final boolean flush$lambda$1(String p) {
        return p != null && !StringsKt.isBlank((CharSequence)p);
    }
}

