/*
 * Decompiled with CFR 0.152.
 */
package com.vydia.RNUploader;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.vydia.RNUploader.NotificationActions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/vydia/RNUploader/NotificationActionsReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "TAG", "", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "onUserRequestedUploadCancellation", "uploadId", "sendEvent", "eventName", "params", "Lcom/facebook/react/bridge/WritableMap;", "react-native-background-upload_debug"})
public final class NotificationActionsReceiver
extends BroadcastReceiver {
    @NotNull
    private final String TAG;
    @Nullable
    private final ReactApplicationContext reactContext;

    public NotificationActionsReceiver() {
        this.TAG = "NotificationActReceiver";
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        if (intent == null || Intrinsics.areEqual((Object)new NotificationActions().getINTENT_ACTION(), (Object)intent.getAction())) {
            return;
        }
        if (Intrinsics.areEqual((Object)new NotificationActions().getACTION_CANCEL_UPLOAD(), (Object)intent.getStringExtra(new NotificationActions().getPARAM_ACTION()))) {
            Context context2 = context;
            Intrinsics.checkNotNull((Object)context2);
            String string = intent.getStringExtra(new NotificationActions().getPARAM_UPLOAD_ID());
            Intrinsics.checkNotNull((Object)string);
            this.onUserRequestedUploadCancellation(context2, string);
        }
    }

    private final void onUserRequestedUploadCancellation(Context context, String uploadId) {
        Log.e((String)"CANCEL_UPLOAD", (String)("User requested cancellation of upload with ID: " + uploadId));
        UploadService.Companion.stopUpload(uploadId);
        WritableMap params = Arguments.createMap();
        params.putString("id", uploadId);
        this.sendEvent("cancelled", params, context);
    }

    private final void sendEvent(String eventName, WritableMap params, Context context) {
        ReactApplicationContext reactApplicationContext = this.reactContext;
        if (reactApplicationContext != null && (reactApplicationContext = (DeviceEventManagerModule.RCTDeviceEventEmitter)reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)) != null) {
            reactApplicationContext.emit("RNFileUploader-" + eventName, (Object)params);
        } else {
            Log.e((String)this.TAG, (String)"sendEvent() failed due reactContext == null!");
        }
    }
}

