/*
 * Decompiled with CFR 0.152.
 */
package com.vydia.RNUploader;

import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.facebook.react.BuildConfig;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.vydia.RNUploader.GlobalRequestObserverDelegate;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.HttpUploadRequest;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadNotificationStatusConfig;
import net.gotev.uploadservice.network.HttpStack;
import net.gotev.uploadservice.observer.request.GlobalRequestObserver;
import net.gotev.uploadservice.observer.request.RequestObserverDelegate;
import net.gotev.uploadservice.okhttp.OkHttpStack;
import net.gotev.uploadservice.protocols.binary.BinaryUploadRequest;
import net.gotev.uploadservice.protocols.multipart.MultipartUploadRequest;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u001a\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/vydia/RNUploader/UploaderModule;", "Lcom/facebook/react/bridge/ReactContextBaseJavaModule;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "TAG", "", "isGlobalRequestObserver", "", "notificationChannelID", "getReactContext", "()Lcom/facebook/react/bridge/ReactApplicationContext;", "cancelUpload", "", "cancelUploadId", "promise", "Lcom/facebook/react/bridge/Promise;", "configureUploadServiceHTTPStack", "options", "Lcom/facebook/react/bridge/ReadableMap;", "createNotificationChannel", "getFileInfo", "path", "getName", "onHostDestroy", "onHostPause", "onHostResume", "startUpload", "stopAllUploads", "react-native-background-upload_debug"})
public final class UploaderModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    @NotNull
    private final ReactApplicationContext reactContext;
    @NotNull
    private final String TAG;
    @NotNull
    private String notificationChannelID;
    private boolean isGlobalRequestObserver;

    public UploaderModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        super(reactContext);
        this.reactContext = reactContext;
        this.TAG = "UploaderBridge";
        this.notificationChannelID = "BackgroundUploadChannel";
    }

    @NotNull
    public final ReactApplicationContext getReactContext() {
        return this.reactContext;
    }

    @NotNull
    public String getName() {
        return "RNFileUploader";
    }

    @ReactMethod
    public final void getFileInfo(@Nullable String path, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            WritableMap params = Arguments.createMap();
            File fileInfo = new File(path);
            params.putString("name", fileInfo.getName());
            if (!fileInfo.exists() || !fileInfo.isFile()) {
                params.putBoolean("exists", false);
            } else {
                params.putBoolean("exists", true);
                params.putString("size", String.valueOf(fileInfo.length()));
                String extension = MimeTypeMap.getFileExtensionFromUrl((String)path);
                params.putString("extension", extension);
                MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"extension");
                String string = extension.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                String mimeType = mimeTypeMap.getMimeTypeFromExtension(string);
                params.putString("mimeType", mimeType);
            }
            promise.resolve((Object)params);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
            promise.reject((Throwable)exc);
        }
    }

    private final void configureUploadServiceHTTPStack(ReadableMap options, Promise promise) {
        boolean followRedirects = true;
        boolean followSslRedirects = true;
        boolean retryOnConnectionFailure = true;
        int connectTimeout = 15;
        int writeTimeout = 30;
        int readTimeout = 30;
        if (options.hasKey("followRedirects")) {
            if (options.getType("followRedirects") != ReadableType.Boolean) {
                promise.reject((Throwable)new IllegalArgumentException("followRedirects must be a boolean."));
                return;
            }
            followRedirects = options.getBoolean("followRedirects");
        }
        if (options.hasKey("followSslRedirects")) {
            if (options.getType("followSslRedirects") != ReadableType.Boolean) {
                promise.reject((Throwable)new IllegalArgumentException("followSslRedirects must be a boolean."));
                return;
            }
            followSslRedirects = options.getBoolean("followSslRedirects");
        }
        if (options.hasKey("retryOnConnectionFailure")) {
            if (options.getType("retryOnConnectionFailure") != ReadableType.Boolean) {
                promise.reject((Throwable)new IllegalArgumentException("retryOnConnectionFailure must be a boolean."));
                return;
            }
            retryOnConnectionFailure = options.getBoolean("retryOnConnectionFailure");
        }
        if (options.hasKey("connectTimeout")) {
            if (options.getType("connectTimeout") != ReadableType.Number) {
                promise.reject((Throwable)new IllegalArgumentException("connectTimeout must be a number."));
                return;
            }
            connectTimeout = options.getInt("connectTimeout");
        }
        if (options.hasKey("writeTimeout")) {
            if (options.getType("writeTimeout") != ReadableType.Number) {
                promise.reject((Throwable)new IllegalArgumentException("writeTimeout must be a number."));
                return;
            }
            writeTimeout = options.getInt("writeTimeout");
        }
        if (options.hasKey("readTimeout")) {
            if (options.getType("readTimeout") != ReadableType.Number) {
                promise.reject((Throwable)new IllegalArgumentException("readTimeout must be a number."));
                return;
            }
            readTimeout = options.getInt("readTimeout");
        }
        UploadServiceConfig.setHttpStack((HttpStack)((HttpStack)new OkHttpStack(new OkHttpClient().newBuilder().followRedirects(followRedirects).followSslRedirects(followSslRedirects).retryOnConnectionFailure(retryOnConnectionFailure).connectTimeout((long)connectTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).cache(null).build())));
    }

    @ReactMethod
    public final void startUpload(@NotNull ReadableMap options, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        String[] stringArray = new String[]{"url", "path"};
        for (String key : stringArray) {
            if (!options.hasKey(key)) {
                promise.reject((Throwable)new IllegalArgumentException("Missing '" + key + "' field."));
                return;
            }
            if (options.getType(key) == ReadableType.String) continue;
            promise.reject((Throwable)new IllegalArgumentException(key + " must be a string."));
            return;
        }
        if (options.hasKey("headers") && options.getType("headers") != ReadableType.Map) {
            promise.reject((Throwable)new IllegalArgumentException("headers must be a hash."));
            return;
        }
        if (options.hasKey("notification") && options.getType("notification") != ReadableType.Map) {
            promise.reject((Throwable)new IllegalArgumentException("notification must be a hash."));
            return;
        }
        this.configureUploadServiceHTTPStack(options, promise);
        String requestType = "raw";
        if (options.hasKey("type")) {
            requestType = options.getString("type");
            if (requestType == null) {
                promise.reject((Throwable)new IllegalArgumentException("type must be string."));
                return;
            }
            if (!Intrinsics.areEqual((Object)requestType, (Object)"raw") && !Intrinsics.areEqual((Object)requestType, (Object)"multipart")) {
                promise.reject((Throwable)new IllegalArgumentException("type should be string: raw or multipart."));
                return;
            }
        }
        WritableMap notification = (WritableMap)new WritableNativeMap();
        notification.putBoolean("enabled", true);
        if (options.hasKey("notification")) {
            ReadableMap readableMap = options.getMap("notification");
            Intrinsics.checkNotNull((Object)readableMap);
            notification.merge(readableMap);
        }
        Context context = this.reactContext.getApplicationContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Application");
        Application application = (Application)context;
        this.reactContext.addLifecycleEventListener((LifecycleEventListener)this);
        if (notification.hasKey("notificationChannel")) {
            String string = notification.getString("notificationChannel");
            Intrinsics.checkNotNull((Object)string);
            this.notificationChannelID = string;
        }
        this.createNotificationChannel();
        UploadServiceConfig.initialize((Application)application, (String)this.notificationChannelID, (boolean)BuildConfig.DEBUG);
        if (!this.isGlobalRequestObserver) {
            this.isGlobalRequestObserver = true;
            new GlobalRequestObserver(application, (RequestObserverDelegate)new GlobalRequestObserverDelegate(this.reactContext), null, 4, null);
        }
        String url = options.getString("url");
        String filePath = options.getString("path");
        String method = options.hasKey("method") && options.getType("method") == ReadableType.String ? options.getString("method") : "POST";
        int maxRetries = options.hasKey("maxRetries") && options.getType("maxRetries") == ReadableType.Number ? options.getInt("maxRetries") : 2;
        String customUploadId = options.hasKey("customUploadId") && options.getType("method") == ReadableType.String ? options.getString("customUploadId") : null;
        try {
            String key;
            ReadableMapKeySetIterator keys;
            HttpUploadRequest httpUploadRequest;
            if (Intrinsics.areEqual((Object)requestType, (Object)"raw")) {
                ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)reactApplicationContext, (String)"this.reactApplicationContext");
                Context context2 = (Context)reactApplicationContext;
                String string = url;
                Intrinsics.checkNotNull((Object)string);
                BinaryUploadRequest binaryUploadRequest = new BinaryUploadRequest(context2, string);
                String string2 = filePath;
                Intrinsics.checkNotNull((Object)string2);
                httpUploadRequest = (HttpUploadRequest)binaryUploadRequest.setFileToUpload(string2);
            } else {
                if (!options.hasKey("field")) {
                    promise.reject((Throwable)new IllegalArgumentException("field is required field for multipart type."));
                    return;
                }
                if (options.getType("field") != ReadableType.String) {
                    promise.reject((Throwable)new IllegalArgumentException("field must be string."));
                    return;
                }
                ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)reactApplicationContext, (String)"this.reactApplicationContext");
                Context context3 = (Context)reactApplicationContext;
                String string = url;
                Intrinsics.checkNotNull((Object)string);
                MultipartUploadRequest multipartUploadRequest = new MultipartUploadRequest(context3, string);
                String string3 = filePath;
                Intrinsics.checkNotNull((Object)string3);
                String string4 = options.getString("field");
                Intrinsics.checkNotNull((Object)string4);
                httpUploadRequest = (HttpUploadRequest)MultipartUploadRequest.addFileToUpload$default((MultipartUploadRequest)multipartUploadRequest, (String)string3, (String)string4, null, null, (int)12, null);
            }
            HttpUploadRequest request = httpUploadRequest;
            String string = method;
            Intrinsics.checkNotNull((Object)string);
            request.setMethod(string).setMaxRetries(maxRetries);
            if (notification.getBoolean("enabled")) {
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                String string12;
                boolean bl = notification.hasKey("enableRingTone") && notification.getBoolean("enableRingTone");
                if (notification.hasKey("onProgressTitle")) {
                    String string13 = notification.getString("onProgressTitle");
                    string12 = string13;
                    Intrinsics.checkNotNull((Object)string13);
                } else {
                    string12 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"if (notification.hasKey(\u2026ProgressTitle\")!! else \"\"");
                if (notification.hasKey("onProgressMessage")) {
                    String string14 = notification.getString("onProgressMessage");
                    string11 = string14;
                    Intrinsics.checkNotNull((Object)string14);
                } else {
                    string11 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"if (notification.hasKey(\u2026ogressMessage\")!! else \"\"");
                UploadNotificationStatusConfig uploadNotificationStatusConfig = new UploadNotificationStatusConfig(string12, string11, 0, 0, null, null, null, false, false, null, 1020, null);
                if (notification.hasKey("onCompleteTitle")) {
                    String string15 = notification.getString("onCompleteTitle");
                    string10 = string15;
                    Intrinsics.checkNotNull((Object)string15);
                } else {
                    string10 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"if (notification.hasKey(\u2026CompleteTitle\")!! else \"\"");
                if (notification.hasKey("onCompleteMessage")) {
                    String string16 = notification.getString("onCompleteMessage");
                    string9 = string16;
                    Intrinsics.checkNotNull((Object)string16);
                } else {
                    string9 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"if (notification.hasKey(\u2026mpleteMessage\")!! else \"\"");
                UploadNotificationStatusConfig uploadNotificationStatusConfig2 = new UploadNotificationStatusConfig(string10, string9, 0, 0, null, null, null, false, notification.hasKey("autoClear") && notification.getBoolean("autoClear"), null, 764, null);
                if (notification.hasKey("onErrorTitle")) {
                    String string17 = notification.getString("onErrorTitle");
                    string8 = string17;
                    Intrinsics.checkNotNull((Object)string17);
                } else {
                    string8 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"if (notification.hasKey(\u2026\"onErrorTitle\")!! else \"\"");
                if (notification.hasKey("onErrorMessage")) {
                    String string18 = notification.getString("onErrorMessage");
                    string7 = string18;
                    Intrinsics.checkNotNull((Object)string18);
                } else {
                    string7 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"if (notification.hasKey(\u2026nErrorMessage\")!! else \"\"");
                UploadNotificationStatusConfig uploadNotificationStatusConfig3 = new UploadNotificationStatusConfig(string8, string7, 0, 0, null, null, null, false, false, null, 1020, null);
                if (notification.hasKey("onCancelledTitle")) {
                    String string19 = notification.getString("onCancelledTitle");
                    string6 = string19;
                    Intrinsics.checkNotNull((Object)string19);
                } else {
                    string6 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"if (notification.hasKey(\u2026ancelledTitle\")!! else \"\"");
                if (notification.hasKey("onCancelledMessage")) {
                    String string20 = notification.getString("onCancelledMessage");
                    string5 = string20;
                    Intrinsics.checkNotNull((Object)string20);
                } else {
                    string5 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"if (notification.hasKey(\u2026celledMessage\")!! else \"\"");
                UploadNotificationConfig notificationConfig = new UploadNotificationConfig(this.notificationChannelID, bl, uploadNotificationStatusConfig, uploadNotificationStatusConfig2, uploadNotificationStatusConfig3, new UploadNotificationStatusConfig(string6, string5, 0, 0, null, null, null, false, false, null, 1020, null));
                request.setNotificationConfig((Function2)new Function2<Context, String, UploadNotificationConfig>(notificationConfig){
                    final /* synthetic */ UploadNotificationConfig $notificationConfig;
                    {
                        this.$notificationConfig = $notificationConfig;
                        super(2);
                    }

                    @NotNull
                    public final UploadNotificationConfig invoke(@NotNull Context context, @NotNull String string) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
                        return this.$notificationConfig;
                    }
                });
            }
            if (options.hasKey("parameters")) {
                ReadableMap parameters;
                if (Intrinsics.areEqual((Object)requestType, (Object)"raw")) {
                    promise.reject((Throwable)new IllegalArgumentException("Parameters supported only in multipart type"));
                    return;
                }
                ReadableMap readableMap = parameters = options.getMap("parameters");
                Intrinsics.checkNotNull((Object)readableMap);
                ReadableMapKeySetIterator readableMapKeySetIterator = readableMap.keySetIterator();
                Intrinsics.checkNotNullExpressionValue((Object)readableMapKeySetIterator, (String)"parameters!!.keySetIterator()");
                keys = readableMapKeySetIterator;
                while (keys.hasNextKey()) {
                    key = keys.nextKey();
                    if (parameters.getType(key) != ReadableType.String) {
                        promise.reject((Throwable)new IllegalArgumentException("Parameters must be string key/values. Value was invalid for '" + key + '\''));
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    String string21 = parameters.getString(key);
                    Intrinsics.checkNotNull((Object)string21);
                    request.addParameter(key, string21);
                }
            }
            if (options.hasKey("headers")) {
                ReadableMap headers;
                ReadableMap readableMap = headers = options.getMap("headers");
                Intrinsics.checkNotNull((Object)readableMap);
                ReadableMapKeySetIterator readableMapKeySetIterator = readableMap.keySetIterator();
                Intrinsics.checkNotNullExpressionValue((Object)readableMapKeySetIterator, (String)"headers!!.keySetIterator()");
                keys = readableMapKeySetIterator;
                while (keys.hasNextKey()) {
                    key = keys.nextKey();
                    if (headers.getType(key) != ReadableType.String) {
                        promise.reject((Throwable)new IllegalArgumentException("Headers must be string key/values.  Value was invalid for '" + key + '\''));
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    String string22 = headers.getString(key);
                    Intrinsics.checkNotNull((Object)string22);
                    request.addHeader(key, string22);
                }
            }
            if (customUploadId != null) {
                request.setUploadID(customUploadId);
            }
            String uploadId = request.startUpload();
            promise.resolve((Object)uploadId);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
            promise.reject((Throwable)exc);
        }
    }

    @ReactMethod
    public final void cancelUpload(@Nullable String cancelUploadId, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (cancelUploadId == null) {
            promise.reject((Throwable)new IllegalArgumentException("Upload ID must be a string"));
            return;
        }
        try {
            UploadService.Companion.stopUpload(cancelUploadId);
            promise.resolve((Object)true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
            promise.reject((Throwable)exc);
        }
    }

    @ReactMethod
    public final void stopAllUploads(@NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            UploadService.Companion.stopAllUploads();
            promise.resolve((Object)true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
            promise.reject((Throwable)exc);
        }
    }

    private final void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(this.notificationChannelID, (CharSequence)"Background Upload Channel", 2);
            Object object = this.getReactApplicationContext().getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager manager = (NotificationManager)object;
            manager.createNotificationChannel(channel);
        }
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
    }
}

