/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.Maps;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldValueInfo;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class ChainedInstrumentation
implements Instrumentation {
    protected final ImmutableList<Instrumentation> instrumentations;

    public ChainedInstrumentation(List<Instrumentation> instrumentations) {
        this.instrumentations = ImmutableList.copyOf((Collection)Assert.assertNotNull(instrumentations));
    }

    public ChainedInstrumentation(Instrumentation ... instrumentations) {
        this(Arrays.asList(instrumentations));
    }

    public List<Instrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    protected InstrumentationState getSpecificState(Instrumentation instrumentation, InstrumentationState parametersInstrumentationState) {
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)parametersInstrumentationState;
        return chainedInstrumentationState.getState(instrumentation);
    }

    private <T> InstrumentationContext<T> chainedCtx(Function<Instrumentation, InstrumentationContext<T>> mapper) {
        if (this.instrumentations.isEmpty()) {
            return SimpleInstrumentationContext.noOp();
        }
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0));
        }
        return new ChainedInstrumentationContext<T>(ImmutableKit.mapAndDropNulls(this.instrumentations, mapper));
    }

    @Override
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new ChainedInstrumentationState(this.instrumentations, parameters);
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginExecution was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginExecution(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginParse was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginParse(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginValidation was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginValidation(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginExecuteOperation was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginExecuteOperation(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        return (ExecutionStrategyInstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginExecutionStrategy was called", new Object[0]);
    }

    @Override
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return ExecutionStrategyInstrumentationContext.NOOP;
        }
        Function<Instrumentation, ExecutionStrategyInstrumentationContext> mapper = instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginExecutionStrategy(parameters, specificState);
        };
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0));
        }
        return new ChainedExecutionStrategyInstrumentationContext(ImmutableKit.mapAndDropNulls(this.instrumentations, mapper));
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginSubscribedFieldEvent(InstrumentationFieldParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginSubscribedFieldEvent was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginSubscribedFieldEvent(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginSubscribedFieldEvent(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginField(InstrumentationFieldParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginField was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginField(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginField(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginFieldFetch was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginFieldFetch(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginFieldComplete(InstrumentationFieldCompleteParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginFieldComplete was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginFieldComplete(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginFieldComplete(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public InstrumentationContext<ExecutionResult> beginFieldListComplete(InstrumentationFieldCompleteParameters parameters) {
        return (InstrumentationContext)Assert.assertShouldNeverHappen("The deprecated beginFieldListComplete was called", new Object[0]);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginFieldListComplete(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return this.chainedCtx(instrumentation -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            return instrumentation.beginFieldListComplete(parameters, specificState);
        });
    }

    @Override
    @NotNull
    public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters) {
        return (ExecutionInput)Assert.assertShouldNeverHappen("The deprecated instrumentExecutionInput was called", new Object[0]);
    }

    @Override
    @NotNull
    public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return executionInput;
        }
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState specificState = this.getSpecificState(instrumentation, state);
            executionInput = instrumentation.instrumentExecutionInput(executionInput, parameters, specificState);
        }
        return executionInput;
    }

    @Override
    @NotNull
    public DocumentAndVariables instrumentDocumentAndVariables(DocumentAndVariables documentAndVariables, InstrumentationExecutionParameters parameters) {
        return (DocumentAndVariables)Assert.assertShouldNeverHappen("The deprecated instrumentDocumentAndVariables was called", new Object[0]);
    }

    @Override
    @NotNull
    public DocumentAndVariables instrumentDocumentAndVariables(DocumentAndVariables documentAndVariables, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return documentAndVariables;
        }
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState specificState = this.getSpecificState(instrumentation, state);
            documentAndVariables = instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters, specificState);
        }
        return documentAndVariables;
    }

    @Override
    @NotNull
    public GraphQLSchema instrumentSchema(GraphQLSchema schema, InstrumentationExecutionParameters parameters) {
        return (GraphQLSchema)Assert.assertShouldNeverHappen("The deprecated instrumentSchema was called", new Object[0]);
    }

    @Override
    @NotNull
    public GraphQLSchema instrumentSchema(GraphQLSchema schema, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return schema;
        }
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState specificState = this.getSpecificState(instrumentation, state);
            schema = instrumentation.instrumentSchema(schema, parameters, specificState);
        }
        return schema;
    }

    @Override
    @NotNull
    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters) {
        return (ExecutionContext)Assert.assertShouldNeverHappen("The deprecated instrumentExecutionContext was called", new Object[0]);
    }

    @Override
    @NotNull
    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return executionContext;
        }
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState specificState = this.getSpecificState(instrumentation, state);
            executionContext = instrumentation.instrumentExecutionContext(executionContext, parameters, specificState);
        }
        return executionContext;
    }

    @Override
    @NotNull
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        return (DataFetcher)Assert.assertShouldNeverHappen("The deprecated instrumentDataFetcher was called", new Object[0]);
    }

    @Override
    @NotNull
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return dataFetcher;
        }
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState specificState = this.getSpecificState(instrumentation, state);
            dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, parameters, specificState);
        }
        return dataFetcher;
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        return (CompletableFuture)Assert.assertShouldNeverHappen("The deprecated instrumentExecutionResult was called", new Object[0]);
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        CompletableFuture resultsFuture = Async.eachSequentially(this.instrumentations, (instrumentation, index, prevResults) -> {
            InstrumentationState specificState = this.getSpecificState((Instrumentation)instrumentation, state);
            ExecutionResult lastResult = prevResults.size() > 0 ? (ExecutionResult)prevResults.get(prevResults.size() - 1) : executionResult;
            return instrumentation.instrumentExecutionResult(lastResult, parameters, specificState);
        });
        return resultsFuture.thenApply(results -> results.isEmpty() ? executionResult : (ExecutionResult)results.get(results.size() - 1));
    }

    private static class ChainedExecutionStrategyInstrumentationContext
    implements ExecutionStrategyInstrumentationContext {
        private final ImmutableList<ExecutionStrategyInstrumentationContext> contexts;

        ChainedExecutionStrategyInstrumentationContext(ImmutableList<ExecutionStrategyInstrumentationContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched(CompletableFuture<ExecutionResult> result) {
            this.contexts.forEach(context -> context.onDispatched(result));
        }

        @Override
        public void onCompleted(ExecutionResult result, Throwable t2) {
            this.contexts.forEach(context -> context.onCompleted(result, t2));
        }

        @Override
        public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
            this.contexts.forEach(context -> context.onFieldValuesInfo(fieldValueInfoList));
        }

        @Override
        public void onFieldValuesException() {
            this.contexts.forEach(ExecutionStrategyInstrumentationContext::onFieldValuesException);
        }
    }

    private static class ChainedInstrumentationContext<T>
    implements InstrumentationContext<T> {
        private final ImmutableList<InstrumentationContext<T>> contexts;

        ChainedInstrumentationContext(ImmutableList<InstrumentationContext<T>> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched(CompletableFuture<T> result) {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)context -> context.onDispatched(result)));
        }

        @Override
        public void onCompleted(T result, Throwable t2) {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)context -> context.onCompleted(result, t2)));
        }
    }

    static class ChainedInstrumentationState
    implements InstrumentationState {
        private final Map<Instrumentation, InstrumentationState> instrumentationStates;

        private ChainedInstrumentationState(List<Instrumentation> instrumentations, InstrumentationCreateStateParameters parameters) {
            this.instrumentationStates = Maps.newLinkedHashMapWithExpectedSize(instrumentations.size());
            instrumentations.forEach(i -> this.instrumentationStates.put((Instrumentation)i, i.createState(parameters)));
        }

        private InstrumentationState getState(Instrumentation instrumentation) {
            return this.instrumentationStates.get(instrumentation);
        }
    }
}

