/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.tracing;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.execution.instrumentation.tracing.TracingSupport;
import graphql.language.Document;
import graphql.validation.ValidationError;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class TracingInstrumentation
extends SimplePerformantInstrumentation {
    private final Options options;

    public TracingInstrumentation() {
        this(Options.newOptions());
    }

    public TracingInstrumentation(Options options) {
        this.options = options;
    }

    @Override
    @Nullable
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new TracingSupport(this.options.includeTrivialDataFetchers);
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState rawState) {
        Map<Object, Object> currentExt = executionResult.getExtensions();
        TracingSupport tracingSupport = (TracingSupport)InstrumentationState.ofState(rawState);
        LinkedHashMap<Object, Object> withTracingExt = new LinkedHashMap<Object, Object>(currentExt == null ? ImmutableKit.emptyMap() : currentExt);
        withTracingExt.put("tracing", tracingSupport.snapshotTracingData());
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), withTracingExt));
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState rawState) {
        TracingSupport tracingSupport = (TracingSupport)InstrumentationState.ofState(rawState);
        TracingSupport.TracingContext ctx = tracingSupport.beginField(parameters.getEnvironment(), parameters.isTrivialDataFetcher());
        return SimpleInstrumentationContext.whenCompleted((result, t2) -> ctx.onEnd());
    }

    @Override
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState rawState) {
        TracingSupport tracingSupport = (TracingSupport)InstrumentationState.ofState(rawState);
        TracingSupport.TracingContext ctx = tracingSupport.beginParse();
        return SimpleInstrumentationContext.whenCompleted((result, t2) -> ctx.onEnd());
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState rawState) {
        TracingSupport tracingSupport = (TracingSupport)InstrumentationState.ofState(rawState);
        TracingSupport.TracingContext ctx = tracingSupport.beginValidation();
        return SimpleInstrumentationContext.whenCompleted((result, t2) -> ctx.onEnd());
    }

    public static class Options {
        private final boolean includeTrivialDataFetchers;

        private Options(boolean includeTrivialDataFetchers) {
            this.includeTrivialDataFetchers = includeTrivialDataFetchers;
        }

        public boolean isIncludeTrivialDataFetchers() {
            return this.includeTrivialDataFetchers;
        }

        public Options includeTrivialDataFetchers(boolean flag) {
            return new Options(flag);
        }

        public static Options newOptions() {
            return new Options(true);
        }
    }
}

