/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.RealmType;
import org.openqa.selenium.bidi.script.WindowRealmInfo;
import org.openqa.selenium.json.JsonInput;

public class RealmInfo {
    private final String realmId;
    private final String origin;
    private final RealmType realmType;

    public RealmInfo(String realmId, String origin, RealmType realmType) {
        this.realmId = realmId;
        this.origin = origin;
        this.realmType = realmType;
    }

    public static RealmInfo fromJson(JsonInput input) {
        String realmId = null;
        String origin = null;
        Enum realmType = null;
        String browsingContext = null;
        String sandbox = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    String typeString = (String)input.read((Type)((Object)String.class));
                    realmType = RealmType.findByName(typeString);
                    continue block14;
                }
                case "realm": {
                    realmId = (String)input.read((Type)((Object)String.class));
                    continue block14;
                }
                case "origin": {
                    origin = (String)input.read((Type)((Object)String.class));
                    continue block14;
                }
                case "context": {
                    browsingContext = (String)input.read((Type)((Object)String.class));
                    continue block14;
                }
                case "sandbox": {
                    sandbox = (String)input.read((Type)((Object)String.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        if (realmType.equals((Object)RealmType.WINDOW)) {
            return new WindowRealmInfo(realmId, origin, (RealmType)realmType, browsingContext, Optional.ofNullable(sandbox));
        }
        return new RealmInfo(realmId, origin, (RealmType)realmType);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getOrigin() {
        return this.origin;
    }

    public RealmType getRealmType() {
        return this.realmType;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        toReturn.put("type", this.getRealmType().toString());
        toReturn.put("realm", this.getRealmId());
        toReturn.put("origin", this.getOrigin());
        return Collections.unmodifiableMap(toReturn);
    }
}

