/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Extension;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileExtension
implements Extension {
    private static final String EM_NAMESPACE_URI = "http://www.mozilla.org/2004/em-rdf#";
    private final File toInstall;

    public FileExtension(File toInstall) {
        this.toInstall = toInstall;
    }

    @Override
    public void writeTo(File extensionsDir) throws IOException {
        if (!this.toInstall.isDirectory() && !FileHandler.isZipped(this.toInstall.getAbsolutePath())) {
            throw new IOException(String.format("Can only install from a zip file, an XPI or a directory: %s", this.toInstall.getAbsolutePath()));
        }
        if (this.toInstall.isDirectory()) {
            this.installExtensionFromDirectoryTo(extensionsDir);
        } else {
            this.installExtensionFromFileTo(extensionsDir);
        }
    }

    private void installExtensionFromDirectoryTo(File extensionsDir) throws IOException {
        String id = this.getExtensionId(this.toInstall);
        File target = new File(extensionsDir, id);
        if (target.exists() && !FileHandler.delete(target)) {
            throw new IOException("Unable to delete existing extension directory: " + String.valueOf(target));
        }
        FileHandler.createDir(target);
        FileHandler.makeWritable(target);
        FileHandler.copy(this.toInstall, target);
    }

    private void installExtensionFromFileTo(File extensionsDir) throws IOException {
        File unpackedExt = this.obtainRootDirectory(this.toInstall);
        String id = this.getExtensionId(unpackedExt);
        File target = new File(extensionsDir, id + ".xpi");
        if (target.exists() && !FileHandler.delete(target)) {
            throw new IOException("Unable to delete existing extension file: " + String.valueOf(target));
        }
        FileHandler.createDir(extensionsDir);
        FileHandler.makeWritable(extensionsDir);
        FileHandler.copy(this.toInstall, target);
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(unpackedExt);
    }

    private File obtainRootDirectory(File extensionToInstall) throws IOException {
        File root = extensionToInstall;
        if (!extensionToInstall.isDirectory()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(extensionToInstall));){
                root = Zip.unzipToTempDir(bis, "unzip", "stream");
            }
        }
        return root;
    }

    private String getExtensionId(File root) {
        File manifestJson = new File(root, "manifest.json");
        File installRdf = new File(root, "install.rdf");
        if (installRdf.exists()) {
            return this.readIdFromInstallRdf(root);
        }
        if (manifestJson.exists()) {
            return this.readIdFromManifestJson(root);
        }
        throw new WebDriverException("Extension should contain either install.rdf or manifest.json metadata file");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readIdFromManifestJson(File root) {
        String MANIFEST_JSON_FILE = "manifest.json";
        File manifestJsonFile = new File(root, "manifest.json");
        try (BufferedReader reader = Files.newBufferedReader(manifestJsonFile.toPath(), StandardCharsets.UTF_8);){
            JsonInput json = new Json().newInput(reader);
            try {
                Map geckoObj;
                Map applicationObj;
                Object addOnId = null;
                Map manifestObject = (Map)json.read(Json.MAP_TYPE);
                if (manifestObject.get("applications") instanceof Map && (applicationObj = (Map)manifestObject.get("applications")).get("gecko") instanceof Map && (geckoObj = (Map)applicationObj.get("gecko")).get("id") instanceof String) {
                    addOnId = ((String)geckoObj.get("id")).trim();
                }
                if (addOnId == null || ((String)addOnId).isEmpty()) {
                    addOnId = ((String)manifestObject.get("name")).replaceAll(" ", "") + "@" + String.valueOf(manifestObject.get("version"));
                }
                String string = addOnId;
                if (json != null) {
                    json.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (json != null) {
                    try {
                        json.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e1) {
            throw new WebDriverException("Unable to file manifest.json in xpi file");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String readIdFromInstallRdf(File root) {
        try {
            String id;
            File installRdf = new File(root, "install.rdf");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(installRdf);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if ("em".equals(prefix)) {
                        return FileExtension.EM_NAMESPACE_URI;
                    }
                    if ("RDF".equals(prefix)) {
                        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
                    }
                    return "";
                }

                @Override
                public String getPrefix(String uri) {
                    throw new UnsupportedOperationException("getPrefix");
                }

                @Override
                public Iterator<String> getPrefixes(String uri) {
                    throw new UnsupportedOperationException("getPrefixes");
                }
            });
            Node idNode = (Node)xpath.compile("//em:id").evaluate(doc, XPathConstants.NODE);
            if (idNode == null) {
                Node descriptionNode = (Node)xpath.compile("//RDF:Description").evaluate(doc, XPathConstants.NODE);
                Node idAttr = descriptionNode.getAttributes().getNamedItemNS(EM_NAMESPACE_URI, "id");
                if (idAttr == null) {
                    throw new WebDriverException("Cannot locate node containing extension id: " + installRdf.getAbsolutePath());
                }
                id = idAttr.getNodeValue();
            } else {
                id = idNode.getTextContent();
            }
            if (id == null || "".equals(id.trim())) {
                throw new FileNotFoundException("Cannot install extension with ID: " + id);
            }
            return id;
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
    }
}

