/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteNode
extends Node
implements Closeable {
    public static final Json JSON = new Json();
    private final HttpHandler client;
    private final URI externalUri;
    private final Set<Capabilities> capabilities;
    private final HealthCheck healthCheck;
    private final Filter addSecret;

    public RemoteNode(Tracer tracer, HttpClient.Factory clientFactory, NodeId id, URI externalUri, Secret registrationSecret, Collection<Capabilities> capabilities) {
        super(tracer, id, externalUri, registrationSecret);
        this.externalUri = Require.nonNull("External URI", externalUri);
        this.capabilities = ImmutableSet.copyOf(capabilities);
        this.client = Require.nonNull("HTTP client factory", clientFactory).createClient(Urls.fromUri(externalUri));
        this.healthCheck = new RemoteCheck();
        Require.nonNull("Registration secret", registrationSecret);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.capabilities.stream().anyMatch(caps -> caps.getCapabilityNames().stream().allMatch(name -> Objects.equals(caps.getCapability((String)name), capabilities.getCapability((String)name))));
    }

    @Override
    public Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Require.nonNull("Capabilities for session", sessionRequest);
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/session");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        req.setContent(Contents.asJson(sessionRequest));
        HttpResponse httpResponse = this.client.with(this.addSecret).execute(req);
        Optional<Map> maybeResponse = Optional.ofNullable((Map)Values.get(httpResponse, Map.class));
        if (maybeResponse.isPresent()) {
            Map response = maybeResponse.get();
            if (response.containsKey("sessionResponse")) {
                String rawResponse = JSON.toJson(response.get("sessionResponse"));
                CreateSessionResponse sessionResponse = (CreateSessionResponse)JSON.toType(rawResponse, (Type)((Object)CreateSessionResponse.class));
                return Either.right(sessionResponse);
            }
            String rawException = JSON.toJson(response.get("exception"));
            Map exception = (Map)JSON.toType(rawException, (Type)((Object)Map.class));
            String errorType = (String)exception.get("error");
            String errorMessage = (String)exception.get("message");
            if (RetrySessionRequestException.class.getName().contentEquals(errorType)) {
                return Either.left(new RetrySessionRequestException(errorMessage));
            }
            return Either.left(new SessionNotCreatedException(errorMessage));
        }
        return Either.left(new SessionNotCreatedException("Error while mapping response from Node"));
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull("Session ID", id);
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/owner/" + String.valueOf(id));
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        return Boolean.TRUE.equals(Values.get(res, Boolean.class));
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull("Session ID", id);
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/session/" + String.valueOf(id));
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        return (Session)Values.get(res, Session.class);
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        return this.client.execute(req);
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        return this.client.execute(req);
    }

    @Override
    public HttpResponse downloadFile(HttpRequest req, SessionId id) {
        return this.client.execute(req);
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Require.nonNull("Session ID", id);
        HttpRequest req = new HttpRequest(HttpMethod.DELETE, "/se/grid/node/session/" + String.valueOf(id));
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        Values.get(res, Void.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeStatus getStatus() {
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/status");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.execute(req);
        try (Reader reader = Contents.reader(res);
             JsonInput in = JSON.newInput(reader);){
            in.beginObject();
            while (in.hasNext()) {
                if ("value".equals(in.nextName())) {
                    in.beginObject();
                    while (in.hasNext()) {
                        if ("node".equals(in.nextName())) {
                            NodeStatus nodeStatus = (NodeStatus)in.read((Type)((Object)NodeStatus.class));
                            return nodeStatus;
                        }
                        in.skipValue();
                    }
                    in.endObject();
                    continue;
                }
                in.skipValue();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new IllegalStateException("Unable to read status");
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void drain() {
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/drain");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        if (res.getStatus() == 200) {
            this.draining = true;
        }
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of("id", this.getId(), "uri", this.externalUri, "capabilities", this.capabilities);
    }

    @Override
    public void close() {
        ((HttpClient)this.client).close();
    }

    private class RemoteCheck
    implements HealthCheck {
        private RemoteCheck() {
        }

        @Override
        public HealthCheck.Result check() {
            try {
                NodeStatus status = RemoteNode.this.getStatus();
                if (status.getNodeId() != null && !Objects.equals(RemoteNode.this.getId(), status.getNodeId())) {
                    return new HealthCheck.Result(Availability.DOWN, String.valueOf(RemoteNode.this.externalUri) + " has unexpected node id");
                }
                switch (status.getAvailability()) {
                    case DOWN: {
                        return new HealthCheck.Result(Availability.DOWN, String.valueOf(RemoteNode.this.externalUri) + " is down");
                    }
                    case DRAINING: {
                        return new HealthCheck.Result(Availability.DRAINING, String.valueOf(RemoteNode.this.externalUri) + " is draining");
                    }
                    case UP: {
                        return new HealthCheck.Result(Availability.UP, String.valueOf(RemoteNode.this.externalUri) + " is ok");
                    }
                }
                throw new IllegalStateException("Unknown node availability: " + String.valueOf((Object)status.getAvailability()));
            }
            catch (RuntimeException e) {
                return new HealthCheck.Result(Availability.DOWN, "Unable to determine node status: " + e.getMessage());
            }
        }
    }
}

