/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.cli;

import java.io.File;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opendataloader.pdf.api.Config;
import org.opendataloader.pdf.api.OpenDataLoaderPDF;
import org.opendataloader.pdf.cli.CLIOptions;

public class CLIMain {
    private static final Logger LOGGER = Logger.getLogger(CLIMain.class.getCanonicalName());
    private static final String HELP = "[options] <INPUT FILE OR FOLDER>...\n Options:";

    public static void main(String[] args) {
        boolean quiet;
        Config config;
        CommandLine commandLine;
        Options options = CLIOptions.defineOptions();
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp(HELP, options);
            return;
        }
        if (commandLine.getArgs().length < 1) {
            formatter.printHelp(HELP, options);
            return;
        }
        String[] arguments = commandLine.getArgs();
        try {
            config = CLIOptions.createConfigFromCommandLine(commandLine);
            quiet = commandLine.hasOption("q") || commandLine.hasOption("quiet");
        }
        catch (IllegalArgumentException exception) {
            System.out.println(exception.getMessage());
            formatter.printHelp(HELP, options);
            return;
        }
        CLIMain.configureLogging(quiet);
        for (String argument : arguments) {
            CLIMain.processPath(new File(argument), config);
        }
    }

    private static void configureLogging(boolean quiet) {
        if (!quiet) {
            return;
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.OFF);
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(Level.OFF);
        }
        LOGGER.setLevel(Level.OFF);
    }

    private static void processPath(File file, Config config) {
        if (!file.exists()) {
            LOGGER.log(Level.WARNING, "File or folder " + file.getAbsolutePath() + " not found.");
            return;
        }
        if (file.isDirectory()) {
            CLIMain.processDirectory(file, config);
        } else if (file.isFile()) {
            CLIMain.processFile(file, config);
        }
    }

    private static void processDirectory(File file, Config config) {
        File[] children = file.listFiles();
        if (children == null) {
            LOGGER.log(Level.WARNING, "Unable to read folder " + file.getAbsolutePath());
            return;
        }
        for (File child : children) {
            CLIMain.processPath(child, config);
        }
    }

    private static void processFile(File file, Config config) {
        if (!CLIMain.isPdfFile(file)) {
            LOGGER.log(Level.FINE, "Skipping non-PDF file " + file.getAbsolutePath());
            return;
        }
        try {
            OpenDataLoaderPDF.processFile(file.getAbsolutePath(), config);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception during processing file " + file.getAbsolutePath() + ": " + exception.getMessage(), exception);
        }
    }

    private static boolean isPdfFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        return name.toLowerCase(Locale.ROOT).endsWith(".pdf");
    }
}

