/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.cli;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opendataloader.pdf.api.Config;

public class CLIOptions {
    private static final String CONTENT_SAFETY_OFF_LONG_OPTION = "content-safety-off";
    private static final String CONTENT_SAFETY_OFF_ALL_ARGUMENT = "all";
    private static final String CONTENT_SAFETY_OFF_HIDDEN_TEXT_ARGUMENT = "hidden-text";
    private static final String CONTENT_SAFETY_OFF_OFF_PAGE_ARGUMENT = "off-page";
    private static final String CONTENT_SAFETY_OFF_TINY_TEXT_ARGUMENT = "tiny";
    private static final String CONTENT_SAFETY_OFF_HIDDEN_OCG_ARGUMENT = "hidden-ocg";
    private static final String CONTENT_SAFETY_OFF_SUPPORTED_LIST = "all, hidden-text, off-page, tiny, hidden-ocg";
    public static final String PASSWORD_OPTION = "p";
    private static final String PASSWORD_LONG_OPTION = "password";
    public static final String FOLDER_OPTION = "o";
    private static final String FOLDER_LONG_OPTION = "output-dir";
    public static final String FORMAT_OPTION = "f";
    private static final String FORMAT_LONG_OPTION = "format";
    private static final String FORMAT_SUPPORTED_LIST = "json, text, html, pdf, markdown, markdown-with-html, markdown-with-images";
    public static final String QUIET_OPTION = "q";
    private static final String QUIET_LONG_OPTION = "quiet";
    private static final String HTML_IN_MARKDOWN_LONG_OPTION = "markdown-with-html";
    private static final String KEEP_LINE_BREAKS_LONG_OPTION = "keep-line-breaks";
    public static final String PDF_REPORT_LONG_OPTION = "pdf";
    public static final String MARKDOWN_REPORT_LONG_OPTION = "markdown";
    public static final String HTML_REPORT_LONG_OPTION = "html";
    private static final String MARKDOWN_IMAGE_LONG_OPTION = "markdown-with-images";
    public static final String NO_JSON_REPORT_LONG_OPTION = "no-json";
    private static final String REPLACE_INVALID_CHARS_LONG_OPTION = "replace-invalid-chars";

    public static Options defineOptions() {
        Options options = new Options();
        Option contentSafetyOff = new Option(null, CONTENT_SAFETY_OFF_LONG_OPTION, true, "Disables one or more content safety filters. Accepts a comma-separated list of filter names. Arguments: all, hidden-text, off-page, tiny, hidden-ocg");
        contentSafetyOff.setRequired(false);
        contentSafetyOff.setArgs(-2);
        options.addOption(contentSafetyOff);
        Option password = new Option(PASSWORD_OPTION, PASSWORD_LONG_OPTION, true, "Specifies the password for an encrypted PDF");
        password.setRequired(false);
        options.addOption(password);
        Option htmlInMarkdown = new Option(null, HTML_IN_MARKDOWN_LONG_OPTION, false, "Sets the data extraction output format to Markdown with rendering complex elements like tables as HTML for better structure");
        htmlInMarkdown.setRequired(false);
        options.addOption(htmlInMarkdown);
        Option format = new Option(FORMAT_OPTION, FORMAT_LONG_OPTION, true, String.format("Comma-separated list of output formats to generate. Supported values: %s", FORMAT_SUPPORTED_LIST));
        format.setRequired(false);
        format.setArgs(-2);
        options.addOption(format);
        Option quiet = new Option(QUIET_OPTION, QUIET_LONG_OPTION, false, "Suppresses console logging output");
        quiet.setRequired(false);
        options.addOption(quiet);
        Option keepLineBreaks = new Option(null, KEEP_LINE_BREAKS_LONG_OPTION, false, "Preserves original line breaks in the extracted text");
        keepLineBreaks.setRequired(false);
        options.addOption(keepLineBreaks);
        Option pdfOutput = new Option(null, PDF_REPORT_LONG_OPTION, false, "Generates a new PDF file where the extracted layout data is visualized as annotations");
        pdfOutput.setRequired(false);
        options.addOption(pdfOutput);
        Option markdownOutput = new Option(null, MARKDOWN_REPORT_LONG_OPTION, false, "Sets the data extraction output format to Markdown");
        markdownOutput.setRequired(false);
        options.addOption(markdownOutput);
        Option generateHtml = new Option(null, HTML_REPORT_LONG_OPTION, false, "Sets the data extraction output format to HTML");
        generateHtml.setRequired(false);
        options.addOption(generateHtml);
        Option imageSupport = new Option(null, MARKDOWN_IMAGE_LONG_OPTION, false, "Sets the data extraction output format to Markdown with extracting images from the PDF and includes them as links");
        imageSupport.setRequired(false);
        options.addOption(imageSupport);
        Option noJson = new Option(null, NO_JSON_REPORT_LONG_OPTION, false, "Disables the JSON output format.");
        noJson.setRequired(false);
        options.addOption(noJson);
        Option folder = new Option(FOLDER_OPTION, FOLDER_LONG_OPTION, true, "Specifies the output directory for generated files (default the folder of the input PDF)");
        folder.setRequired(false);
        options.addOption(folder);
        Option replaceInvalidChars = new Option(null, REPLACE_INVALID_CHARS_LONG_OPTION, true, "Replaces invalid or unrecognized characters (e.g., \ufffd, \\u0000) with the specified character (whitespace is used, if this parameter not specified)");
        replaceInvalidChars.setRequired(false);
        options.addOption(replaceInvalidChars);
        return options;
    }

    public static Config createConfigFromCommandLine(CommandLine commandLine) {
        Config config = new Config();
        if (commandLine.hasOption(PASSWORD_OPTION)) {
            config.setPassword(commandLine.getOptionValue(PASSWORD_OPTION));
        }
        if (commandLine.hasOption(KEEP_LINE_BREAKS_LONG_OPTION)) {
            config.setKeepLineBreaks(true);
        }
        if (commandLine.hasOption(PDF_REPORT_LONG_OPTION)) {
            config.setGeneratePDF(true);
        }
        if (commandLine.hasOption(MARKDOWN_REPORT_LONG_OPTION)) {
            config.setGenerateMarkdown(true);
        }
        if (commandLine.hasOption(HTML_REPORT_LONG_OPTION)) {
            config.setGenerateHtml(true);
        }
        if (commandLine.hasOption(HTML_IN_MARKDOWN_LONG_OPTION)) {
            config.setUseHTMLInMarkdown(true);
        }
        if (commandLine.hasOption(MARKDOWN_IMAGE_LONG_OPTION)) {
            config.setAddImageToMarkdown(true);
        }
        if (commandLine.hasOption(NO_JSON_REPORT_LONG_OPTION)) {
            config.setGenerateJSON(false);
        }
        if (commandLine.hasOption(REPLACE_INVALID_CHARS_LONG_OPTION)) {
            config.setReplaceInvalidChars(commandLine.getOptionValue(REPLACE_INVALID_CHARS_LONG_OPTION));
        }
        if (commandLine.hasOption(FOLDER_OPTION)) {
            config.setOutputFolder(commandLine.getOptionValue(FOLDER_OPTION));
        } else {
            String argument = commandLine.getArgs()[0];
            File file = new File(argument);
            config.setOutputFolder((file = new File(file.getAbsolutePath())).isDirectory() ? file.getAbsolutePath() : file.getParent());
        }
        CLIOptions.applyContentSafetyOption(config, commandLine);
        CLIOptions.applyFormatOption(config, commandLine);
        return config;
    }

    private static void applyContentSafetyOption(Config config, CommandLine commandLine) {
        if (!commandLine.hasOption(CONTENT_SAFETY_OFF_LONG_OPTION)) {
            return;
        }
        String[] optionValues = commandLine.getOptionValues(CONTENT_SAFETY_OFF_LONG_OPTION);
        if (optionValues == null || optionValues.length == 0) {
            throw new IllegalArgumentException(String.format("Option --content-safety-off requires at least one value. Supported values: %s", CONTENT_SAFETY_OFF_SUPPORTED_LIST));
        }
        Set<String> values = CLIOptions.parseOptionValues(optionValues);
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("Option --content-safety-off requires at least one value. Supported values: %s", CONTENT_SAFETY_OFF_SUPPORTED_LIST));
        }
        Iterator<String> iterator = values.iterator();
        block14: while (iterator.hasNext()) {
            String value;
            switch (value = iterator.next()) {
                case "hidden-text": {
                    config.getFilterConfig().setFilterHiddenText(false);
                    continue block14;
                }
                case "off-page": {
                    config.getFilterConfig().setFilterOutOfPage(false);
                    continue block14;
                }
                case "tiny": {
                    config.getFilterConfig().setFilterTinyText(false);
                    continue block14;
                }
                case "hidden-ocg": {
                    config.getFilterConfig().setFilterHiddenOCG(false);
                    continue block14;
                }
                case "all": {
                    config.getFilterConfig().setFilterHiddenText(false);
                    config.getFilterConfig().setFilterOutOfPage(false);
                    config.getFilterConfig().setFilterTinyText(false);
                    config.getFilterConfig().setFilterHiddenOCG(false);
                    continue block14;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported value '%s'. Supported values: %s", value, CONTENT_SAFETY_OFF_SUPPORTED_LIST));
        }
    }

    private static void applyFormatOption(Config config, CommandLine commandLine) {
        if (!commandLine.hasOption(FORMAT_OPTION)) {
            return;
        }
        String[] optionValues = commandLine.getOptionValues(FORMAT_OPTION);
        if (optionValues == null || optionValues.length == 0) {
            throw new IllegalArgumentException(String.format("Option --format requires at least one value. Supported values: %s", FORMAT_SUPPORTED_LIST));
        }
        Set<String> values = CLIOptions.parseOptionValues(optionValues);
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("Option --format requires at least one value. Supported values: %s", FORMAT_SUPPORTED_LIST));
        }
        config.setGenerateJSON(false);
        Iterator<String> iterator = values.iterator();
        block18: while (iterator.hasNext()) {
            String value;
            switch (value = iterator.next()) {
                case "json": {
                    config.setGenerateJSON(true);
                    continue block18;
                }
                case "html": {
                    config.setGenerateHtml(true);
                    continue block18;
                }
                case "text": {
                    config.setGenerateText(true);
                    continue block18;
                }
                case "pdf": {
                    config.setGeneratePDF(true);
                    continue block18;
                }
                case "markdown": {
                    config.setGenerateMarkdown(true);
                    continue block18;
                }
                case "markdown-with-html": {
                    config.setUseHTMLInMarkdown(true);
                    continue block18;
                }
                case "markdown-with-images": {
                    config.setAddImageToMarkdown(true);
                    continue block18;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported format '%s'. Supported values: %s", value, FORMAT_SUPPORTED_LIST));
        }
    }

    private static Set<String> parseOptionValues(String[] optionValues) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (String rawValue : optionValues) {
            String[] splitValues;
            if (rawValue == null) continue;
            for (String candidate : splitValues = rawValue.split(",")) {
                String format = candidate.trim().toLowerCase(Locale.ROOT);
                if (format.isEmpty()) continue;
                values.add(format);
            }
        }
        return values;
    }
}

