/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.containers;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;

public class StaticLayoutContainers {
    private static final ThreadLocal<Long> currentContentId = new ThreadLocal();
    private static final ThreadLocal<List<SemanticHeading>> headings = new ThreadLocal();
    private static final ThreadLocal<Integer> imageIndex = new ThreadLocal();

    public static void clearContainers() {
        currentContentId.set(1L);
        headings.set(new LinkedList());
        imageIndex.set(1);
    }

    public static long getCurrentContentId() {
        return currentContentId.get();
    }

    public static long incrementContentId() {
        long id = StaticLayoutContainers.getCurrentContentId();
        StaticLayoutContainers.setCurrentContentId(id + 1L);
        return id;
    }

    public static void setCurrentContentId(long currentContentId) {
        StaticLayoutContainers.currentContentId.set(currentContentId);
    }

    public static List<SemanticHeading> getHeadings() {
        return headings.get();
    }

    public static void setHeadings(List<SemanticHeading> headings) {
        StaticLayoutContainers.headings.set(headings);
    }

    public static int incrementImageIndex() {
        int imageIndex = StaticLayoutContainers.imageIndex.get();
        StaticLayoutContainers.imageIndex.set(imageIndex + 1);
        return imageIndex;
    }
}

