/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opendataloader.pdf.json.ObjectMapperHolder;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSTrailer;
import org.verapdf.gf.model.impl.cos.GFCosInfo;
import org.verapdf.pd.PDDocument;
import org.verapdf.tools.StaticResources;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class JsonWriter {
    private static final Logger LOGGER = Logger.getLogger(JsonWriter.class.getCanonicalName());

    private static JsonGenerator getJsonGenerator(String fileName) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        return jsonFactory.createGenerator(new File(fileName), JsonEncoding.UTF8).setPrettyPrinter(new DefaultPrettyPrinter()).setCodec(ObjectMapperHolder.getObjectMapper());
    }

    public static void writeToJson(File inputPDF, String outputFolder, List<List<IObject>> contents) throws IOException {
        String jsonFileName = outputFolder + File.separator + inputPDF.getName().substring(0, inputPDF.getName().length() - 3) + "json";
        try (JsonGenerator jsonGenerator = JsonWriter.getJsonGenerator(jsonFileName);){
            jsonGenerator.writeStartObject();
            JsonWriter.writeDocumentInfo(jsonGenerator, inputPDF.getName());
            jsonGenerator.writeArrayFieldStart("kids");
            for (int pageNumber = 0; pageNumber < StaticContainers.getDocument().getNumberOfPages(); ++pageNumber) {
                for (IObject content : contents.get(pageNumber)) {
                    jsonGenerator.writePOJO(content);
                }
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
        LOGGER.log(Level.INFO, "Created {0}", jsonFileName);
    }

    private static void writeDocumentInfo(JsonGenerator generator, String pdfName) throws IOException {
        PDDocument document = StaticResources.getDocument();
        generator.writeStringField("file name", pdfName);
        generator.writeNumberField("number of pages", document.getNumberOfPages());
        COSTrailer trailer = document.getDocument().getTrailer();
        COSObject object = trailer.getKey(ASAtom.INFO);
        GFCosInfo info = new GFCosInfo((COSDictionary)(object != null && object.getType() == COSObjType.COS_DICT ? object.getDirectBase() : COSDictionary.construct().get()));
        generator.writeStringField("author", info.getAuthor() != null ? info.getAuthor() : info.getXMPCreator());
        generator.writeStringField("title", info.getTitle() != null ? info.getTitle() : info.getXMPTitle());
        generator.writeStringField("creation date", info.getCreationDate() != null ? info.getCreationDate() : info.getXMPCreateDate());
        generator.writeStringField("modification date", info.getModDate() != null ? info.getModDate() : info.getXMPModifyDate());
    }
}

