/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.opendataloader.pdf.json.serializers.CaptionSerializer;
import org.opendataloader.pdf.json.serializers.DoubleSerializer;
import org.opendataloader.pdf.json.serializers.HeaderFooterSerializer;
import org.opendataloader.pdf.json.serializers.HeadingSerializer;
import org.opendataloader.pdf.json.serializers.ImageSerializer;
import org.opendataloader.pdf.json.serializers.LineArtSerializer;
import org.opendataloader.pdf.json.serializers.LineChunkSerializer;
import org.opendataloader.pdf.json.serializers.ListItemSerializer;
import org.opendataloader.pdf.json.serializers.ListSerializer;
import org.opendataloader.pdf.json.serializers.SemanticTextNodeSerializer;
import org.opendataloader.pdf.json.serializers.TableCellSerializer;
import org.opendataloader.pdf.json.serializers.TableRowSerializer;
import org.opendataloader.pdf.json.serializers.TableSerializer;
import org.opendataloader.pdf.json.serializers.TextChunkSerializer;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticHeaderOrFooter;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class ObjectMapperHolder {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    static {
        SimpleModule module = new SimpleModule("NodeSerializer", new Version(2, 1, 3, null, null, null));
        TextChunkSerializer textChunkSerializer = new TextChunkSerializer(TextChunk.class);
        module.addSerializer(TextChunk.class, textChunkSerializer);
        ImageSerializer imageSerializer = new ImageSerializer(ImageChunk.class);
        module.addSerializer(ImageChunk.class, imageSerializer);
        LineArtSerializer lineArtSerializer = new LineArtSerializer(LineArtChunk.class);
        module.addSerializer(LineArtChunk.class, lineArtSerializer);
        TableSerializer tableSerializer = new TableSerializer(TableBorder.class);
        module.addSerializer(TableBorder.class, tableSerializer);
        TableCellSerializer tableCellSerializer = new TableCellSerializer(TableBorderCell.class);
        module.addSerializer(TableBorderCell.class, tableCellSerializer);
        ListSerializer listSerializer = new ListSerializer(PDFList.class);
        module.addSerializer(PDFList.class, listSerializer);
        ListItemSerializer listItemSerializer = new ListItemSerializer(ListItem.class);
        module.addSerializer(ListItem.class, listItemSerializer);
        LineChunkSerializer lineChunkSerializer = new LineChunkSerializer(LineChunk.class);
        module.addSerializer(LineChunk.class, lineChunkSerializer);
        SemanticTextNodeSerializer semanticTextNodeSerializer = new SemanticTextNodeSerializer(SemanticTextNode.class);
        module.addSerializer(SemanticTextNode.class, semanticTextNodeSerializer);
        TableRowSerializer tableRowSerializer = new TableRowSerializer(TableBorderRow.class);
        module.addSerializer(TableBorderRow.class, tableRowSerializer);
        HeadingSerializer headingSerializer = new HeadingSerializer(SemanticHeading.class);
        module.addSerializer(SemanticHeading.class, headingSerializer);
        CaptionSerializer captionSerializer = new CaptionSerializer(SemanticCaption.class);
        module.addSerializer(SemanticCaption.class, captionSerializer);
        DoubleSerializer doubleSerializer = new DoubleSerializer(Double.class);
        module.addSerializer(Double.class, doubleSerializer);
        HeaderFooterSerializer headerFooterSerializer = new HeaderFooterSerializer(SemanticHeaderOrFooter.class);
        module.addSerializer(SemanticHeaderOrFooter.class, headerFooterSerializer);
        objectMapper.registerModule(module);
    }
}

