/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import org.opendataloader.pdf.json.serializers.SerializerUtil;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;

public class ListItemSerializer
extends StdSerializer<ListItem> {
    public ListItemSerializer(Class<ListItem> t) {
        super(t);
    }

    @Override
    public void serialize(ListItem item, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        SerializerUtil.writeEssentialInfo(jsonGenerator, item, "list item");
        jsonGenerator.writeStringField("font", item.getFirstLine().getFirstTextChunk().getFontName());
        jsonGenerator.writePOJOField("font size", item.getFontSize());
        jsonGenerator.writeStringField("text color", Arrays.toString(item.getFirstLine().getFirstTextChunk().getFontColor()));
        jsonGenerator.writeStringField("content", item.toString());
        jsonGenerator.writeArrayFieldStart("kids");
        for (IObject content : item.getContents()) {
            jsonGenerator.writePOJO(content);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

