/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.opendataloader.pdf.json.serializers.SerializerUtil;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;

public class ListSerializer
extends StdSerializer<PDFList> {
    public ListSerializer(Class<PDFList> t) {
        super(t);
    }

    @Override
    public void serialize(PDFList list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        SerializerUtil.writeEssentialInfo(jsonGenerator, list, "list");
        jsonGenerator.writeStringField("numbering style", list.getNumberingStyle());
        jsonGenerator.writeNumberField("number of list items", list.getNumberOfListItems());
        if (list.getPreviousListId() != null) {
            jsonGenerator.writeNumberField("previous list id", list.getPreviousListId());
        }
        if (list.getNextListId() != null) {
            jsonGenerator.writeNumberField("next list id", list.getNextListId());
        }
        jsonGenerator.writeArrayFieldStart("list items");
        for (ListItem item : list.getListItems()) {
            jsonGenerator.writePOJO(item);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

