/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;

public class SerializerUtil {
    public static void writeEssentialInfo(JsonGenerator jsonGenerator, IObject object, String type) throws IOException {
        jsonGenerator.writeStringField("type", type);
        if (object.getRecognizedStructureId() != null) {
            jsonGenerator.writeNumberField("id", object.getRecognizedStructureId());
        }
        if (object.getLevel() != null) {
            jsonGenerator.writeStringField("level", object.getLevel());
        }
        jsonGenerator.writeNumberField("page number", object.getPageNumber() + 1);
        jsonGenerator.writeArrayFieldStart("bounding box");
        jsonGenerator.writePOJO(object.getLeftX());
        jsonGenerator.writePOJO(object.getBottomY());
        jsonGenerator.writePOJO(object.getRightX());
        jsonGenerator.writePOJO(object.getTopY());
        jsonGenerator.writeEndArray();
    }

    public static void writeTextInfo(JsonGenerator jsonGenerator, SemanticTextNode textNode) throws IOException {
        jsonGenerator.writeStringField("font", textNode.getFontName());
        jsonGenerator.writePOJOField("font size", textNode.getFontSize());
        jsonGenerator.writeStringField("text color", Arrays.toString(textNode.getTextColor()));
        jsonGenerator.writeStringField("content", textNode.getValue());
        if (textNode.isHiddenText()) {
            jsonGenerator.writeBooleanField("hidden text", true);
        }
    }
}

