/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class TableRowSerializer
extends StdSerializer<TableBorderRow> {
    public TableRowSerializer(Class<TableBorderRow> t) {
        super(t);
    }

    @Override
    public void serialize(TableBorderRow row, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "table row");
        jsonGenerator.writeNumberField("row number", row.getRowNumber() + 1);
        jsonGenerator.writeArrayFieldStart("cells");
        TableBorderCell[] cells = row.getCells();
        for (int columnNumber = 0; columnNumber < cells.length; ++columnNumber) {
            TableBorderCell cell = cells[columnNumber];
            if (cell.getColNumber() != columnNumber || cell.getRowNumber() != row.getRowNumber()) continue;
            jsonGenerator.writePOJO(cell);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

