/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.json.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.opendataloader.pdf.json.serializers.SerializerUtil;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class TableSerializer
extends StdSerializer<TableBorder> {
    public TableSerializer(Class<TableBorder> t) {
        super(t);
    }

    @Override
    public void serialize(TableBorder table, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        SerializerUtil.writeEssentialInfo(jsonGenerator, table, table.isTextBlock() ? "text block" : "table");
        if (table.isTextBlock()) {
            jsonGenerator.writeArrayFieldStart("kids");
            for (IObject content : table.getCell(0, 0).getContents()) {
                jsonGenerator.writePOJO(content);
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeNumberField("number of rows", table.getNumberOfRows());
            jsonGenerator.writeNumberField("number of columns", table.getNumberOfColumns());
            if (table.getPreviousTableId() != null) {
                jsonGenerator.writeNumberField("previous table id", table.getPreviousTableId());
            }
            if (table.getNextTableId() != null) {
                jsonGenerator.writeNumberField("next table id", table.getNextTableId());
            }
            jsonGenerator.writeArrayFieldStart("rows");
            for (TableBorderRow row : table.getRows()) {
                jsonGenerator.writePOJO(row);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

