/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.markdown;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.opendataloader.pdf.api.Config;
import org.opendataloader.pdf.containers.StaticLayoutContainers;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ContrastRatioConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class MarkdownGenerator
implements Closeable {
    protected static final Logger LOGGER = Logger.getLogger(MarkdownGenerator.class.getCanonicalName());
    protected final FileWriter markdownWriter;
    protected final String pdfFileName;
    protected final String imageDirectoryName;
    protected ContrastRatioConsumer contrastRatioConsumer;
    protected final String markdownFileName;
    protected int tableNesting = 0;
    protected boolean isImageSupported;
    private final String password;

    MarkdownGenerator(File inputPdf, String outputFolder, Config config) throws IOException {
        String cutPdfFileName = inputPdf.getName();
        this.markdownFileName = outputFolder + File.separator + cutPdfFileName.substring(0, cutPdfFileName.length() - 3) + "md";
        this.imageDirectoryName = outputFolder + File.separator + cutPdfFileName.substring(0, cutPdfFileName.length() - 4) + "_images";
        this.pdfFileName = inputPdf.getAbsolutePath();
        this.markdownWriter = new FileWriter(this.markdownFileName, StandardCharsets.UTF_8);
        this.isImageSupported = config.isAddImageToMarkdown();
        this.password = config.getPassword();
    }

    public void writeToMarkdown(List<List<IObject>> contents) {
        try {
            for (int pageNumber = 0; pageNumber < StaticContainers.getDocument().getNumberOfPages(); ++pageNumber) {
                for (IObject content : contents.get(pageNumber)) {
                    if (!this.isSupportedContent(content)) continue;
                    this.write(content);
                    this.writeContentsSeparator();
                }
            }
            LOGGER.log(Level.INFO, "Created {0}", this.markdownFileName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to create markdown output: " + e.getMessage());
        }
    }

    protected boolean isSupportedContent(IObject content) {
        return content instanceof SemanticTextNode || content instanceof TableBorder || content instanceof PDFList || content instanceof ImageChunk && this.isImageSupported;
    }

    protected void writeContentsSeparator() throws IOException {
        this.writeLineBreak();
        this.writeLineBreak();
    }

    protected void write(IObject object) throws IOException {
        if (object instanceof ImageChunk) {
            this.writeImage((ImageChunk)object);
        } else if (object instanceof SemanticHeading) {
            this.writeHeading((SemanticHeading)object);
        } else if (object instanceof SemanticParagraph) {
            this.writeParagraph((SemanticParagraph)object);
        } else if (object instanceof SemanticTextNode) {
            this.writeSemanticTextNode((SemanticTextNode)object);
        } else if (object instanceof TableBorder) {
            this.writeTable((TableBorder)object);
        } else if (object instanceof PDFList) {
            this.writeList((PDFList)object);
        }
    }

    protected void writeImage(ImageChunk image) throws IOException {
        String fileName;
        boolean isFileCreated;
        int currentImageIndex = StaticLayoutContainers.incrementImageIndex();
        if (currentImageIndex == 1) {
            new File(this.imageDirectoryName).mkdirs();
            this.contrastRatioConsumer = new ContrastRatioConsumer(this.pdfFileName, this.password, false, null);
        }
        if (isFileCreated = this.createImageFile(image, fileName = String.format("%s%simageFile%d.png", this.imageDirectoryName, File.separator, currentImageIndex))) {
            String imageString = String.format("![%s](%s)", "image " + currentImageIndex, fileName);
            this.markdownWriter.write(this.getCorrectMarkdownString(imageString));
        }
    }

    protected boolean createImageFile(ImageChunk image, String fileName) {
        try {
            BoundingBox imageBox = image.getBoundingBox();
            BufferedImage targetImage = this.contrastRatioConsumer.getPageSubImage(imageBox);
            if (targetImage == null) {
                return false;
            }
            File outputFile = new File(fileName);
            ImageIO.write((RenderedImage)targetImage, "png", outputFile);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to create image files: " + e.getMessage());
            return false;
        }
    }

    protected void writeList(PDFList list) throws IOException {
        for (ListItem item : list.getListItems()) {
            if (!this.isInsideTable()) {
                this.markdownWriter.write("-");
                this.markdownWriter.write(" ");
            }
            this.markdownWriter.write(this.getCorrectMarkdownString(item.toString()));
            this.writeLineBreak();
            List<IObject> itemContents = item.getContents();
            if (itemContents.isEmpty()) continue;
            this.writeLineBreak();
            this.writeContents(itemContents);
        }
    }

    protected void writeSemanticTextNode(SemanticTextNode textNode) throws IOException {
        this.markdownWriter.write(this.getCorrectMarkdownString(textNode.getValue()));
    }

    protected void writeTable(TableBorder table) throws IOException {
        this.enterTable();
        for (TableBorderRow row : table.getRows()) {
            this.markdownWriter.write("|");
            for (TableBorderCell cell : row.getCells()) {
                List<IObject> cellContents = cell.getContents();
                this.writeContents(cellContents);
                this.markdownWriter.write("|");
            }
            this.markdownWriter.write("\n");
            if (row.getRowNumber() != 0) continue;
            this.markdownWriter.write("|");
            for (int i = 0; i < table.getNumberOfColumns(); ++i) {
                this.markdownWriter.write("---");
                this.markdownWriter.write("|");
            }
            this.markdownWriter.write("\n");
        }
        this.leaveTable();
    }

    protected void writeContents(List<IObject> contents) throws IOException {
        for (int i = 0; i < contents.size(); ++i) {
            boolean isLastContent;
            IObject content = contents.get(i);
            if (!this.isSupportedContent(content)) continue;
            this.write(content);
            boolean bl = isLastContent = i == contents.size() - 1;
            if (isLastContent) continue;
            this.writeContentsSeparator();
        }
    }

    protected void writeParagraph(SemanticParagraph textNode) throws IOException {
        String value = textNode.getValue();
        if (this.isInsideTable() && StaticContainers.isKeepLineBreaks()) {
            value = value.replace("\n", this.getLineBreak());
        }
        this.markdownWriter.write(this.getCorrectMarkdownString(value));
    }

    protected void writeHeading(SemanticHeading heading) throws IOException {
        if (!this.isInsideTable()) {
            int headingLevel = heading.getHeadingLevel();
            for (int i = 0; i < headingLevel; ++i) {
                this.markdownWriter.write("#");
            }
            this.markdownWriter.write(" ");
        }
        this.markdownWriter.write(this.getCorrectMarkdownString(heading.getValue()));
    }

    protected void enterTable() {
        ++this.tableNesting;
    }

    protected void leaveTable() {
        if (this.tableNesting > 0) {
            --this.tableNesting;
        }
    }

    protected boolean isInsideTable() {
        return this.tableNesting > 0;
    }

    protected String getLineBreak() {
        if (this.isInsideTable()) {
            return "<br>";
        }
        return "\n";
    }

    protected void writeLineBreak() throws IOException {
        this.markdownWriter.write(this.getLineBreak());
    }

    protected String getCorrectMarkdownString(String value) {
        if (value != null) {
            return value.replace("\u0000", " ");
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.markdownWriter != null) {
            this.markdownWriter.close();
        }
        if (this.contrastRatioConsumer != null) {
            this.contrastRatioConsumer.close();
        }
    }
}

