/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.markdown;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opendataloader.pdf.api.Config;
import org.opendataloader.pdf.markdown.MarkdownGenerator;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class MarkdownHTMLGenerator
extends MarkdownGenerator {
    protected MarkdownHTMLGenerator(File inputPdf, String fileName, Config config) throws IOException {
        super(inputPdf, fileName, config);
    }

    @Override
    protected void writeTable(TableBorder table) throws IOException {
        this.enterTable();
        this.markdownWriter.write("<table>");
        this.markdownWriter.write("\n");
        for (int rowNumber = 0; rowNumber < table.getNumberOfRows(); ++rowNumber) {
            TableBorderRow row = table.getRow(rowNumber);
            this.markdownWriter.write("  ");
            this.markdownWriter.write("<tr>");
            this.markdownWriter.write("\n");
            for (int colNumber = 0; colNumber < table.getNumberOfColumns(); ++colNumber) {
                TableBorderCell cell = row.getCell(colNumber);
                if (cell.getRowNumber() != rowNumber || cell.getColNumber() != colNumber) continue;
                boolean isHeader = rowNumber == 0;
                this.writeCellTagBegin(cell, isHeader);
                List<IObject> cellContents = cell.getContents();
                this.writeContents(cellContents);
                this.writeCellTagEnd(isHeader);
                this.markdownWriter.write("\n");
            }
            this.markdownWriter.write("  ");
            this.markdownWriter.write("</tr>");
            this.markdownWriter.write("\n");
        }
        this.markdownWriter.write("</table>");
        this.markdownWriter.write("\n");
        this.leaveTable();
    }

    private void writeCellTagBegin(TableBorderCell cell, boolean isHeader) throws IOException {
        int rowSpan;
        this.markdownWriter.write("  ");
        this.markdownWriter.write("  ");
        String tag = isHeader ? "<th" : "<td";
        StringBuilder cellTag = new StringBuilder(tag);
        int colSpan = cell.getColSpan();
        if (colSpan != 1) {
            cellTag.append(" colspan=\"").append(colSpan).append("\"");
        }
        if ((rowSpan = cell.getRowSpan()) != 1) {
            cellTag.append(" rowspan=\"").append(rowSpan).append("\"");
        }
        cellTag.append(">");
        this.markdownWriter.write(this.getCorrectMarkdownString(cellTag.toString()));
    }

    private void writeCellTagEnd(boolean isHeader) throws IOException {
        if (isHeader) {
            this.markdownWriter.write("</th>");
        } else {
            this.markdownWriter.write("</td>");
        }
    }
}

