/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.List;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.CaptionUtils;

public class CaptionProcessor {
    private static final double CAPTION_PROBABILITY = 0.75;
    private static final double CAPTION_VERTICAL_OFFSET_RATIO = 1.0;
    private static final double CAPTION_HORIZONTAL_OFFSET_RATIO = 1.0;

    public static void processCaptions(List<IObject> contents) {
        DocumentProcessor.setIndexesForContentsList(contents);
        SemanticFigure imageNode = null;
        SemanticTextNode lastTextNode = null;
        for (IObject content : contents) {
            if (content == null) continue;
            if (content instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)content;
                if (textNode.isSpaceNode() || textNode.isEmpty()) continue;
                if (imageNode != null && CaptionProcessor.isTextNotContainedInImage(imageNode, textNode)) {
                    CaptionProcessor.acceptImageCaption(contents, imageNode, lastTextNode, textNode);
                    imageNode = null;
                }
                lastTextNode = textNode;
                continue;
            }
            if (content instanceof ImageChunk) {
                if (imageNode != null && CaptionProcessor.isTextNotContainedInImage(imageNode, lastTextNode)) {
                    CaptionProcessor.acceptImageCaption(contents, imageNode, lastTextNode, null);
                    lastTextNode = null;
                }
                imageNode = new SemanticFigure((ImageChunk)content);
                imageNode.setRecognizedStructureId(content.getRecognizedStructureId());
                continue;
            }
            if (!(content instanceof TableBorder) || ((TableBorder)content).isTextBlock()) continue;
            if (imageNode != null && CaptionProcessor.isTextNotContainedInImage(imageNode, lastTextNode)) {
                CaptionProcessor.acceptImageCaption(contents, imageNode, lastTextNode, null);
                lastTextNode = null;
            }
            ImageChunk imageChunk = new ImageChunk(content.getBoundingBox());
            imageChunk.setRecognizedStructureId(content.getRecognizedStructureId());
            imageNode = new SemanticFigure(imageChunk);
            imageNode.setRecognizedStructureId(content.getRecognizedStructureId());
        }
        if (imageNode != null) {
            CaptionProcessor.acceptImageCaption(contents, imageNode, lastTextNode, null);
        }
    }

    public static boolean isTextNotContainedInImage(SemanticFigure image, SemanticTextNode text) {
        if (text == null) {
            return true;
        }
        double textSize = text.getFontSize();
        return !image.getBoundingBox().contains(text.getBoundingBox(), textSize * 1.0, textSize * 1.0);
    }

    private static void acceptImageCaption(List<IObject> contents, SemanticFigure imageNode, SemanticTextNode previousNode, SemanticTextNode nextNode) {
        SemanticTextNode captionNode;
        double captionProbability;
        double nextCaptionProbability;
        if (imageNode.getImages().isEmpty()) {
            return;
        }
        double previousCaptionProbability = CaptionUtils.imageCaptionProbability(previousNode, imageNode);
        if (previousCaptionProbability > (nextCaptionProbability = CaptionUtils.imageCaptionProbability(nextNode, imageNode))) {
            captionProbability = previousCaptionProbability;
            captionNode = previousNode;
        } else {
            captionProbability = nextCaptionProbability;
            captionNode = nextNode;
        }
        if (captionProbability >= 0.75) {
            SemanticCaption semanticCaption = new SemanticCaption(captionNode);
            contents.set(captionNode.getIndex(), semanticCaption);
            semanticCaption.setLinkedContentId(imageNode.getRecognizedStructureId());
        }
    }
}

