/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;

public class ClusterTableProcessor {
    public static void processClusterDetectionLists(List<IObject> contents) {
        ClusterTableConsumer clusterTableConsumer = new ClusterTableConsumer();
        for (IObject content : contents) {
            if (content instanceof TextChunk) {
                SemanticTextNode semanticTextNode = new SemanticTextNode((TextChunk)content);
                clusterTableConsumer.accept(new TableToken((TextChunk)content, (INode)semanticTextNode), semanticTextNode);
                continue;
            }
            if (!(content instanceof ImageChunk)) continue;
            SemanticFigure semanticFigure = new SemanticFigure((ImageChunk)content);
            clusterTableConsumer.accept(new TableToken((ImageChunk)content, (INode)semanticFigure), semanticFigure);
        }
        clusterTableConsumer.processEnd();
        for (PDFList list : clusterTableConsumer.getLists()) {
            ClusterTableProcessor.replaceContentsToResult(contents, list);
        }
    }

    public static void replaceContentsToResult(List<IObject> contents, IObject result) {
        LinkedList<IObject> replacedContents = new LinkedList<IObject>();
        Integer index = null;
        int i = 0;
        for (IObject content : contents) {
            if (ClusterTableProcessor.contains(result.getBoundingBox(), content.getBoundingBox())) {
                replacedContents.add(content);
                if (index == null) {
                    index = i;
                }
            }
            ++i;
        }
        if (index == null) {
            return;
        }
        contents.set(index, result);
        contents.removeAll(replacedContents);
    }

    public static boolean contains(BoundingBox box, BoundingBox box2) {
        if (box instanceof MultiBoundingBox) {
            for (BoundingBox b : ((MultiBoundingBox)box).getBoundingBoxes()) {
                if (!b.contains(box2, 0.6, 0.6)) continue;
                return true;
            }
        } else {
            return box.contains(box2, 0.6, 0.6);
        }
        return false;
    }
}

