/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opendataloader.pdf.api.Config;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.opendataloader.pdf.processors.HiddenTextProcessor;
import org.opendataloader.pdf.processors.TextProcessor;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class ContentFilterProcessor {
    private static final Logger LOGGER = Logger.getLogger(ContentFilterProcessor.class.getCanonicalName());

    public static List<IObject> getFilteredContents(String inputPdfName, List<IChunk> contents, int pageNumber, Config config) throws IOException {
        List<IObject> pageContents = new ArrayList<IObject>(contents);
        TextProcessor.removeSameTextChunks(pageContents);
        pageContents = DocumentProcessor.removeNullObjectsFromList(pageContents);
        TextProcessor.removeTextDecorationImages(pageContents);
        pageContents = DocumentProcessor.removeNullObjectsFromList(pageContents);
        if (config.getFilterConfig().isFilterTinyText()) {
            TextProcessor.filterTinyText(pageContents);
            pageContents = DocumentProcessor.removeNullObjectsFromList(pageContents);
        }
        if (config.getFilterConfig().isFilterOutOfPage()) {
            ContentFilterProcessor.filterOutOfPageContents(pageNumber, pageContents);
            pageContents = DocumentProcessor.removeNullObjectsFromList(pageContents);
        }
        TextProcessor.trimTextChunksWhiteSpaces(pageContents);
        pageContents = HiddenTextProcessor.findHiddenText(inputPdfName, pageContents, config.getFilterConfig().isFilterHiddenText(), config.getPassword());
        TextProcessor.replaceUndefinedCharacters(pageContents, config.getReplaceInvalidChars());
        ContentFilterProcessor.processBackgrounds(pageNumber, pageContents);
        return pageContents;
    }

    public static void processBackgrounds(int pageNumber, List<IObject> contents) {
        BoundingBox pageBoundingBox = DocumentProcessor.getPageBoundingBox(pageNumber);
        if (pageBoundingBox == null) {
            return;
        }
        HashSet<LineArtChunk> backgrounds = new HashSet<LineArtChunk>();
        for (IObject content : contents) {
            if (!(content instanceof LineArtChunk) || !ContentFilterProcessor.isBackground(content, pageBoundingBox)) continue;
            backgrounds.add((LineArtChunk)content);
        }
        if (!backgrounds.isEmpty()) {
            LOGGER.log(Level.WARNING, "Detected background on page " + pageNumber);
            contents.removeAll(backgrounds);
        }
    }

    private static boolean isBackground(IObject content, BoundingBox pageBoundingBox) {
        return content.getBoundingBox().getWidth() > 0.5 * pageBoundingBox.getWidth() && content.getBoundingBox().getHeight() > 0.1 * pageBoundingBox.getHeight() || content.getBoundingBox().getWidth() > 0.1 * pageBoundingBox.getWidth() && content.getBoundingBox().getHeight() > 0.5 * pageBoundingBox.getHeight();
    }

    private static void filterOutOfPageContents(int pageNumber, List<IObject> contents) {
        BoundingBox pageBoundingBox = DocumentProcessor.getPageBoundingBox(pageNumber);
        if (pageBoundingBox == null) {
            return;
        }
        for (int index = 0; index < contents.size(); ++index) {
            IObject object = contents.get(index);
            if (object == null || !pageBoundingBox.notOverlaps(object.getBoundingBox())) continue;
            contents.set(index, null);
        }
    }
}

