/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opendataloader.pdf.containers.StaticLayoutContainers;
import org.opendataloader.pdf.processors.CaptionProcessor;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.opendataloader.pdf.processors.HeadingProcessor;
import org.opendataloader.pdf.processors.ListProcessor;
import org.opendataloader.pdf.processors.ParagraphProcessor;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticHeaderOrFooter;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.ListIntervalsCollection;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.AlfaLettersListLabelsDetectionAlgorithm1;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.AlfaLettersListLabelsDetectionAlgorithm2;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ArabicNumbersListLabelsDetectionAlgorithm;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.KoreanLettersListLabelsDetectionAlgorithm;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.RomanNumbersListLabelsDetectionAlgorithm;

public class HeaderFooterProcessor {
    public static void processHeadersAndFooters(List<List<IObject>> contents) {
        DocumentProcessor.setIndexesForDocumentContents(contents);
        ArrayList<List<IObject>> sortedContents = new ArrayList<List<IObject>>();
        for (List<IObject> list : contents) {
            sortedContents.add(DocumentProcessor.sortContents(list));
        }
        ArrayList<List<IObject>> filteredSortedContents = new ArrayList<List<IObject>>();
        for (List list : sortedContents) {
            filteredSortedContents.add(list.stream().filter(c -> !(c instanceof LineChunk) && !(c instanceof LineArtChunk)).collect(Collectors.toList()));
        }
        List<SemanticHeaderOrFooter> list = HeaderFooterProcessor.getHeadersOrFooters(filteredSortedContents, false);
        List<SemanticHeaderOrFooter> list2 = HeaderFooterProcessor.getHeadersOrFooters(filteredSortedContents, true);
        for (int pageNumber = 0; pageNumber < contents.size(); ++pageNumber) {
            contents.set(pageNumber, HeaderFooterProcessor.updatePageContents(contents.get(pageNumber), list2.get(pageNumber), list.get(pageNumber)));
        }
        HeaderFooterProcessor.processHeadersOrFootersContents(list);
        HeaderFooterProcessor.processHeadersOrFootersContents(list2);
    }

    private static void processHeadersOrFootersContents(List<SemanticHeaderOrFooter> headersOrFooters) {
        for (SemanticHeaderOrFooter headerOrFooter : headersOrFooters) {
            if (headerOrFooter == null) continue;
            headerOrFooter.setContents(HeaderFooterProcessor.processHeaderOrFooterContent(headerOrFooter.getContents()));
        }
    }

    private static List<IObject> updatePageContents(List<IObject> pageContents, SemanticHeaderOrFooter header, SemanticHeaderOrFooter footer) {
        Iterator iterator;
        TreeSet<Integer> headerAndFooterIndexes = new TreeSet<Integer>();
        headerAndFooterIndexes.addAll(HeaderFooterProcessor.getHeaderOrFooterContentsIndexes(header));
        headerAndFooterIndexes.addAll(HeaderFooterProcessor.getHeaderOrFooterContentsIndexes(footer));
        if (headerAndFooterIndexes.isEmpty()) {
            return pageContents;
        }
        ArrayList<IObject> result = new ArrayList<IObject>();
        if (header != null) {
            result.add(header);
        }
        int nextHeaderOrFooterIndex = (iterator = headerAndFooterIndexes.iterator()).hasNext() ? ((Integer)iterator.next()).intValue() : pageContents.size();
        for (int index = 0; index < pageContents.size(); ++index) {
            if (index < nextHeaderOrFooterIndex) {
                result.add(pageContents.get(index));
                continue;
            }
            nextHeaderOrFooterIndex = iterator.hasNext() ? ((Integer)iterator.next()).intValue() : pageContents.size();
        }
        if (footer != null) {
            result.add(footer);
        }
        return result;
    }

    private static Set<Integer> getHeaderOrFooterContentsIndexes(SemanticHeaderOrFooter header) {
        if (header == null) {
            return Collections.emptySet();
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (IObject content : header.getContents()) {
            set.add(content.getIndex());
        }
        return set;
    }

    private static List<SemanticHeaderOrFooter> getHeadersOrFooters(List<List<IObject>> sortedContents, boolean isHeaderDetection) {
        ArrayList<SemanticHeaderOrFooter> headersOrFooters = new ArrayList<SemanticHeaderOrFooter>(sortedContents.size());
        List<Integer> numberOfHeaderOrFooterContentsForEachPage = HeaderFooterProcessor.getNumberOfHeaderOrFooterContentsForEachPage(sortedContents, isHeaderDetection);
        for (int pageNumber = 0; pageNumber < sortedContents.size(); ++pageNumber) {
            Integer currentIndex = numberOfHeaderOrFooterContentsForEachPage.get(pageNumber);
            if (currentIndex == 0) {
                headersOrFooters.add(null);
                continue;
            }
            List<IObject> pageContents = sortedContents.get(pageNumber);
            List<IObject> headerContents = HeaderFooterProcessor.filterHeaderOrFooterContents(isHeaderDetection ? pageContents.subList(0, currentIndex) : pageContents.subList(pageContents.size() - currentIndex, pageContents.size()), pageNumber, isHeaderDetection);
            if (headerContents.isEmpty()) {
                headersOrFooters.add(null);
                continue;
            }
            SemanticHeaderOrFooter semanticHeaderOrFooter = new SemanticHeaderOrFooter(isHeaderDetection ? SemanticType.HEADER : SemanticType.FOOTER);
            semanticHeaderOrFooter.addContents(headerContents);
            semanticHeaderOrFooter.setRecognizedStructureId(StaticLayoutContainers.incrementContentId());
            headersOrFooters.add(semanticHeaderOrFooter);
        }
        return headersOrFooters;
    }

    private static List<IObject> processHeaderOrFooterContent(List<IObject> contents) {
        List<IObject> newContents = ParagraphProcessor.processParagraphs(contents);
        newContents = ListProcessor.processListsFromTextNodes(newContents);
        HeadingProcessor.processHeadings(newContents);
        DocumentProcessor.setIDs(newContents);
        CaptionProcessor.processCaptions(newContents);
        return newContents;
    }

    private static List<Integer> getNumberOfHeaderOrFooterContentsForEachPage(List<List<IObject>> sortedContents, boolean isHeaderDetection) {
        ArrayList<Integer> numberOfHeaderOrFooterContentsForEachPage = new ArrayList<Integer>(sortedContents.size());
        for (int pageNumber = 0; pageNumber < sortedContents.size(); ++pageNumber) {
            numberOfHeaderOrFooterContentsForEachPage.add(0);
        }
        int currentIndex = 0;
        while (true) {
            ArrayList<IObject> contents = new ArrayList<IObject>(sortedContents.size());
            for (int pageNumber = 0; pageNumber < sortedContents.size(); ++pageNumber) {
                int index;
                if ((Integer)numberOfHeaderOrFooterContentsForEachPage.get(pageNumber) != currentIndex) {
                    contents.add(null);
                    continue;
                }
                List<IObject> pageContents = sortedContents.get(pageNumber);
                int n = index = isHeaderDetection ? currentIndex : pageContents.size() - 1 - currentIndex;
                if (index >= 0 && index < pageContents.size()) {
                    contents.add(pageContents.get(index));
                    continue;
                }
                contents.add(null);
            }
            Set<Integer> newIndexes = HeaderFooterProcessor.getIndexesOfHeaderOrFootersContents(contents);
            if (newIndexes.isEmpty()) break;
            for (Integer newIndex : newIndexes) {
                numberOfHeaderOrFooterContentsForEachPage.set(newIndex, currentIndex + 1);
            }
            ++currentIndex;
        }
        return numberOfHeaderOrFooterContentsForEachPage;
    }

    private static Set<Integer> getIndexesOfHeaderOrFootersContents(List<IObject> contents) {
        IObject nextObject;
        IObject currentObject;
        int pageNumber;
        HashSet<Integer> result = new HashSet<Integer>(contents.size());
        for (pageNumber = 0; pageNumber < contents.size() - 1; ++pageNumber) {
            currentObject = contents.get(pageNumber);
            nextObject = contents.get(pageNumber + 1);
            if (currentObject == null || nextObject == null || !HeaderFooterProcessor.arePossibleHeadersOrFooters(currentObject, nextObject, 1)) continue;
            result.add(pageNumber);
            result.add(pageNumber + 1);
        }
        for (pageNumber = 0; pageNumber < contents.size() - 2; ++pageNumber) {
            currentObject = contents.get(pageNumber);
            nextObject = contents.get(pageNumber + 2);
            if (currentObject == null || nextObject == null || !HeaderFooterProcessor.arePossibleHeadersOrFooters(currentObject, nextObject, 2)) continue;
            result.add(pageNumber);
            result.add(pageNumber + 2);
        }
        return result;
    }

    public static boolean isHeaderOrFooter(IObject content) {
        INode node;
        return content instanceof INode && ((node = (INode)content).getSemanticType() == SemanticType.HEADER || node.getSemanticType() == SemanticType.FOOTER);
    }

    private static List<IObject> filterHeaderOrFooterContents(List<IObject> contents, int pageNumber, boolean isHeaderDetection) {
        BoundingBox boundingBox = DocumentProcessor.getPageBoundingBox(pageNumber);
        if (boundingBox == null) {
            return contents;
        }
        ArrayList<IObject> result = new ArrayList<IObject>();
        for (IObject content : contents) {
            if (isHeaderDetection ? content.getBottomY() < boundingBox.getCenterY() : content.getTopY() > boundingBox.getCenterY()) continue;
            result.add(content);
        }
        return result;
    }

    private static boolean arePossibleHeadersOrFooters(IObject object1, IObject object2, int increment) {
        if (object1 instanceof TextLine && object2 instanceof TextLine) {
            if (!BoundingBox.areOverlapsBoundingBoxesExcludingPages(object1.getBoundingBox(), object2.getBoundingBox())) {
                return false;
            }
            TextLine line1 = (TextLine)object1;
            TextLine line2 = (TextLine)object2;
            if (!NodeUtils.areCloseNumbers(line1.getFontSize(), line2.getFontSize())) {
                return false;
            }
            SemanticTextNode textNode1 = new SemanticTextNode();
            textNode1.add(line1);
            SemanticTextNode textNode2 = new SemanticTextNode();
            textNode2.add(line2);
            if (Objects.equals(textNode1.getValue(), textNode2.getValue())) {
                return true;
            }
            ArrayList<SemanticTextNode> textNodes = new ArrayList<SemanticTextNode>(2);
            textNodes.add(textNode1);
            textNodes.add(textNode2);
            if (HeaderFooterProcessor.getHeadersOrFootersIntervals(textNodes, increment).size() == 1) {
                return true;
            }
        } else if (BoundingBox.areSameBoundingBoxesExcludingPages(object1.getBoundingBox(), object2.getBoundingBox())) {
            return true;
        }
        return false;
    }

    private static Set<ListInterval> getHeadersOrFootersIntervals(List<SemanticTextNode> textNodes, int increment) {
        ArrayList<ListItemTextInfo> textChildrenInfo = new ArrayList<ListItemTextInfo>(textNodes.size());
        for (int i = 0; i < textNodes.size(); ++i) {
            SemanticTextNode textNode = textNodes.get(i);
            TextLine line = textNode.getFirstNonSpaceLine();
            TextLine secondLine = textNode.getNonSpaceLine(1);
            textChildrenInfo.add(new ListItemTextInfo(i, textNode.getSemanticType(), line, line.getValue().trim(), secondLine == null));
        }
        Set<ListInterval> intervals = HeaderFooterProcessor.getHeadersOfFooterIntervals(textChildrenInfo, increment);
        return intervals;
    }

    private static Set<ListInterval> getHeadersOfFooterIntervals(List<ListItemTextInfo> itemsInfo, int increment) {
        ListIntervalsCollection listIntervals = new ListIntervalsCollection();
        listIntervals.putAll(new AlfaLettersListLabelsDetectionAlgorithm1(increment).getItemsIntervals(itemsInfo));
        listIntervals.putAll(new AlfaLettersListLabelsDetectionAlgorithm2(increment).getItemsIntervals(itemsInfo));
        listIntervals.putAll(new KoreanLettersListLabelsDetectionAlgorithm(increment).getItemsIntervals(itemsInfo));
        listIntervals.putAll(new RomanNumbersListLabelsDetectionAlgorithm(increment).getItemsIntervals(itemsInfo));
        ArabicNumbersListLabelsDetectionAlgorithm arabicNumbersListLabelsDetectionAlgorithm = new ArabicNumbersListLabelsDetectionAlgorithm(increment);
        arabicNumbersListLabelsDetectionAlgorithm.setHeaderOrFooterDetection(true);
        listIntervals.putAll(arabicNumbersListLabelsDetectionAlgorithm.getItemsIntervals(itemsInfo));
        ListIntervalsCollection correctIntervals = new ListIntervalsCollection(HeaderFooterProcessor.getEqualsItems(itemsInfo));
        for (ListInterval listInterval : listIntervals.getSet()) {
            LinkedList<String> labels = new LinkedList<String>();
            for (ListItemInfo info : listInterval.getListItemsInfos()) {
                labels.add(((ListItemTextInfo)info).getListItem());
            }
            if (!ListLabelsUtils.isListLabels(labels, increment)) continue;
            correctIntervals.put(listInterval);
        }
        return correctIntervals.getSet();
    }

    private static Set<ListInterval> getEqualsItems(List<ListItemTextInfo> itemsInfo) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        String value = null;
        ListInterval interval = new ListInterval();
        for (ListItemTextInfo info : itemsInfo) {
            if (!Objects.equals(info.getListItem(), value)) {
                if (interval.getNumberOfListItems() > 1) {
                    listIntervals.add(interval);
                }
                value = info.getListItem();
                interval = new ListInterval();
            }
            interval.getListItemsInfos().add(info);
        }
        if (interval.getNumberOfListItems() > 1) {
            listIntervals.add(interval);
        }
        return listIntervals;
    }
}

