/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opendataloader.pdf.containers.StaticLayoutContainers;
import org.opendataloader.pdf.utils.BulletedParagraphUtils;
import org.opendataloader.pdf.utils.TextNodeStatistics;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.text.TextStyle;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class HeadingProcessor {
    private static final double HEADING_PROBABILITY = 0.75;
    private static final double BULLETED_HEADING_PROBABILITY = 0.1;

    public static void processHeadings(List<IObject> contents) {
        TextNodeStatistics textNodeStatistics = new TextNodeStatistics();
        LinkedList<SemanticTextNode> textNodes = new LinkedList<SemanticTextNode>();
        for (IObject content : contents) {
            HeadingProcessor.processContent(textNodes, content, textNodeStatistics);
        }
        int textNodesCount = textNodes.size();
        for (int index = 0; index < textNodesCount; ++index) {
            SemanticTextNode textNode = (SemanticTextNode)textNodes.get(index);
            if (textNode.getSemanticType() == SemanticType.HEADING) continue;
            SemanticTextNode prevNode = index != 0 ? (SemanticTextNode)textNodes.get(index - 1) : null;
            SemanticTextNode nextNode = index + 1 < textNodesCount ? (SemanticTextNode)textNodes.get(index + 1) : null;
            double probability = NodeUtils.headingProbability(textNode, prevNode, nextNode, textNode);
            probability += textNodeStatistics.fontSizeRarityBoost(textNode);
            probability += textNodeStatistics.fontWeightRarityBoost(textNode);
            if (BulletedParagraphUtils.isBulletedParagraph(textNode)) {
                probability += 0.1;
            }
            if (!(probability > 0.75) || textNode.getSemanticType() == SemanticType.LIST) continue;
            textNode.setSemanticType(SemanticType.HEADING);
        }
        HeadingProcessor.setHeadings(contents);
    }

    private static void processContent(List<SemanticTextNode> textNodes, IObject content, TextNodeStatistics textNodeStatistics) {
        if (content instanceof SemanticTextNode) {
            SemanticTextNode textNode = (SemanticTextNode)content;
            if (!textNode.isSpaceNode()) {
                textNodes.add(textNode);
                textNodeStatistics.addTextNode(textNode);
            }
        } else if (content instanceof TableBorder) {
            TableBorder table = (TableBorder)content;
            if (table.isTextBlock()) {
                List<IObject> contents = table.getCell(0, 0).getContents();
                for (IObject textBlockContent : contents) {
                    HeadingProcessor.processContent(textNodes, textBlockContent, textNodeStatistics);
                }
            }
        } else if (content instanceof PDFList) {
            PDFList list = (PDFList)content;
            SemanticTextNode textNode = new SemanticTextNode();
            textNode.add(list.getListItems().get(0).getFirstLine());
        }
    }

    private static void setHeadings(List<IObject> contents) {
        for (int index = 0; index < contents.size(); ++index) {
            TableBorder table;
            IObject content = contents.get(index);
            if (content instanceof SemanticTextNode && ((INode)content).getSemanticType() == SemanticType.HEADING && !(content instanceof SemanticHeading)) {
                SemanticHeading heading = new SemanticHeading((SemanticTextNode)content);
                contents.set(index, heading);
                StaticLayoutContainers.getHeadings().add(heading);
            }
            if (!(content instanceof TableBorder) || !(table = (TableBorder)content).isTextBlock()) continue;
            List<IObject> textBlockContents = table.getCell(0, 0).getContents();
            HeadingProcessor.setHeadings(textBlockContents);
        }
    }

    public static void detectHeadingsLevels() {
        TreeMap<TextStyle, Set> map = new TreeMap<TextStyle, Set>();
        List<SemanticHeading> headings = StaticLayoutContainers.getHeadings();
        for (SemanticHeading heading : headings) {
            TextStyle textStyle = TextStyle.getTextStyle(heading);
            map.computeIfAbsent(textStyle, k -> new HashSet()).add(heading);
        }
        int level = 1;
        TextStyle previousTextStyle = null;
        for (Map.Entry entry : map.entrySet()) {
            if (previousTextStyle != null && previousTextStyle.compareTo((TextStyle)entry.getKey()) != 0) {
                ++level;
            }
            previousTextStyle = (TextStyle)entry.getKey();
            for (SemanticHeading heading : (Set)entry.getValue()) {
                heading.setHeadingLevel(level);
            }
        }
    }
}

