/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ContrastRatioConsumer;

public class HiddenTextProcessor {
    private static final double MIN_CONTRAST_RATIO = 1.2;

    public static List<IObject> findHiddenText(String pdfName, List<IObject> contents, boolean isFilterHiddenText, String password) throws IOException {
        LinkedList<IObject> result = new LinkedList<IObject>();
        try (ContrastRatioConsumer contrastRatioConsumer = new ContrastRatioConsumer(pdfName, password, false, null);){
            for (IObject content : contents) {
                if (content instanceof TextChunk) {
                    TextChunk textChunk = (TextChunk)content;
                    contrastRatioConsumer.calculateContrastRatio(textChunk);
                    if (textChunk.getContrastRatio() < 1.2) {
                        if (isFilterHiddenText) continue;
                        textChunk.setHiddenText(true);
                    }
                }
                result.add(content);
            }
        }
        return result;
    }
}

