/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opendataloader.pdf.utils.BulletedParagraphUtils;
import org.opendataloader.pdf.utils.levels.LevelInfo;
import org.opendataloader.pdf.utils.levels.LineArtBulletParagraphLevelInfo;
import org.opendataloader.pdf.utils.levels.ListLevelInfo;
import org.opendataloader.pdf.utils.levels.TableLevelInfo;
import org.opendataloader.pdf.utils.levels.TextBulletParagraphLevelInfo;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class LevelProcessor {
    private static final Logger LOGGER = Logger.getLogger(LevelProcessor.class.getCanonicalName());
    private static boolean isDocTitleSet = false;

    public static void detectLevels(List<List<IObject>> contents) {
        LevelProcessor.setLevels(contents, new Stack<LevelInfo>());
    }

    private static void setLevels(List<List<IObject>> contents, Stack<LevelInfo> levelInfos) {
        int levelInfosSize = levelInfos.size();
        for (List<IObject> pageContents : contents) {
            for (IObject content : pageContents) {
                if (content instanceof SemanticHeading) {
                    LevelProcessor.setLevelForHeading((SemanticHeading)content);
                    continue;
                }
                LevelInfo levelInfo = null;
                Integer index = null;
                if (content instanceof PDFList) {
                    PDFList previousList = ((PDFList)content).getPreviousList();
                    if (previousList != null) {
                        if (previousList.getLevel() == null) {
                            LOGGER.log(Level.WARNING, "List without detected level");
                        } else {
                            index = Integer.parseInt(previousList.getLevel()) - 1;
                        }
                    }
                    if (index == null) {
                        levelInfo = new ListLevelInfo((PDFList)content);
                    }
                } else if (content instanceof TableBorder) {
                    TableBorder previousTable = ((TableBorder)content).getPreviousTable();
                    if (previousTable != null) {
                        if (previousTable.getLevel() == null) {
                            LOGGER.log(Level.WARNING, "Table without detected level");
                        } else {
                            index = Integer.parseInt(previousTable.getLevel()) - 1;
                        }
                    }
                    if (index == null) {
                        TableBorder table = (TableBorder)content;
                        LevelProcessor.setLevelForTable(table);
                        if (!table.isTextBlock()) {
                            levelInfo = new TableLevelInfo(table);
                        }
                    }
                } else if (content instanceof SemanticTextNode && BulletedParagraphUtils.isBulletedParagraph((SemanticTextNode)content)) {
                    levelInfo = BulletedParagraphUtils.isBulletedLineArtParagraph((SemanticTextNode)content) ? new LineArtBulletParagraphLevelInfo((SemanticTextNode)content) : new TextBulletParagraphLevelInfo((SemanticTextNode)content);
                }
                if (levelInfo == null && index == null) continue;
                if (index == null) {
                    index = LevelProcessor.getLevelInfoIndex(levelInfos, levelInfo);
                }
                if (index == null) {
                    content.setLevel(String.valueOf(levelInfos.size() + 1));
                    levelInfos.add(levelInfo);
                } else {
                    content.setLevel(String.valueOf(index + 1));
                    for (int i = Math.max(index + 1, levelInfosSize); i < levelInfos.size(); ++i) {
                        levelInfos.pop();
                    }
                }
                if (!(content instanceof PDFList)) continue;
                for (ListItem listItem : ((PDFList)content).getListItems()) {
                    LevelProcessor.setLevels(Collections.singletonList(listItem.getContents()), levelInfos);
                }
            }
        }
        isDocTitleSet = false;
    }

    private static void setLevelForHeading(SemanticHeading heading) {
        if (heading.getHeadingLevel() == 1 && !isDocTitleSet) {
            heading.setLevel("Doctitle");
            isDocTitleSet = true;
        } else {
            heading.setLevel("Subtitle");
        }
    }

    private static Integer getLevelInfoIndex(Stack<LevelInfo> levelInfos, LevelInfo levelInfo) {
        for (int index = 0; index < levelInfos.size(); ++index) {
            LevelInfo currentLevelInfo = (LevelInfo)levelInfos.get(index);
            if (!LevelInfo.areSameLevelsInfos(currentLevelInfo, levelInfo)) continue;
            return index;
        }
        return null;
    }

    private static void setLevelForTable(TableBorder tableBorder) {
        for (int rowNumber = 0; rowNumber < tableBorder.getNumberOfRows(); ++rowNumber) {
            TableBorderRow row = tableBorder.getRow(rowNumber);
            for (int colNumber = 0; colNumber < tableBorder.getNumberOfColumns(); ++colNumber) {
                TableBorderCell tableBorderCell = row.getCell(colNumber);
                if (tableBorderCell.getRowNumber() != rowNumber || tableBorderCell.getColNumber() != colNumber) continue;
                LevelProcessor.setLevels(Collections.singletonList(tableBorderCell.getContents()), new Stack<LevelInfo>());
            }
        }
    }
}

