/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.opendataloader.pdf.utils.BulletedParagraphUtils;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.content.TextBlock;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.TextAlignment;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.CaptionUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class ParagraphProcessor {
    public static final double DIFFERENT_LINES_PROBABILITY = 0.75;

    public static List<IObject> processParagraphs(List<IObject> contents) {
        DocumentProcessor.setIndexesForContentsList(contents);
        List<TextBlock> blocks = new ArrayList<TextBlock>();
        for (IObject content : contents) {
            if (!(content instanceof TextLine)) continue;
            blocks.add(new TextBlock((TextLine)content));
        }
        blocks = ParagraphProcessor.detectParagraphsWithJustifyAlignments(blocks);
        blocks = ParagraphProcessor.detectFirstAndLastLinesOfParagraphsWithJustifyAlignments(blocks);
        blocks = ParagraphProcessor.detectParagraphsWithLeftAlignments(blocks);
        blocks = ParagraphProcessor.detectFirstLinesOfParagraphWithLeftAlignments(blocks);
        blocks = ParagraphProcessor.detectTwoLinesParagraphs(blocks);
        blocks = ParagraphProcessor.detectBulletedParagraphsWithLeftAlignments(blocks);
        blocks = ParagraphProcessor.detectParagraphsWithCenterAlignments(blocks);
        blocks = ParagraphProcessor.detectParagraphsWithRightAlignments(blocks);
        blocks = ParagraphProcessor.processOtherLines(blocks);
        return ParagraphProcessor.getContentsWithDetectedParagraphs(contents, blocks);
    }

    private static List<IObject> getContentsWithDetectedParagraphs(List<IObject> contents, List<TextBlock> blocks) {
        ArrayList<IObject> newContents = new ArrayList<IObject>();
        Iterator<TextBlock> iterator = blocks.iterator();
        TextBlock currentBlock = iterator.hasNext() ? iterator.next() : null;
        Integer currentIndex = currentBlock != null ? currentBlock.getFirstLine().getIndex() : null;
        for (int index = 0; index < contents.size(); ++index) {
            IObject content = contents.get(index);
            if (!(content instanceof TextLine)) {
                newContents.add(content);
                continue;
            }
            if (!Objects.equals(currentIndex, index)) continue;
            newContents.add(ParagraphProcessor.createParagraphFromTextBlock(currentBlock));
            currentBlock = iterator.hasNext() ? iterator.next() : null;
            currentIndex = currentBlock != null ? currentBlock.getFirstLine().getIndex() : null;
        }
        return newContents;
    }

    private static List<TextBlock> detectParagraphsWithJustifyAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                TextBlock nextBlock = textBlocks.get(i);
                TextAlignment textAlignment = ChunksMergeUtils.getAlignment(previousBlock.getLastLine(), nextBlock.getFirstLine());
                double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
                if (textAlignment == TextAlignment.JUSTIFY && probability > 0.75) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.JUSTIFY);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static List<TextBlock> detectParagraphsWithCenterAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                TextBlock nextBlock = textBlocks.get(i);
                TextAlignment textAlignment = ChunksMergeUtils.getAlignment(previousBlock.getLastLine(), nextBlock.getFirstLine());
                double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
                if (textAlignment == TextAlignment.CENTER && probability > 0.75) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.CENTER);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static List<TextBlock> detectFirstAndLastLinesOfParagraphsWithJustifyAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                double probability;
                TextAlignment textAlignment;
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.isFirstLineOfBlock(previousBlock, nextBlock = textBlocks.get(i), textAlignment = ChunksMergeUtils.getAlignment(previousBlock.getLastLine(), nextBlock.getFirstLine()), probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.JUSTIFY);
                    previousBlock.setHasStartLine(true);
                    previousBlock.setHasEndLine(nextBlock.isHasEndLine());
                    continue;
                }
                if (ParagraphProcessor.isLastLineOfBlock(previousBlock, nextBlock, textAlignment, probability)) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setHasEndLine(true);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static List<TextBlock> detectParagraphsWithLeftAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.areLinesOfParagraphsWithLeftAlignments(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.LEFT);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static boolean areLinesOfParagraphsWithRightAlignments(TextBlock previousBlock, TextBlock nextBlock) {
        TextAlignment textAlignment = ChunksMergeUtils.getAlignment(previousBlock.getLastLine(), nextBlock.getFirstLine());
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return !(textAlignment != TextAlignment.RIGHT || !(probability > 0.75) || previousBlock.getLinesNumber() != 1 && previousBlock.getTextAlignment() != TextAlignment.RIGHT || nextBlock.getLinesNumber() != 1 && nextBlock.getTextAlignment() != TextAlignment.RIGHT);
    }

    private static boolean areLinesOfParagraphsWithLeftAlignments(TextBlock previousBlock, TextBlock nextBlock) {
        TextAlignment textAlignment = ChunksMergeUtils.getAlignment(previousBlock.getLastLine(), nextBlock.getFirstLine());
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return !(textAlignment != TextAlignment.LEFT || !(probability > 0.75) || previousBlock.getLinesNumber() != 1 && previousBlock.getTextAlignment() != TextAlignment.LEFT || nextBlock.getLinesNumber() != 1 && nextBlock.getTextAlignment() != TextAlignment.LEFT || BulletedParagraphUtils.isLabeledLine(nextBlock.getFirstLine()));
    }

    private static List<TextBlock> detectFirstLinesOfParagraphWithLeftAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.isFirstLineOfParagraphWithLeftAlignment(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.LEFT);
                    previousBlock.setHasStartLine(true);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static boolean isFirstLineOfParagraphWithLeftAlignment(TextBlock previousBlock, TextBlock nextBlock) {
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return previousBlock.getLinesNumber() == 1 && previousBlock.getLastLine().getLeftX() > nextBlock.getFirstLine().getLeftX() && CaptionUtils.areOverlapping(previousBlock.getLastLine(), nextBlock.getFirstLine().getBoundingBox()) && nextBlock.getTextAlignment() == TextAlignment.LEFT && !nextBlock.isHasStartLine() && probability > 0.75 && !BulletedParagraphUtils.isLabeledLine(nextBlock.getFirstLine());
    }

    private static List<TextBlock> detectTwoLinesParagraphs(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.isTwoLinesParagraph(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.LEFT);
                    previousBlock.setHasStartLine(true);
                    previousBlock.setHasEndLine(true);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static boolean isTwoLinesParagraph(TextBlock previousBlock, TextBlock nextBlock) {
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return previousBlock.getLinesNumber() == 1 && nextBlock.getLinesNumber() == 1 && previousBlock.getLastLine().getLeftX() > nextBlock.getFirstLine().getLeftX() && previousBlock.getLastLine().getRightX() > nextBlock.getFirstLine().getRightX() && probability > 0.75 && !BulletedParagraphUtils.isLabeledLine(nextBlock.getFirstLine());
    }

    private static boolean isFirstLineOfBulletedParagraphWithLeftAlignment(TextBlock previousBlock, TextBlock nextBlock) {
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return previousBlock.getLinesNumber() == 1 && previousBlock.getLastLine().getLeftX() < nextBlock.getFirstLine().getLeftX() && CaptionUtils.areOverlapping(previousBlock.getLastLine(), nextBlock.getFirstLine().getBoundingBox()) && (nextBlock.getTextAlignment() == TextAlignment.LEFT || nextBlock.getLinesNumber() == 1) && !nextBlock.isHasStartLine() && probability > 0.75 && BulletedParagraphUtils.isLabeledLine(previousBlock.getFirstLine()) && !BulletedParagraphUtils.isLabeledLine(nextBlock.getFirstLine());
    }

    private static List<TextBlock> detectParagraphsWithRightAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.areLinesOfParagraphsWithRightAlignments(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.RIGHT);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static List<TextBlock> detectBulletedParagraphsWithLeftAlignments(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.isFirstLineOfBulletedParagraphWithLeftAlignment(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    previousBlock.setTextAlignment(TextAlignment.LEFT);
                    previousBlock.setHasStartLine(true);
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static List<TextBlock> processOtherLines(List<TextBlock> textBlocks) {
        ArrayList<TextBlock> newBlocks = new ArrayList<TextBlock>();
        if (!textBlocks.isEmpty()) {
            newBlocks.add(textBlocks.get(0));
        }
        if (textBlocks.size() > 1) {
            for (int i = 1; i < textBlocks.size(); ++i) {
                TextBlock nextBlock;
                TextBlock previousBlock = (TextBlock)newBlocks.get(newBlocks.size() - 1);
                if (ParagraphProcessor.isOneParagraph(previousBlock, nextBlock = textBlocks.get(i))) {
                    previousBlock.add(nextBlock.getLines());
                    continue;
                }
                newBlocks.add(nextBlock);
            }
        }
        return newBlocks;
    }

    private static boolean isOneParagraph(TextBlock previousBlock, TextBlock nextBlock) {
        if (!ParagraphProcessor.areCloseStyle(previousBlock, nextBlock)) {
            return false;
        }
        double probability = ParagraphProcessor.getDifferentLinesProbability(previousBlock, nextBlock);
        return !(!CaptionUtils.areOverlapping(previousBlock.getLastLine(), nextBlock.getFirstLine().getBoundingBox()) || !(probability > 0.75) || previousBlock.getLinesNumber() != 1 && previousBlock.getTextAlignment() != null || nextBlock.getLinesNumber() != 1 && nextBlock.getTextAlignment() != null || BulletedParagraphUtils.isLabeledLine(nextBlock.getFirstLine()));
    }

    private static boolean isFirstLineOfBlock(TextBlock previousBlock, TextBlock nextBlock, TextAlignment textAlignment, double probability) {
        return previousBlock.getLinesNumber() == 1 && textAlignment == TextAlignment.RIGHT && nextBlock.getTextAlignment() == TextAlignment.JUSTIFY && !nextBlock.isHasStartLine() && probability > 0.75;
    }

    private static boolean isLastLineOfBlock(TextBlock previousBlock, TextBlock nextBlock, TextAlignment textAlignment, double probability) {
        return nextBlock.getLinesNumber() == 1 && textAlignment == TextAlignment.LEFT && previousBlock.getTextAlignment() == TextAlignment.JUSTIFY && !previousBlock.isHasEndLine() && probability > 0.75;
    }

    private static SemanticParagraph createParagraphFromTextBlock(TextBlock textBlock) {
        SemanticParagraph textParagraph = new SemanticParagraph();
        textParagraph.getColumns().add(new TextColumn());
        textParagraph.getLastColumn().getBlocks().add(textBlock);
        textParagraph.getBoundingBox().union(textBlock.getBoundingBox());
        textParagraph.setCorrectSemanticScore(1.0);
        textParagraph.setHiddenText(textBlock.isHiddenText());
        return textParagraph;
    }

    private static double getDifferentLinesProbability(TextBlock previousBlock, TextBlock nextBlock) {
        if (previousBlock.isHiddenText() != nextBlock.isHiddenText()) {
            return 0.0;
        }
        if (previousBlock.getLinesNumber() == 1 && nextBlock.getLinesNumber() == 1) {
            return ChunksMergeUtils.mergeLeadingProbability(previousBlock.getLastLine(), nextBlock.getFirstLine());
        }
        if (previousBlock.getLinesNumber() == 1) {
            return ChunksMergeUtils.mergeLeadingProbability(previousBlock.getLastLine(), nextBlock);
        }
        if (nextBlock.getLinesNumber() == 1) {
            return ChunksMergeUtils.mergeLeadingProbability(previousBlock, nextBlock.getFirstLine());
        }
        return 0.0;
    }

    private static boolean areCloseStyle(TextBlock previousBlock, TextBlock nextBlock) {
        return NodeUtils.areCloseNumbers(previousBlock.getFontSize(), nextBlock.getFontSize(), 0.1) && NodeUtils.areCloseNumbers(previousBlock.getFirstLine().getFirstTextChunk().getFontWeight(), nextBlock.getFirstLine().getFirstTextChunk().getFontWeight(), 0.1);
    }
}

