/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opendataloader.pdf.processors.CaptionProcessor;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.opendataloader.pdf.processors.HeaderFooterProcessor;
import org.opendataloader.pdf.processors.HeadingProcessor;
import org.opendataloader.pdf.processors.ListProcessor;
import org.opendataloader.pdf.processors.ParagraphProcessor;
import org.opendataloader.pdf.processors.TextLineProcessor;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class TableBorderProcessor {
    private static final double LINE_ART_PERCENT = 0.9;
    private static final double NEIGHBOUR_TABLE_EPSILON = 0.2;

    public static List<IObject> processTableBorders(List<IObject> contents, int pageNumber) {
        ArrayList<IObject> newContents = new ArrayList<IObject>();
        HashSet<TableBorder> processedTableBorders = new HashSet<TableBorder>();
        for (IObject content : contents) {
            TableBorder tableBorder = TableBorderProcessor.addContentToTableBorder(content);
            if (tableBorder != null) {
                if (processedTableBorders.contains(tableBorder)) continue;
                processedTableBorders.add(tableBorder);
                newContents.add(tableBorder);
                continue;
            }
            newContents.add(content);
        }
        for (TableBorder border : processedTableBorders) {
            StaticContainers.getTableBordersCollection().removeTableBorder(border, pageNumber);
            TableBorderProcessor.processTableBorder(border, pageNumber);
        }
        return newContents;
    }

    private static TableBorder addContentToTableBorder(IObject content) {
        TableBorder tableBorder = StaticContainers.getTableBordersCollection().getTableBorder(content.getBoundingBox());
        if (tableBorder != null) {
            if (content instanceof LineChunk) {
                return tableBorder.isOneCellTable() ? null : tableBorder;
            }
            if (content instanceof LineArtChunk && BoundingBox.areSameBoundingBoxes(tableBorder.getBoundingBox(), content.getBoundingBox())) {
                return tableBorder;
            }
            Set<TableBorderCell> tableBorderCells = tableBorder.getTableBorderCells(content);
            if (!tableBorderCells.isEmpty()) {
                if (tableBorderCells.size() > 1 && content instanceof TextChunk) {
                    TextChunk textChunk = (TextChunk)content;
                    for (TableBorderCell tableBorderCell : tableBorderCells) {
                        TextChunk currentTextChunk = TableBorderProcessor.getTextChunkPartForTableCell(textChunk, tableBorderCell);
                        if (currentTextChunk == null || currentTextChunk.isEmpty()) continue;
                        tableBorderCell.addContentObject(currentTextChunk);
                    }
                } else {
                    Iterator<TableBorderCell> iterator = tableBorderCells.iterator();
                    if (iterator.hasNext()) {
                        TableBorderCell tableBorderCell = iterator.next();
                        if (content instanceof LineArtChunk && tableBorderCell.getBoundingBox().getIntersectionPercent(content.getBoundingBox()) > 0.9) {
                            return tableBorder;
                        }
                        tableBorderCell.addContentObject(content);
                    }
                }
                return tableBorder;
            }
            if (content instanceof LineArtChunk) {
                return tableBorder;
            }
        }
        return null;
    }

    public static void processTableBorder(TableBorder tableBorder, int pageNumber) {
        for (int rowNumber = 0; rowNumber < tableBorder.getNumberOfRows(); ++rowNumber) {
            TableBorderRow row = tableBorder.getRow(rowNumber);
            for (int colNumber = 0; colNumber < tableBorder.getNumberOfColumns(); ++colNumber) {
                TableBorderCell tableBorderCell = row.getCell(colNumber);
                if (tableBorderCell.getRowNumber() != rowNumber || tableBorderCell.getColNumber() != colNumber) continue;
                tableBorderCell.setContents(TableBorderProcessor.processTableCellContent(tableBorderCell.getContents(), pageNumber));
            }
        }
    }

    private static List<IObject> processTableCellContent(List<IObject> contents, int pageNumber) {
        List newContents = TableBorderProcessor.processTableBorders(contents, pageNumber);
        newContents = TextLineProcessor.processTextLines(newContents);
        ArrayList<List<IObject>> contentsList = new ArrayList<List<IObject>>(1);
        contentsList.add(newContents);
        ListProcessor.processLists(contentsList, true);
        newContents = (List)contentsList.get(0);
        newContents = ParagraphProcessor.processParagraphs(newContents);
        newContents = ListProcessor.processListsFromTextNodes(newContents);
        HeadingProcessor.processHeadings(newContents);
        DocumentProcessor.setIDs(newContents);
        CaptionProcessor.processCaptions(newContents);
        contentsList.set(0, newContents);
        ListProcessor.checkNeighborLists(contentsList);
        newContents = (List)contentsList.get(0);
        return newContents;
    }

    public static void checkNeighborTables(List<List<IObject>> contents) {
        TableBorder previousTable = null;
        for (List<IObject> iObjects : contents) {
            for (IObject content : iObjects) {
                if (content instanceof TableBorder && !((TableBorder)content).isTextBlock()) {
                    TableBorder currentTable = (TableBorder)content;
                    if (previousTable != null) {
                        TableBorderProcessor.checkNeighborTables(previousTable, currentTable);
                    }
                    previousTable = currentTable;
                    continue;
                }
                if (HeaderFooterProcessor.isHeaderOrFooter(content) || content instanceof LineChunk || content instanceof LineArtChunk) continue;
                previousTable = null;
            }
        }
    }

    private static void checkNeighborTables(TableBorder previousTable, TableBorder currentTable) {
        if (currentTable.getNumberOfColumns() != previousTable.getNumberOfColumns()) {
            return;
        }
        if (!NodeUtils.areCloseNumbers(currentTable.getWidth(), previousTable.getWidth(), 0.2)) {
            return;
        }
        for (int columnNumber = 0; columnNumber < previousTable.getNumberOfColumns(); ++columnNumber) {
            TableBorderCell cell1 = previousTable.getCell(0, columnNumber);
            TableBorderCell cell2 = currentTable.getCell(0, columnNumber);
            if (NodeUtils.areCloseNumbers(cell1.getWidth(), cell2.getWidth(), 0.2)) continue;
            return;
        }
        previousTable.setNextTable(currentTable);
        currentTable.setPreviousTable(previousTable);
    }

    private static TextChunk getTextChunkPartForTableCell(TextChunk textChunk, TableBorderCell cell) {
        Integer start = textChunk.getSymbolStartIndexByCoordinate(cell.getLeftX());
        if (start == null) {
            return null;
        }
        Integer end = textChunk.getSymbolEndIndexByCoordinate(cell.getRightX());
        if (end == null) {
            return null;
        }
        TextChunk result = TextChunk.getTextChunk(textChunk, start, end);
        return ChunksMergeUtils.getTrimTextChunk(result);
    }
}

