/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;

public class TextLineProcessor {
    private static final double ONE_LINE_PROBABILITY = 0.75;

    public static List<IObject> processTextLines(List<IObject> contents) {
        ArrayList<IObject> newContents = new ArrayList<IObject>();
        TextLine previousLine = new TextLine(new TextChunk(""));
        boolean isSeparateLine = false;
        for (IObject content : contents) {
            if (content instanceof TextChunk) {
                TextChunk textChunk = (TextChunk)content;
                if (textChunk.isWhiteSpaceChunk() || textChunk.isEmpty()) continue;
                TextLine currentLine = new TextLine(textChunk);
                double oneLineProbability = ChunksMergeUtils.countOneLineProbability(new SemanticTextNode(), previousLine, currentLine);
                if (isSeparateLine |= oneLineProbability < 0.75 || previousLine.isHiddenText() != currentLine.isHiddenText()) {
                    previousLine.setBoundingBox(new BoundingBox(previousLine.getBoundingBox()));
                    previousLine = currentLine;
                    newContents.add(previousLine);
                } else {
                    previousLine.add(currentLine);
                }
                isSeparateLine = false;
                continue;
            }
            if (content instanceof TableBorder) {
                isSeparateLine = true;
            }
            newContents.add(content);
        }
        TextLineProcessor.linkTextLinesWithConnectedLineArtBullet(newContents);
        return newContents;
    }

    private static void linkTextLinesWithConnectedLineArtBullet(List<IObject> contents) {
        LineArtChunk lineArtChunk = null;
        for (IObject content : contents) {
            if (content instanceof LineArtChunk) {
                lineArtChunk = (LineArtChunk)content;
                continue;
            }
            if (content instanceof TableBorder) {
                lineArtChunk = null;
            }
            if (!(content instanceof TextLine) || lineArtChunk == null) continue;
            TextLine textLine = (TextLine)content;
            if (TextLineProcessor.isLineConnectedWithLineArt(textLine, lineArtChunk)) {
                textLine.setConnectedLineArtLabel(lineArtChunk);
            }
            lineArtChunk = null;
        }
    }

    private static boolean isLineConnectedWithLineArt(TextLine textLine, LineArtChunk lineArt) {
        return lineArt.getRightX() <= textLine.getLeftX() && lineArt.getBoundingBox().getHeight() < 2.5 * textLine.getBoundingBox().getHeight();
    }
}

